/*
 * Decompiled with CFR 0.152.
 */
package com._14ercooper.worldeditor.brush.shapes;

import com._14ercooper.worldeditor.blockiterator.BlockIterator;
import com._14ercooper.worldeditor.blockiterator.IteratorManager;
import com._14ercooper.worldeditor.blockiterator.iterators.MultiIterator;
import com._14ercooper.worldeditor.brush.BrushShape;
import com._14ercooper.worldeditor.main.Main;
import java.util.ArrayList;
import java.util.HashSet;
import org.bukkit.World;
import org.bukkit.command.CommandSender;

public class RandomSplatter
extends BrushShape {
    int splatterRadiusMin;
    int splatterRadiusMax;
    int sphereCountMin;
    int sphereCountMax;
    int sphereRadiusMin;
    int sphereRadiusMax;
    String correction = "0.5";
    int gotArgs = 0;

    @Override
    public BlockIterator GetBlocks_impl(double x, double y, double z, World world, CommandSender sender) {
        int spheresGenerated = 0;
        HashSet<BlockIterator> spheres = new HashSet<BlockIterator>();
        int sphereCount = Main.randRange(this.sphereCountMin, this.sphereCountMax);
        while (spheresGenerated < sphereCount) {
            int splatterRadius = Main.randRange(this.splatterRadiusMin, this.splatterRadiusMax);
            double xOff = Main.getRand().nextInt(splatterRadius) * (Main.getRand().nextInt(2) == 0 ? -1 : 1);
            double yOff = Main.getRand().nextInt(splatterRadius) * (Main.getRand().nextInt(2) == 0 ? -1 : 1);
            int n = Main.getRand().nextInt(splatterRadius);
            int n2 = Main.getRand().nextInt(2) == 0 ? -1 : 1;
            double zOff = n * n2;
            if (!(xOff * xOff + yOff * yOff + zOff * zOff < (double)(splatterRadius * splatterRadius) + 0.5)) continue;
            int sphereRadius = Main.randRange(this.sphereRadiusMin, this.sphereRadiusMax);
            ArrayList<String> argList = new ArrayList<String>();
            argList.add(Integer.toString((int)(x + xOff)));
            argList.add(Integer.toString((int)(y + yOff)));
            argList.add(Integer.toString((int)(z + zOff)));
            argList.add(Integer.toString(sphereRadius));
            argList.add(Integer.toString(0));
            argList.add(this.correction);
            spheres.add(IteratorManager.INSTANCE.getIterator("sphere").newIterator(argList, world, sender));
            ++spheresGenerated;
        }
        return ((MultiIterator)IteratorManager.INSTANCE.getIterator("multi")).newIterator(spheres);
    }

    @Override
    public void addNewArgument(String argument) {
        if (this.gotArgs == 0) {
            this.splatterRadiusMin = Integer.parseInt(argument);
        } else if (this.gotArgs == 1) {
            this.splatterRadiusMax = Integer.parseInt(argument);
        } else if (this.gotArgs == 2) {
            this.sphereCountMin = Integer.parseInt(argument);
        } else if (this.gotArgs == 3) {
            this.sphereCountMax = Integer.parseInt(argument);
        } else if (this.gotArgs == 4) {
            this.sphereRadiusMin = Integer.parseInt(argument);
        } else if (this.gotArgs == 5) {
            this.sphereRadiusMax = Integer.parseInt(argument);
        } else if (this.gotArgs == 6) {
            try {
                Double.parseDouble(argument);
                this.correction = argument;
            }
            catch (NumberFormatException e) {
                ++this.gotArgs;
            }
        }
        ++this.gotArgs;
    }

    @Override
    public boolean lastInputProcessed() {
        return this.gotArgs < 8;
    }

    @Override
    public boolean gotEnoughArgs() {
        return this.gotArgs <= 5;
    }

    @Override
    public int minArgCount() {
        return 6;
    }
}

