/*
 * Decompiled with CFR 0.152.
 */
package com._14ercooper.worldeditor.brush.shapes;

import com._14ercooper.worldeditor.blockiterator.BlockIterator;
import com._14ercooper.worldeditor.blockiterator.IteratorManager;
import com._14ercooper.worldeditor.brush.BrushShape;
import com._14ercooper.worldeditor.main.Main;
import java.util.LinkedList;
import org.bukkit.World;
import org.bukkit.command.CommandSender;

public class RandomSphere
extends BrushShape {
    int radiusMin;
    int radiusMax;
    String correction = "0.5";
    int gotArgs;

    @Override
    public BlockIterator GetBlocks_impl(double x, double y, double z, World world, CommandSender sender) {
        LinkedList<String> argList = new LinkedList<String>();
        int radius = Main.randRange(this.radiusMin, this.radiusMax);
        argList.add(Integer.toString((int)x));
        argList.add(Integer.toString((int)y));
        argList.add(Integer.toString((int)z));
        argList.add(Integer.toString(radius));
        argList.add(Integer.toString(0));
        argList.add(this.correction);
        return IteratorManager.INSTANCE.getIterator("sphere").newIterator(argList, world, sender);
    }

    @Override
    public void addNewArgument(String argument) {
        if (this.gotArgs == 0) {
            this.radiusMin = Integer.parseInt(argument);
        } else if (this.gotArgs == 1) {
            this.radiusMax = Integer.parseInt(argument);
        } else if (this.gotArgs == 2) {
            try {
                Double.parseDouble(argument);
                this.correction = argument;
            }
            catch (NumberFormatException e) {
                ++this.gotArgs;
            }
        }
        ++this.gotArgs;
    }

    @Override
    public boolean lastInputProcessed() {
        return this.gotArgs < 4;
    }

    @Override
    public boolean gotEnoughArgs() {
        return this.gotArgs <= 1;
    }

    @Override
    public int minArgCount() {
        return 2;
    }
}

