/*
 * Decompiled with CFR 0.152.
 */
package com._14ercooper.worldeditor.brush.shapes;

import com._14ercooper.worldeditor.blockiterator.BlockIterator;
import com._14ercooper.worldeditor.blockiterator.IteratorManager;
import com._14ercooper.worldeditor.brush.BrushShape;
import com._14ercooper.worldeditor.main.Main;
import java.util.ArrayList;
import org.bukkit.World;
import org.bukkit.command.CommandSender;

public class RandomCube
extends BrushShape {
    int sideMin;
    int sideMax;
    int argsSeen = 0;

    @Override
    public BlockIterator GetBlocks_impl(double x, double y, double z, World world, CommandSender sender) {
        ArrayList<String> argList = new ArrayList<String>();
        int cubeRad = Main.randRange(this.sideMin, this.sideMax) / 2;
        argList.add(Integer.toString((int)x - cubeRad));
        argList.add(Integer.toString((int)y - cubeRad));
        argList.add(Integer.toString((int)z - cubeRad));
        argList.add(Integer.toString((int)x + cubeRad));
        argList.add(Integer.toString((int)y + cubeRad));
        argList.add(Integer.toString((int)z + cubeRad));
        return IteratorManager.INSTANCE.getIterator("cube").newIterator(argList, world, sender);
    }

    @Override
    public void addNewArgument(String argument) {
        if (this.argsSeen == 0) {
            this.sideMin = Integer.parseInt(argument);
        } else if (this.argsSeen == 1) {
            this.sideMax = Integer.parseInt(argument);
        }
        ++this.argsSeen;
    }

    @Override
    public boolean lastInputProcessed() {
        return this.argsSeen < 3;
    }

    @Override
    public boolean gotEnoughArgs() {
        return this.argsSeen <= 1;
    }

    @Override
    public int minArgCount() {
        return 2;
    }
}

