/*
 * Decompiled with CFR 0.152.
 */
package com._14ercooper.worldeditor.brush.shapes;

import com._14ercooper.worldeditor.blockiterator.BlockIterator;
import com._14ercooper.worldeditor.blockiterator.IteratorManager;
import com._14ercooper.worldeditor.brush.BrushShape;
import com._14ercooper.worldeditor.main.Main;
import java.util.ArrayList;
import org.bukkit.World;
import org.bukkit.command.CommandSender;

public class RandomBlob
extends BrushShape {
    int radiusMin;
    int radiusMax;
    int vectorCountMin = 2;
    int vectorCountMax = 5;
    String vectorAmplitude = "1.4";
    String radiusBoost = "0.2";
    String radiusCorrection = "0.5";
    int numArgsProcessed = 0;

    @Override
    public BlockIterator GetBlocks_impl(double x, double y, double z, World world, CommandSender sender) {
        ArrayList<String> argList = new ArrayList<String>();
        argList.add(Integer.toString((int)x));
        argList.add(Integer.toString((int)y));
        argList.add(Integer.toString((int)z));
        int radius = Main.randRange(this.radiusMin, this.radiusMax);
        int vectorCount = Main.randRange(this.vectorCountMin, this.vectorCountMax);
        argList.add(Integer.toString(radius));
        argList.add(Integer.toString(vectorCount));
        argList.add(this.vectorAmplitude);
        argList.add(this.radiusBoost);
        argList.add(this.radiusCorrection);
        return IteratorManager.INSTANCE.getIterator("blob").newIterator(argList, world, sender);
    }

    @Override
    public void addNewArgument(String argument) {
        if (this.numArgsProcessed == 0) {
            try {
                this.radiusMin = Integer.parseInt(argument);
            }
            catch (NumberFormatException e) {
                this.numArgsProcessed = 99;
            }
        } else if (this.numArgsProcessed == 1) {
            try {
                this.radiusMax = Integer.parseInt(argument);
            }
            catch (NumberFormatException e) {
                this.numArgsProcessed = 99;
            }
        } else if (this.numArgsProcessed == 2) {
            try {
                this.vectorCountMin = Integer.parseInt(argument);
            }
            catch (NumberFormatException e) {
                this.numArgsProcessed = 99;
            }
        } else if (this.numArgsProcessed == 3) {
            try {
                this.vectorCountMax = Integer.parseInt(argument);
            }
            catch (NumberFormatException e) {
                this.numArgsProcessed = 99;
            }
        } else if (this.numArgsProcessed == 4) {
            try {
                Double.parseDouble(argument);
                this.vectorAmplitude = argument;
            }
            catch (NumberFormatException e) {
                this.numArgsProcessed = 99;
            }
        } else if (this.numArgsProcessed == 5) {
            try {
                Double.parseDouble(argument);
                this.radiusBoost = argument;
            }
            catch (NumberFormatException e) {
                this.numArgsProcessed = 99;
            }
        } else if (this.numArgsProcessed == 6) {
            try {
                Double.parseDouble(argument);
                this.radiusCorrection = argument;
            }
            catch (NumberFormatException e) {
                this.numArgsProcessed = 99;
            }
        }
        ++this.numArgsProcessed;
    }

    @Override
    public boolean lastInputProcessed() {
        return this.numArgsProcessed < 8;
    }

    @Override
    public boolean gotEnoughArgs() {
        return this.numArgsProcessed <= 0;
    }

    @Override
    public int minArgCount() {
        return 2;
    }
}

