/*
 * Decompiled with CFR 0.152.
 */
package com._14ercooper.worldeditor.brush.shapes;

import com._14ercooper.worldeditor.async.AsyncManager;
import com._14ercooper.worldeditor.blockiterator.BlockIterator;
import com._14ercooper.worldeditor.brush.Brush;
import com._14ercooper.worldeditor.brush.BrushShape;
import com._14ercooper.worldeditor.main.Main;
import com._14ercooper.worldeditor.operations.Operator;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class Multi
extends BrushShape {
    String file = "";
    final List<String> args = new ArrayList<String>();
    List<BlockIterator> iters = null;
    List<Operator> ops = null;

    @Override
    public BlockIterator GetBlocks_impl(double x, double y, double z, World world, CommandSender sender) {
        Main.logError("Multibrush used in a normal brush context. This is an error.", (CommandSender)Bukkit.getConsoleSender(), null);
        return null;
    }

    @Override
    public void addNewArgument(String argument) {
        if (this.file.isEmpty()) {
            this.file = argument;
        } else {
            this.args.add(argument);
        }
    }

    @Override
    public boolean lastInputProcessed() {
        return true;
    }

    @Override
    public boolean gotEnoughArgs() {
        return this.file.isEmpty();
    }

    public List<BlockIterator> getIters(double x, double y, double z, World world, CommandSender sender) {
        this.genMultibrush(x, y, z, world, sender);
        return this.iters;
    }

    public List<Operator> getOps(double x, double y, double z) {
        return this.ops;
    }

    /*
     * WARNING - void declaration
     */
    private void genMultibrush(double x, double y, double z, World world, CommandSender sender) {
        this.iters = new ArrayList<BlockIterator>();
        this.ops = new ArrayList<Operator>();
        String filename = "plugins/14erEdit/multibrushes/" + this.file;
        if (!Files.exists(Paths.get(filename, new String[0]), new LinkOption[0])) {
            if (Files.exists(Paths.get(filename + ".mb", new String[0]), new LinkOption[0])) {
                filename = filename + ".mb";
            } else if (Files.exists(Paths.get(filename + ".txt", new String[0]), new LinkOption[0])) {
                filename = filename + ".txt";
            }
        }
        List<Object> brushesRaw = new ArrayList();
        try {
            brushesRaw = Files.readAllLines(Paths.get(filename, new String[0]));
        }
        catch (IOException e1) {
            Main.logError("Error loading multibrush file: " + filename, (CommandSender)Brush.currentPlayer, (Exception)e1);
        }
        LinkedList<void> brushes = new LinkedList<void>();
        for (String string : brushesRaw) {
            void var13_11;
            if (string.isEmpty()) continue;
            for (int i = this.args.size(); i > 0; --i) {
                String string2 = var13_11.replaceAll("\\$" + i, this.args.get(i - 1));
            }
            brushes.add(var13_11);
        }
        for (String string : brushes) {
            String[] rawData = string.split(" ");
            int brushOpOffset = 1;
            BrushShape shapeGenerator = Brush.GetBrushShape(rawData[0]);
            try {
                do {
                    if (rawData[brushOpOffset].equalsIgnoreCase("end")) {
                        brushOpOffset += 2;
                        break;
                    }
                    shapeGenerator.addNewArgument(rawData[brushOpOffset]);
                    ++brushOpOffset;
                } while (shapeGenerator.lastInputProcessed());
                --brushOpOffset;
            }
            catch (Exception e) {
                Main.logError("Could not parse brush arguments. Please check that you provided enough numerical arguments for the brush shape.", (CommandSender)Brush.currentPlayer, e);
                return;
            }
            if (shapeGenerator.gotEnoughArgs()) {
                Main.logError("Not enough inputs to the brush shape were provided. Please provide enough inputs.", (CommandSender)Brush.currentPlayer, null);
            }
            LinkedList<String> opArray = new LinkedList<String>(Arrays.asList(rawData));
            while (brushOpOffset > 0) {
                opArray.remove(0);
                --brushOpOffset;
            }
            String opStr = "";
            for (String str : opArray) {
                opStr = opStr.concat(str).concat(" ");
            }
            Operator operation = new Operator(opStr, (CommandSender)Brush.currentPlayer);
            this.iters.add(shapeGenerator.GetBlocks(x, y, z, world, sender));
            this.ops.add(operation);
        }
    }

    @Override
    public int minArgCount() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int operatorCount() {
        return 0;
    }

    @Override
    public void runBrush(List<Operator> operators, double x, double y, double z, Player currentPlayer) {
        Main.logDebug("Multibrush file: " + this.file);
        Main.logDebug("Number of arguments to multibrush: " + this.args.size());
        List<BlockIterator> iters = this.getIters(x, y, z, currentPlayer.getWorld(), (CommandSender)currentPlayer);
        Main.logDebug("Number of iters in multibrush: " + iters.size());
        List<Operator> ops = this.getOps(x, y, z);
        Main.logDebug("Number of ops in multibrush: " + ops.size());
        AsyncManager.scheduleEdit(iters, ops, (CommandSender)currentPlayer);
    }
}

