/*
 * Decompiled with CFR 0.152.
 */
package com._14ercooper.worldeditor.brush.shapes;

import com._14ercooper.worldeditor.blockiterator.BlockIterator;
import com._14ercooper.worldeditor.blockiterator.IteratorManager;
import com._14ercooper.worldeditor.brush.BrushShape;
import java.util.ArrayList;
import org.bukkit.World;
import org.bukkit.command.CommandSender;

public class HollowSphere
extends BrushShape {
    String radius;
    String innerRadius;
    String correction = "0.5";
    int argsSeen = 0;

    @Override
    public BlockIterator GetBlocks_impl(double x, double y, double z, World world, CommandSender sender) {
        ArrayList<String> argList = new ArrayList<String>();
        argList.add(Integer.toString((int)x));
        argList.add(Integer.toString((int)y));
        argList.add(Integer.toString((int)z));
        argList.add(this.radius);
        argList.add(this.innerRadius);
        argList.add(this.correction);
        return IteratorManager.INSTANCE.getIterator("sphere").newIterator(argList, world, sender);
    }

    @Override
    public void addNewArgument(String argument) {
        if (this.argsSeen == 0) {
            Integer.parseInt(argument);
            this.radius = argument;
        }
        if (this.argsSeen == 1) {
            Integer.parseInt(argument);
            this.innerRadius = argument;
        }
        if (this.argsSeen == 2) {
            try {
                Double.parseDouble(argument);
                this.correction = argument;
            }
            catch (NumberFormatException e) {
                ++this.argsSeen;
            }
        }
        ++this.argsSeen;
    }

    @Override
    public boolean lastInputProcessed() {
        return this.argsSeen < 4;
    }

    @Override
    public boolean gotEnoughArgs() {
        return this.argsSeen <= 1;
    }

    @Override
    public int minArgCount() {
        return 2;
    }
}

