/*
 * Decompiled with CFR 0.152.
 */
package com._14ercooper.worldeditor.brush.shapes;

import com._14ercooper.worldeditor.blockiterator.BlockIterator;
import com._14ercooper.worldeditor.blockiterator.IteratorManager;
import com._14ercooper.worldeditor.brush.BrushShape;
import java.util.ArrayList;
import org.bukkit.World;
import org.bukkit.command.CommandSender;

public class Cylinder
extends BrushShape {
    String radius;
    String correction;
    String dimension;
    int gotArgs = 0;

    @Override
    public BlockIterator GetBlocks_impl(double x, double y, double z, World world, CommandSender sender) {
        ArrayList<String> argList = new ArrayList<String>();
        argList.add(Integer.toString((int)x));
        argList.add(Integer.toString((int)y));
        argList.add(Integer.toString((int)z));
        argList.add(this.radius);
        argList.add(this.correction);
        if (this.dimension.equalsIgnoreCase("x")) {
            argList.add("0");
            argList.add("1");
            argList.add("1");
        }
        if (this.dimension.equalsIgnoreCase("y")) {
            argList.add("1");
            argList.add("0");
            argList.add("1");
        }
        if (this.dimension.equalsIgnoreCase("z")) {
            argList.add("1");
            argList.add("1");
            argList.add("0");
        }
        return IteratorManager.INSTANCE.getIterator("cylinder").newIterator(argList, world, sender);
    }

    @Override
    public void addNewArgument(String argument) {
        if (this.gotArgs == 0) {
            this.radius = argument;
        } else if (this.gotArgs == 1) {
            this.dimension = argument;
        } else if (this.gotArgs == 2) {
            try {
                Double.parseDouble(argument);
                this.correction = argument;
            }
            catch (NumberFormatException e) {
                ++this.gotArgs;
            }
        }
        ++this.gotArgs;
    }

    @Override
    public boolean lastInputProcessed() {
        return this.gotArgs < 4;
    }

    @Override
    public boolean gotEnoughArgs() {
        return this.gotArgs <= 1;
    }

    @Override
    public int minArgCount() {
        return 2;
    }
}

