/*
 * Decompiled with CFR 0.152.
 */
package com._14ercooper.worldeditor.brush;

import com._14ercooper.worldeditor.brush.Brush;
import com._14ercooper.worldeditor.main.Main;
import com._14ercooper.worldeditor.player.PlayerManager;
import com._14ercooper.worldeditor.player.PlayerWrapper;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.BlockIterator;

public class BrushListener
implements Listener {
    boolean dedupe = false;

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        try {
            Block block;
            if (event.getAction().equals((Object)Action.PHYSICAL)) {
                return;
            }
            Player player = event.getPlayer();
            ItemStack item = player.getInventory().getItemInMainHand();
            Brush brush = null;
            PlayerWrapper playerWrapper = PlayerManager.getPlayerWrapper((CommandSender)player);
            for (Brush b : playerWrapper.getBrushes()) {
                if (!b.item.equals((Object)item)) continue;
                brush = b;
            }
            if (brush == null) {
                return;
            }
            event.setCancelled(true);
            if (event.getAction() == Action.LEFT_CLICK_AIR) {
                return;
            }
            if (event.getAction() == Action.RIGHT_CLICK_BLOCK && event.getClickedBlock() != null) {
                if (!this.dedupe) {
                    this.dedupe = true;
                    return;
                }
                this.dedupe = false;
            }
            if ((block = BrushListener.getTargetBlock(player)).getType().equals((Object)Material.AIR)) {
                return;
            }
            brush.operate(block.getX(), block.getY(), block.getZ());
        }
        catch (Exception e) {
            Main.logError("Could not process brush click.", (CommandSender)event.getPlayer(), e);
        }
    }

    public static Block getTargetBlock(Player player) {
        BlockIterator iter = new BlockIterator((LivingEntity)player, 256);
        Block lastBlock = iter.next();
        while (iter.hasNext()) {
            lastBlock = iter.next();
            PlayerWrapper playerWrapper = PlayerManager.getPlayerWrapper((CommandSender)player);
            if (playerWrapper.getBrushMask().contains(lastBlock.getType())) continue;
        }
        return lastBlock;
    }
}

