/*
 * Decompiled with CFR 0.152.
 */
package com._14ercooper.worldeditor.brush;

import com._14ercooper.worldeditor.brush.BrushShape;
import com._14ercooper.worldeditor.main.Main;
import com._14ercooper.worldeditor.operations.Operator;
import com._14ercooper.worldeditor.player.PlayerManager;
import com._14ercooper.worldeditor.player.PlayerWrapper;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class Brush {
    public UUID owner;
    public ItemStack item;
    BrushShape shapeGenerator;
    List<Operator> operations;
    public static Player currentPlayer = null;
    public static final Map<String, BrushShape> brushShapes = new HashMap<String, BrushShape>();

    public static boolean removeBrush(Player player) {
        ItemStack item = player.getInventory().getItemInMainHand();
        Brush br = null;
        PlayerWrapper playerWrapper = PlayerManager.getPlayerWrapper((CommandSender)player);
        for (Brush b : playerWrapper.getBrushes()) {
            if (!b.item.equals((Object)item)) continue;
            br = b;
        }
        if (br != null) {
            playerWrapper.getBrushes().remove(br);
        }
        return true;
    }

    public Brush(String[] brushOperation, int brushOpOffset, Player player) {
        try {
            currentPlayer = player;
            ItemStack brushItem = player.getInventory().getItemInMainHand();
            Brush.removeBrush(player);
            this.owner = player.getUniqueId();
            this.item = brushItem;
            brushOpOffset += 2;
            this.shapeGenerator = (BrushShape)brushShapes.get(brushOperation[1]).getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            Main.logDebug("Brush type: " + this.shapeGenerator.getClass().getSimpleName());
            try {
                do {
                    if (brushOpOffset >= brushOperation.length || brushOperation[brushOpOffset].equalsIgnoreCase("end")) {
                        brushOpOffset += 2;
                        break;
                    }
                    this.shapeGenerator.addNewArgument(brushOperation[brushOpOffset]);
                    Main.logDebug("Passed arg \"" + brushOperation[brushOpOffset] + "\", processed=" + this.shapeGenerator.lastInputProcessed());
                    ++brushOpOffset;
                } while (this.shapeGenerator.lastInputProcessed());
                --brushOpOffset;
            }
            catch (Exception e) {
                Main.logError("Could not parse brush arguments. Please check that you provided enough numerical arguments for the brush shape.", (CommandSender)player, e);
                return;
            }
            if (this.shapeGenerator.gotEnoughArgs()) {
                Main.logError("Not enough inputs to the brush shape were provided. Please provide enough inputs.", (CommandSender)player, null);
            }
            LinkedList<String> opArray = new LinkedList<String>(Arrays.asList(brushOperation));
            this.operations = new ArrayList<Operator>();
            for (int i = 0; i < this.shapeGenerator.operatorCount(); ++i) {
                while (brushOpOffset > 0) {
                    opArray.remove(0);
                    --brushOpOffset;
                }
                String opStr = "";
                for (String s : opArray) {
                    opStr = opStr.concat(s).concat(" ");
                }
                Operator newOperator = new Operator(opStr, (CommandSender)player);
                this.operations.add(newOperator);
                brushOpOffset = newOperator.getEntryNode().consumedArgs;
            }
            PlayerWrapper playerWrapper = PlayerManager.getPlayerWrapper((CommandSender)player);
            playerWrapper.getBrushes().add(this);
            player.sendMessage("\u00a7dBrush created and bound to item in hand.");
        }
        catch (Exception e) {
            Main.logError("Error creating brush. Please check your syntax.", (CommandSender)player, e);
        }
    }

    public static BrushShape GetBrushShape(String name) {
        if (brushShapes.containsKey(name)) {
            try {
                return (BrushShape)brushShapes.get(name).getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                Main.logDebug("Error instantiating brush.");
                return null;
            }
        }
        return null;
    }

    public static void AddBrushShape(String name, BrushShape shape) {
        if (brushShapes.containsKey(name)) {
            return;
        }
        brushShapes.put(name, shape);
    }

    public void operate(double x, double y, double z) {
        try {
            currentPlayer = this.getOwner();
            this.shapeGenerator.runBrush(this.operations, x, y, z, currentPlayer);
        }
        catch (Exception e) {
            e.printStackTrace();
            Main.logError("Error operating with brush. Please check your syntax.", (CommandSender)this.getOwner(), e);
        }
    }

    public Player getOwner() {
        return Bukkit.getServer().getPlayer(this.owner);
    }
}

