/*
 * Decompiled with CFR 0.152.
 */
package com._14ercooper.worldeditor.blockiterator.iterators;

import com._14ercooper.math.Point3;
import com._14ercooper.worldeditor.blockiterator.BlockIterator;
import com._14ercooper.worldeditor.blockiterator.BlockWrapper;
import com._14ercooper.worldeditor.main.Main;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.World;
import org.bukkit.command.CommandSender;

public class SplineIterator
extends BlockIterator {
    double alpha;
    List<Point3> points;
    Point3 prePoint;
    Point3 postPoint;
    int segments;
    int currentSegment;
    int currentBlock;
    boolean hasSetSegmentTValues = false;
    double t0 = 0.0;
    double t1 = 0.0;
    double t2 = 0.0;
    double t3 = 0.0;
    double diff32 = 0.0;
    double diff21 = 0.0;
    double diff10 = 0.0;
    double diff31 = 0.0;
    double diff20 = 0.0;
    private static final long NUM_PER_SEGMENT = 10000L;

    @Override
    public SplineIterator newIterator(List<String> args2, World world, CommandSender player) {
        try {
            SplineIterator iterator2 = new SplineIterator();
            iterator2.iterWorld = world;
            if (args2.size() < 3) {
                throw new Exception("Not enough iterator arguments");
            }
            iterator2.alpha = Double.parseDouble(args2.get(0));
            iterator2.points = new ArrayList<Point3>();
            Point3 gridAlign = new Point3(0.25, 0.25, 0.25);
            for (int i = 1; i < args2.size(); ++i) {
                iterator2.points.add(Point3.fromString(args2.get(i)).add(gridAlign));
            }
            Point3 ba = iterator2.points.get(1).sub(iterator2.points.get(0));
            Point3 multNeg = ba.mult(-1.0);
            iterator2.prePoint = multNeg.add(iterator2.points.get(0));
            ba = iterator2.points.get(iterator2.points.size() - 2).sub(iterator2.points.get(iterator2.points.size() - 1));
            multNeg = ba.mult(-1.0);
            iterator2.postPoint = multNeg.add(iterator2.points.get(iterator2.points.size() - 1));
            iterator2.segments = iterator2.points.size() - 1;
            iterator2.currentSegment = 0;
            iterator2.currentBlock = 0;
            return iterator2;
        }
        catch (Exception e) {
            Main.logError("Error creating spline iterator. Please check that you provided enough selection points", player, e);
            return null;
        }
    }

    @Override
    public BlockWrapper getNextBlock(CommandSender player, boolean getBlock) {
        ++this.currentBlock;
        if ((long)this.currentBlock >= 10000L) {
            this.currentBlock = 0;
            ++this.currentSegment;
            this.hasSetSegmentTValues = false;
        }
        if (this.currentSegment >= this.segments) {
            return null;
        }
        if (!this.hasSetSegmentTValues) {
            this.hasSetSegmentTValues = true;
            this.t1 = Math.pow(Math.sqrt(Math.pow(this.diffX(this.currentSegment, 1), 2.0) + Math.pow(this.diffY(this.currentSegment, 1), 2.0) + Math.pow(this.diffZ(this.currentSegment, 1), 2.0)), this.alpha) + this.t0;
            this.t2 = Math.pow(Math.sqrt(Math.pow(this.diffX(this.currentSegment, 2), 2.0) + Math.pow(this.diffY(this.currentSegment, 2), 2.0) + Math.pow(this.diffZ(this.currentSegment, 2), 2.0)), this.alpha) + this.t1;
            this.t3 = Math.pow(Math.sqrt(Math.pow(this.diffX(this.currentSegment, 3), 2.0) + Math.pow(this.diffY(this.currentSegment, 3), 2.0) + Math.pow(this.diffZ(this.currentSegment, 3), 2.0)), this.alpha) + this.t2;
            this.diff32 = 1.0 / (this.t3 - this.t2);
            this.diff21 = 1.0 / (this.t2 - this.t1);
            this.diff10 = 1.0 / (this.t1 - this.t0);
            this.diff31 = 1.0 / (this.t3 - this.t1);
            this.diff20 = 1.0 / (this.t2 - this.t0);
        }
        double tPercent = (double)this.currentBlock / 10000.0;
        double t = this.t1 + (this.t2 - this.t1) * tPercent;
        Point3 p0 = this.getSegmentPoint(this.currentSegment, 0);
        Point3 p1 = this.getSegmentPoint(this.currentSegment, 1);
        Point3 p2 = this.getSegmentPoint(this.currentSegment, 2);
        Point3 p3 = this.getSegmentPoint(this.currentSegment, 3);
        Point3 a1 = p0.mult((this.t1 - t) * this.diff10).add(p1.mult((t - this.t0) * this.diff10));
        Point3 a2 = p1.mult((this.t2 - t) * this.diff21).add(p2.mult((t - this.t1) * this.diff21));
        Point3 a3 = p2.mult((this.t3 - t) * this.diff32).add(p3.mult((t - this.t2) * this.diff32));
        Point3 b1 = a1.mult((this.t2 - t) * this.diff20).add(a2.mult((t - this.t0) * this.diff20));
        Point3 b2 = a2.mult((this.t3 - t) * this.diff31).add(a3.mult((t - this.t1) * this.diff31));
        Point3 c = b1.mult((this.t2 - t) * this.diff21).add(b2.mult((t - this.t1) * this.diff21));
        long splineX = Math.round(c.getX());
        long splineY = Math.round(c.getY());
        long splineZ = Math.round(c.getZ());
        if (getBlock) {
            return new BlockWrapper(this.iterWorld.getBlockAt((int)splineX, (int)splineY, (int)splineZ), (int)splineX, (int)splineY, (int)splineZ);
        }
        return new BlockWrapper(null, (int)splineX, (int)splineY, (int)splineZ);
    }

    @Override
    public long getTotalBlocks() {
        return (long)this.segments * 10000L;
    }

    @Override
    public long getRemainingBlocks() {
        return this.getTotalBlocks() - this.doneBlocks;
    }

    private double diffX(int segment, int tIndex) {
        Point3 thisPoint = this.getSegmentPoint(segment, tIndex);
        Point3 lastPoint = this.getSegmentPoint(segment, tIndex - 1);
        return thisPoint.getX() - lastPoint.getX();
    }

    private double diffY(int segment, int tIndex) {
        Point3 thisPoint = this.getSegmentPoint(segment, tIndex);
        Point3 lastPoint = this.getSegmentPoint(segment, tIndex - 1);
        return thisPoint.getY() - lastPoint.getY();
    }

    private double diffZ(int segment, int tIndex) {
        Point3 thisPoint = this.getSegmentPoint(segment, tIndex);
        Point3 lastPoint = this.getSegmentPoint(segment, tIndex - 1);
        return thisPoint.getZ() - lastPoint.getZ();
    }

    private Point3 getSegmentPoint(int segment, int index) {
        return this.getPointIndex(segment + index - 1);
    }

    private Point3 getPointIndex(int index) {
        if (index < 0) {
            return this.prePoint;
        }
        if (index >= this.points.size()) {
            return this.postPoint;
        }
        return this.points.get(index);
    }
}

