/*
 * Decompiled with CFR 0.152.
 */
package com._14ercooper.worldeditor.blockiterator.iterators;

import com._14ercooper.math.Line;
import com._14ercooper.math.Point3;
import com._14ercooper.worldeditor.blockiterator.BlockIterator;
import com._14ercooper.worldeditor.blockiterator.BlockWrapper;
import com._14ercooper.worldeditor.main.Main;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.World;
import org.bukkit.command.CommandSender;

public class SpikeIterator
extends BlockIterator {
    long totalBlocks;
    int xC;
    int yC;
    int zC;
    double bSize;
    double h;
    double dX;
    double dY;
    double dZ;
    double rMin;
    int radMax;
    Point3 basePos;
    Line spikeLine;

    @Override
    public SpikeIterator newIterator(List<String> arg, World world, CommandSender player) {
        try {
            ArrayList<String> args2 = new ArrayList<String>();
            for (String s : arg) {
                args2.add(s);
            }
            SpikeIterator iterator2 = new SpikeIterator();
            iterator2.iterWorld = world;
            iterator2.xC = Integer.parseInt((String)args2.get(0));
            iterator2.yC = Integer.parseInt((String)args2.get(1));
            iterator2.zC = Integer.parseInt((String)args2.get(2));
            iterator2.bSize = Double.parseDouble((String)args2.get(3));
            iterator2.rMin = Double.parseDouble((String)args2.get(4));
            iterator2.h = Double.parseDouble((String)args2.get(5));
            iterator2.dX = Double.parseDouble((String)args2.get(6));
            iterator2.dY = Double.parseDouble((String)args2.get(7));
            iterator2.dZ = Double.parseDouble((String)args2.get(8));
            iterator2.radMax = (int)Math.max(iterator2.h, iterator2.bSize) + 1;
            iterator2.totalBlocks = (2L * (long)iterator2.radMax + 1L) * (2L * (long)iterator2.radMax + 1L) * (2L * (long)iterator2.radMax + 1L);
            iterator2.x = -iterator2.radMax - 1;
            iterator2.y = -iterator2.radMax;
            iterator2.z = -iterator2.radMax;
            while (this.y + this.yC < 0) {
                ++this.y;
            }
            iterator2.setup();
            return iterator2;
        }
        catch (Exception e) {
            Main.logError("Error creating spike iterator. Please check your brush parameters.", player, e);
            return null;
        }
    }

    private void setup() {
        this.basePos = new Point3(this.xC, this.yC, this.zC);
        Point3 secondPoint = new Point3(this.dX, this.dY, this.dZ);
        this.spikeLine = new Line(this.basePos, secondPoint);
    }

    @Override
    public BlockWrapper getNextBlock(CommandSender player, boolean getBlock) {
        double radMi;
        double h0;
        double radMa;
        double distToLine;
        do {
            if (this.incrXYZ(this.radMax, this.radMax, this.radMax, this.xC, this.yC, this.zC, player)) {
                return null;
            }
            Point3 blockPos = new Point3(this.x, this.y, this.z);
            blockPos = blockPos.add(this.basePos);
            distToLine = this.spikeLine.distanceTo(blockPos);
            h0 = this.spikeLine.distanceFromFirst(this.spikeLine.closestPoint(blockPos));
            radMi = this.rMin - this.rMin * h0 / (this.h + 1.0E-4);
        } while (distToLine > (radMa = this.bSize - this.bSize * h0 / (this.h + 1.0E-4)) || distToLine < radMi && radMi > 0.05);
        if (getBlock) {
            return new BlockWrapper(this.iterWorld.getBlockAt(this.x + this.xC, this.y + this.yC, this.z + this.zC), this.x + this.xC, this.y + this.yC, this.z + this.zC);
        }
        return new BlockWrapper(null, this.x + this.xC, this.y + this.yC, this.z + this.zC);
    }

    @Override
    public long getTotalBlocks() {
        return this.totalBlocks;
    }

    @Override
    public long getRemainingBlocks() {
        return this.totalBlocks - this.doneBlocks;
    }
}

