/*
 * Decompiled with CFR 0.152.
 */
package com._14ercooper.worldeditor.blockiterator.iterators;

import com._14ercooper.worldeditor.blockiterator.BlockIterator;
import com._14ercooper.worldeditor.blockiterator.BlockWrapper;
import com._14ercooper.worldeditor.main.Main;
import java.util.List;
import org.bukkit.World;
import org.bukkit.command.CommandSender;

public class SphereIterator
extends BlockIterator {
    long totalBlocks;
    int xC;
    int yC;
    int zC;
    int radMin;
    int radMax;
    double radCorr;

    @Override
    public SphereIterator newIterator(List<String> args2, World world, CommandSender player) {
        try {
            SphereIterator iterator2 = new SphereIterator();
            iterator2.iterWorld = world;
            iterator2.xC = Integer.parseInt(args2.get(0));
            iterator2.yC = Integer.parseInt(args2.get(1));
            iterator2.zC = Integer.parseInt(args2.get(2));
            iterator2.radMax = Integer.parseInt(args2.get(3));
            iterator2.radMin = Integer.parseInt(args2.get(4));
            iterator2.radCorr = Double.parseDouble(args2.get(5));
            iterator2.totalBlocks = (2L * (long)iterator2.radMax + 1L) * (2L * (long)iterator2.radMax + 1L) * (2L * (long)iterator2.radMax + 1L);
            iterator2.x = -iterator2.radMax - 1;
            iterator2.y = -iterator2.radMax;
            iterator2.z = -iterator2.radMax;
            return iterator2;
        }
        catch (Exception e) {
            Main.logError("Error creating sphere iterator. Please check your brush parameters.", player, e);
            return null;
        }
    }

    @Override
    public BlockWrapper getNextBlock(CommandSender player, boolean getBlock) {
        do {
            if (!this.incrXYZ(this.radMax, this.radMax, this.radMax, this.xC, this.yC, this.zC, player)) continue;
            return null;
        } while ((double)(this.x * this.x + this.y * this.y + this.z * this.z) >= ((double)this.radMax + this.radCorr) * ((double)this.radMax + this.radCorr) || this.radMin > 1 && (double)(this.x * this.x + this.y * this.y + this.z * this.z) <= ((double)this.radMin - this.radCorr) * ((double)this.radMin - this.radCorr));
        if (getBlock) {
            return new BlockWrapper(this.iterWorld.getBlockAt(this.x + this.xC, this.y + this.yC, this.z + this.zC), this.x + this.xC, this.y + this.yC, this.z + this.zC);
        }
        return new BlockWrapper(null, this.x + this.xC, this.y + this.yC, this.z + this.zC);
    }

    @Override
    public long getTotalBlocks() {
        return this.totalBlocks;
    }

    @Override
    public long getRemainingBlocks() {
        return this.totalBlocks - this.doneBlocks;
    }
}

