/*
 * Decompiled with CFR 0.152.
 */
package com._14ercooper.worldeditor.blockiterator.iterators;

import com._14ercooper.schematics.SchemLite;
import com._14ercooper.worldeditor.blockiterator.BlockIterator;
import com._14ercooper.worldeditor.blockiterator.BlockWrapper;
import com._14ercooper.worldeditor.main.Main;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.CommandSender;

public class SchemBrushIterator
extends BlockIterator {
    SchemLite schem;
    BlockIterator schemIter;

    @Override
    public BlockIterator newIterator(List<String> arg, World world, CommandSender player) {
        try {
            ArrayList<String> args2 = new ArrayList<String>();
            for (String s : arg) {
                args2.add(s);
            }
            SchemBrushIterator iter = new SchemBrushIterator();
            iter.iterWorld = world;
            int x = Integer.parseInt((String)args2.get(0));
            int y = Integer.parseInt((String)args2.get(1));
            int z = Integer.parseInt((String)args2.get(2));
            iter.schem = new SchemLite((String)args2.get(3), true, 0);
            iter.schem.openRead();
            iter.schemIter = iter.schem.getIterator(x - iter.schem.getXSize() / 2, y - iter.schem.getYSize() / 2, z - iter.schem.getZSize() / 2, world);
            return iter;
        }
        catch (Exception e) {
            Main.logError("Could not create schem brush iterator", player, e);
            return null;
        }
    }

    public void cleanup() {
        try {
            this.schem.closeRead();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public BlockWrapper getNextBlock(CommandSender player, boolean getBlock) {
        String nbt;
        String blockData;
        String blockType;
        try {
            String[] data = this.schem.readNext();
            blockType = data[0];
            blockData = data[1];
            nbt = data[2];
        }
        catch (IOException e) {
            Main.logError("Could not read next block from schematic.", (CommandSender)Bukkit.getConsoleSender(), (Exception)e);
            nbt = "";
            blockData = "";
            blockType = "";
        }
        BlockWrapper wrapper = this.schemIter.getNextBlock(player, getBlock);
        if (wrapper != null) {
            wrapper.otherArgs.add(blockType);
            wrapper.otherArgs.add(blockData);
            wrapper.otherArgs.add(nbt);
        }
        return wrapper;
    }

    @Override
    public long getTotalBlocks() {
        return this.schemIter.getTotalBlocks();
    }

    @Override
    public long getRemainingBlocks() {
        return this.schemIter.getRemainingBlocks();
    }
}

