/*
 * Decompiled with CFR 0.152.
 */
package com._14ercooper.worldeditor.blockiterator.iterators;

import com._14ercooper.math.Point3;
import com._14ercooper.worldeditor.blockiterator.BlockIterator;
import com._14ercooper.worldeditor.blockiterator.BlockWrapper;
import com._14ercooper.worldeditor.main.Main;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.World;
import org.bukkit.command.CommandSender;

public class RotatedEllipseIterator
extends BlockIterator {
    long totalBlocks;
    int xC;
    int yC;
    int zC;
    double hFD;
    double strL;
    double dX;
    double dY;
    double dZ;
    int radMax;
    int maxDist;
    Point3 focus1;
    Point3 focus2;
    Point3 negCenter;

    @Override
    public RotatedEllipseIterator newIterator(List<String> arg, World world, CommandSender player) {
        try {
            ArrayList<String> args2 = new ArrayList<String>();
            for (String s : arg) {
                args2.add(s);
            }
            RotatedEllipseIterator iterator2 = new RotatedEllipseIterator();
            iterator2.iterWorld = world;
            iterator2.xC = Integer.parseInt((String)args2.get(0));
            iterator2.yC = Integer.parseInt((String)args2.get(1));
            iterator2.zC = Integer.parseInt((String)args2.get(2));
            iterator2.hFD = Double.parseDouble((String)args2.get(3));
            iterator2.strL = Double.parseDouble((String)args2.get(4));
            iterator2.dX = Double.parseDouble((String)args2.get(5));
            iterator2.dY = Double.parseDouble((String)args2.get(6));
            iterator2.dZ = Double.parseDouble((String)args2.get(7));
            iterator2.maxDist = (int)iterator2.strL + 1;
            iterator2.totalBlocks = (2L * (long)iterator2.maxDist + 1L) * (2L * (long)iterator2.maxDist + 1L) * (2L * (long)iterator2.maxDist + 1L);
            iterator2.x = -iterator2.maxDist - 1;
            iterator2.y = -iterator2.maxDist;
            iterator2.z = -iterator2.maxDist;
            iterator2.radMax = iterator2.maxDist;
            while (this.y + this.yC < 0) {
                ++this.y;
            }
            iterator2.setup();
            return iterator2;
        }
        catch (Exception e) {
            Main.logError("Error creating rotated ellipse iterator. Please check your brush parameters.", player, e);
            return null;
        }
    }

    private void setup() {
        Point3 dir = new Point3(this.dX, this.dY, this.dZ);
        Point3 center = new Point3(this.xC, this.yC, this.zC);
        dir.normalize();
        dir = dir.mult(this.hFD);
        this.focus1 = center.add(dir);
        this.focus2 = center.add(dir.mult(-1.0));
        this.negCenter = center;
    }

    @Override
    public BlockWrapper getNextBlock(CommandSender player, boolean getBlock) {
        Point3 blockPoint;
        double dist;
        do {
            if (this.incrXYZ(this.radMax, this.radMax, this.radMax, this.xC, this.yC, this.zC, player)) {
                return null;
            }
            blockPoint = new Point3(this.x, this.y, this.z);
        } while ((dist = (blockPoint = blockPoint.add(this.negCenter)).distance(this.focus1) + blockPoint.distance(this.focus2)) > this.strL);
        if (getBlock) {
            return new BlockWrapper(this.iterWorld.getBlockAt(this.x + this.xC, this.y + this.yC, this.z + this.zC), this.x + this.xC, this.y + this.yC, this.z + this.zC);
        }
        return new BlockWrapper(null, this.x + this.xC, this.y + this.yC, this.z + this.zC);
    }

    @Override
    public long getTotalBlocks() {
        return this.totalBlocks;
    }

    @Override
    public long getRemainingBlocks() {
        return this.totalBlocks - this.doneBlocks;
    }
}

