/*
 * Decompiled with CFR 0.152.
 */
package com._14ercooper.worldeditor.blockiterator.iterators;

import com._14ercooper.worldeditor.blockiterator.BlockIterator;
import com._14ercooper.worldeditor.blockiterator.BlockWrapper;
import com._14ercooper.worldeditor.operations.Operator;
import com._14ercooper.worldeditor.operations.OperatorState;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;

public class FloodfillIterator
extends BlockIterator {
    Deque<BlockObject> blockObjects = new ArrayDeque<BlockObject>();
    Map<BlockObject, BlockObject> seenBlocks = new HashMap<BlockObject, BlockObject>();
    Set<BlockObject> doneBlockSet = new HashSet<BlockObject>();
    int maxDepth;
    long totalBlocks;
    long doneBlocks = 0L;
    boolean firstBlock = true;

    @Override
    public BlockIterator newIterator(List<String> args2, World world, CommandSender player) {
        FloodfillIterator iter = new FloodfillIterator();
        int x_ = Integer.parseInt(args2.get(0));
        int y_ = Integer.parseInt(args2.get(1));
        int z_ = Integer.parseInt(args2.get(2));
        BlockObject blkObj = new BlockObject(x_, y_, z_, null);
        iter.blockObjects.add(blkObj);
        iter.seenBlocks.put(blkObj, blkObj);
        iter.maxDepth = Integer.parseInt(args2.get(3));
        iter.totalBlocks = (long)(4.18856195 * (double)(2L * (long)iter.maxDepth + 2L));
        return iter;
    }

    @Override
    public BlockWrapper getNextBlock(CommandSender player, boolean getBlock) {
        if (this.blockObjects.size() == 0) {
            return null;
        }
        BlockObject blkObject = this.blockObjects.removeFirst();
        Operator conditionOperator = (Operator)this.objectArgs.get("FloodfillCondition");
        OperatorState operatorTempState = (OperatorState)this.objectArgs.get("OperatorState");
        if (this.firstBlock) {
            operatorTempState.setCurrentBlock(blkObject.getBlock(operatorTempState.getCurrentWorld()));
            boolean result2 = conditionOperator.operateOnBlock(operatorTempState);
            if (!result2) {
                return null;
            }
            ++this.doneBlocks;
            this.firstBlock = false;
        }
        ArrayList<BlockObject> adjacents = new ArrayList<BlockObject>();
        adjacents.add(new BlockObject(blkObject.x + 1, blkObject.y, blkObject.z, blkObject));
        adjacents.add(new BlockObject(blkObject.x, blkObject.y + 1, blkObject.z, blkObject));
        adjacents.add(new BlockObject(blkObject.x, blkObject.y, blkObject.z + 1, blkObject));
        adjacents.add(new BlockObject(blkObject.x - 1, blkObject.y, blkObject.z, blkObject));
        adjacents.add(new BlockObject(blkObject.x, blkObject.y - 1, blkObject.z, blkObject));
        adjacents.add(new BlockObject(blkObject.x, blkObject.y, blkObject.z - 1, blkObject));
        for (BlockObject b : adjacents) {
            boolean result3;
            if (b.getDepth() > this.maxDepth) continue;
            if (!this.seenBlocks.containsKey(b)) {
                this.seenBlocks.put(b, b);
                operatorTempState.setCurrentBlock(b.getBlock(operatorTempState.getCurrentWorld()));
                result3 = conditionOperator.operateOnBlock(operatorTempState);
                if (!result3) continue;
                this.doneBlockSet.add(b);
                this.blockObjects.add(b);
                continue;
            }
            if (this.seenBlocks.get(b).getDepth() <= b.getDepth()) continue;
            this.seenBlocks.remove(this.seenBlocks.get(b));
            this.seenBlocks.put(b, b);
            operatorTempState.setCurrentBlock(b.getBlock(operatorTempState.getCurrentWorld()));
            result3 = conditionOperator.operateOnBlock(operatorTempState);
            if (!result3) continue;
            this.doneBlockSet.add(b);
            this.blockObjects.add(b);
        }
        if (getBlock) {
            return new BlockWrapper(blkObject.getBlock(operatorTempState.getCurrentWorld()), blkObject.x, blkObject.y, blkObject.z);
        }
        return new BlockWrapper(null, blkObject.x, blkObject.y, blkObject.z);
    }

    @Override
    public long getTotalBlocks() {
        return this.totalBlocks;
    }

    @Override
    public long getRemainingBlocks() {
        return this.totalBlocks - this.doneBlocks;
    }

    private static class BlockObject {
        public final int x;
        public final int y;
        public final int z;
        public BlockObject parent;

        public int getDepth() {
            if (this.parent == null) {
                return 0;
            }
            return this.parent.getDepth() + 1;
        }

        private BlockObject(int x, int y, int z, BlockObject parent) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.parent = parent;
        }

        public boolean equals(Object b) {
            if (!(b instanceof BlockObject)) {
                return false;
            }
            return this.x == ((BlockObject)b).x && this.y == ((BlockObject)b).y && this.z == ((BlockObject)b).z;
        }

        public int hashCode() {
            return Objects.hash(this.x, this.y, this.z);
        }

        public Block getBlock(World world) {
            return world.getBlockAt(this.x, this.y, this.z);
        }
    }
}

