/*
 * Decompiled with CFR 0.152.
 */
package com._14ercooper.worldeditor.blockiterator.iterators;

import com._14ercooper.worldeditor.blockiterator.BlockIterator;
import com._14ercooper.worldeditor.blockiterator.BlockWrapper;
import com._14ercooper.worldeditor.main.Main;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.World;
import org.bukkit.command.CommandSender;

public class EllipseIterator
extends BlockIterator {
    long totalBlocks;
    int xC;
    int yC;
    int zC;
    double rx;
    double ry;
    double rz;
    double radCorr;

    @Override
    public EllipseIterator newIterator(List<String> arg, World world, CommandSender player) {
        try {
            ArrayList<String> args2 = new ArrayList<String>();
            for (String s : arg) {
                args2.add(s);
            }
            EllipseIterator iterator2 = new EllipseIterator();
            iterator2.iterWorld = world;
            iterator2.xC = Integer.parseInt((String)args2.get(0));
            iterator2.yC = Integer.parseInt((String)args2.get(1));
            iterator2.zC = Integer.parseInt((String)args2.get(2));
            iterator2.rx = Integer.parseInt((String)args2.get(3));
            iterator2.ry = Integer.parseInt((String)args2.get(4));
            iterator2.rz = Integer.parseInt((String)args2.get(5));
            iterator2.radCorr = Double.parseDouble((String)args2.get(6));
            iterator2.totalBlocks = (2L * (long)((int)iterator2.rx) + 1L) * (2L * (long)((int)iterator2.ry) + 1L) * (2L * (long)((int)iterator2.rz) + 1L);
            iterator2.x = (int)(-iterator2.rx - 1.0);
            iterator2.y = (int)(-iterator2.ry);
            iterator2.z = (int)(-iterator2.rz);
            return iterator2;
        }
        catch (Exception e) {
            Main.logError("Error creating ellipse iterator. Please check your brush parameters.", player, e);
            return null;
        }
    }

    @Override
    public BlockWrapper getNextBlock(CommandSender player, boolean getBlock) {
        do {
            if (!this.incrXYZ((int)this.rx, (int)this.ry, (int)this.rz, this.xC, this.yC, this.zC, player)) continue;
            return null;
        } while ((double)(this.x * this.x) / (this.rx * this.rx) + (double)(this.y * this.y) / (this.ry * this.ry) + (double)(this.z * this.z) / (this.rz * this.rz) > 1.0 + this.radCorr);
        if (getBlock) {
            return new BlockWrapper(this.iterWorld.getBlockAt(this.x + this.xC, this.y + this.yC, this.z + this.zC), this.x + this.xC, this.y + this.yC, this.z + this.zC);
        }
        return new BlockWrapper(null, this.x + this.xC, this.y + this.yC, this.z + this.zC);
    }

    @Override
    public long getTotalBlocks() {
        return this.totalBlocks;
    }

    @Override
    public long getRemainingBlocks() {
        return this.totalBlocks - this.doneBlocks;
    }
}

