/*
 * Decompiled with CFR 0.152.
 */
package com._14ercooper.worldeditor.blockiterator.iterators;

import com._14ercooper.worldeditor.blockiterator.BlockIterator;
import com._14ercooper.worldeditor.blockiterator.BlockWrapper;
import com._14ercooper.worldeditor.main.Main;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.World;
import org.bukkit.command.CommandSender;

public class DiamondIterator
extends BlockIterator {
    long totalBlocks;
    int xC;
    int yC;
    int zC;
    int radius;

    @Override
    public DiamondIterator newIterator(List<String> arg, World world, CommandSender player) {
        try {
            ArrayList<String> args2 = new ArrayList<String>();
            for (String s : arg) {
                args2.add(s);
            }
            DiamondIterator iterator2 = new DiamondIterator();
            iterator2.iterWorld = world;
            iterator2.xC = Integer.parseInt((String)args2.get(0));
            iterator2.yC = Integer.parseInt((String)args2.get(1));
            iterator2.zC = Integer.parseInt((String)args2.get(2));
            iterator2.radius = Integer.parseInt((String)args2.get(3));
            iterator2.totalBlocks = (2L * (long)iterator2.radius + 1L) * (2L * (long)iterator2.radius + 1L) * (2L * (long)iterator2.radius + 1L);
            iterator2.x = -iterator2.radius - 1;
            iterator2.y = -iterator2.radius;
            iterator2.z = -iterator2.radius;
            return iterator2;
        }
        catch (Exception e) {
            Main.logError("Error creating diamond iterator. Please check your brush parameters.", player, e);
            return null;
        }
    }

    @Override
    public BlockWrapper getNextBlock(CommandSender player, boolean getBlock) {
        do {
            if (!this.incrXYZ(this.radius, this.radius, this.radius, this.xC, this.yC, this.zC, player)) continue;
            return null;
        } while (Math.abs(this.x) + Math.abs(this.y) + Math.abs(this.z) > this.radius);
        if (getBlock) {
            return new BlockWrapper(this.iterWorld.getBlockAt(this.x + this.xC, this.y + this.yC, this.z + this.zC), this.x + this.xC, this.y + this.yC, this.z + this.zC);
        }
        return new BlockWrapper(null, this.x + this.xC, this.y + this.yC, this.z + this.zC);
    }

    @Override
    public long getTotalBlocks() {
        return this.totalBlocks;
    }

    @Override
    public long getRemainingBlocks() {
        return this.totalBlocks - this.doneBlocks;
    }
}

