/*
 * Decompiled with CFR 0.152.
 */
package com._14ercooper.worldeditor.blockiterator.iterators;

import com._14ercooper.worldeditor.blockiterator.BlockIterator;
import com._14ercooper.worldeditor.blockiterator.BlockWrapper;
import com._14ercooper.worldeditor.main.Main;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.World;
import org.bukkit.command.CommandSender;

public class CylinderIterator
extends BlockIterator {
    long totalBlocks;
    int xC;
    int yC;
    int zC;
    double xS;
    double yS;
    double zS;
    int radMax;
    double radCorr;

    @Override
    public CylinderIterator newIterator(List<String> arg, World world, CommandSender player) {
        try {
            ArrayList<String> args2 = new ArrayList<String>();
            for (String s : arg) {
                args2.add(s);
            }
            CylinderIterator iterator2 = new CylinderIterator();
            iterator2.iterWorld = world;
            iterator2.xC = Integer.parseInt((String)args2.get(0));
            iterator2.yC = Integer.parseInt((String)args2.get(1));
            iterator2.zC = Integer.parseInt((String)args2.get(2));
            iterator2.radMax = Integer.parseInt((String)args2.get(3));
            iterator2.radCorr = Double.parseDouble((String)args2.get(4));
            iterator2.xS = Double.parseDouble((String)args2.get(5));
            iterator2.yS = Double.parseDouble((String)args2.get(6));
            iterator2.zS = Double.parseDouble((String)args2.get(7));
            iterator2.totalBlocks = (2L * (long)iterator2.radMax + 1L) * (2L * (long)iterator2.radMax + 1L) * (2L * (long)iterator2.radMax + 1L);
            iterator2.x = -iterator2.radMax - 1;
            iterator2.y = -iterator2.radMax;
            iterator2.z = -iterator2.radMax;
            while (iterator2.y + iterator2.yC < 0) {
                ++iterator2.y;
            }
            return iterator2;
        }
        catch (Exception e) {
            Main.logError("Error creating cylinder iterator. Please check your brush parameters.", player, e);
            return null;
        }
    }

    @Override
    public BlockWrapper getNextBlock(CommandSender player, boolean getBlock) {
        do {
            if (!this.incrXYZ(this.radMax, this.radMax, this.radMax, this.xC, this.yC, this.zC, player)) continue;
            return null;
        } while ((double)(this.x * this.x) * this.xS + (double)(this.y * this.y) * this.yS + (double)(this.z * this.z) * this.zS >= ((double)this.radMax + this.radCorr) * ((double)this.radMax + this.radCorr));
        if (getBlock) {
            return new BlockWrapper(this.iterWorld.getBlockAt(this.x + this.xC, this.y + this.yC, this.z + this.zC), this.x + this.xC, this.y + this.yC, this.z + this.zC);
        }
        return new BlockWrapper(null, this.x + this.xC, this.y + this.yC, this.z + this.zC);
    }

    @Override
    public long getTotalBlocks() {
        return this.totalBlocks;
    }

    @Override
    public long getRemainingBlocks() {
        return this.totalBlocks - this.doneBlocks;
    }
}

