/*
 * Decompiled with CFR 0.152.
 */
package com._14ercooper.worldeditor.blockiterator.iterators;

import com._14ercooper.worldeditor.blockiterator.BlockIterator;
import com._14ercooper.worldeditor.blockiterator.BlockWrapper;
import com._14ercooper.worldeditor.main.Main;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.World;
import org.bukkit.command.CommandSender;

public class CubeIterator
extends BlockIterator {
    int x1;
    int y1;
    int z1;
    int x2;
    int y2;
    int z2;
    long totalBlocks;
    long doneBlocks = 0L;
    int x;
    int y;
    int z;
    int xStep = 1;
    int yStep = 1;
    int zStep = 1;
    int executionOrder = 0;

    @Override
    public CubeIterator newIterator(List<String> arg, World world, CommandSender player) {
        try {
            ArrayList<String> args2 = new ArrayList<String>();
            for (String s : arg) {
                args2.add(s);
            }
            CubeIterator iterator2 = new CubeIterator();
            iterator2.iterWorld = world;
            iterator2.x1 = Integer.parseInt((String)args2.get(0));
            iterator2.y1 = Integer.parseInt((String)args2.get(1));
            iterator2.z1 = Integer.parseInt((String)args2.get(2));
            iterator2.x2 = Integer.parseInt((String)args2.get(3));
            iterator2.y2 = Integer.parseInt((String)args2.get(4));
            iterator2.z2 = Integer.parseInt((String)args2.get(5));
            if (args2.size() > 6) {
                iterator2.executionOrder = Integer.parseInt((String)args2.get(6));
                if (iterator2.executionOrder < 0) {
                    iterator2.executionOrder = 0;
                }
                if (iterator2.executionOrder > 5) {
                    iterator2.executionOrder = 0;
                }
            }
            if (iterator2.x2 < iterator2.x1) {
                iterator2.xStep = -1;
            }
            if (iterator2.y2 < iterator2.y1) {
                iterator2.yStep = -1;
            }
            if (iterator2.z2 < iterator2.z1) {
                iterator2.zStep = -1;
            }
            int dx = Math.abs(iterator2.x2 - iterator2.x1) + 1;
            int dy = Math.abs(iterator2.y2 - iterator2.y1) + 1;
            int dz = Math.abs(iterator2.z2 - iterator2.z1) + 1;
            iterator2.totalBlocks = (long)dx * (long)dy * (long)dz;
            iterator2.x = iterator2.x1;
            iterator2.y = iterator2.y1;
            iterator2.z = iterator2.z1;
            if (iterator2.executionOrder == 0 || iterator2.executionOrder == 1) {
                iterator2.x -= iterator2.xStep;
            }
            if (iterator2.executionOrder == 2 || iterator2.executionOrder == 4) {
                iterator2.z -= iterator2.zStep;
            }
            if (iterator2.executionOrder == 3 || iterator2.executionOrder == 5) {
                iterator2.y -= iterator2.yStep;
            }
            Main.logDebug("From " + iterator2.x1 + "," + iterator2.y1 + "," + iterator2.z1 + " to " + iterator2.x2 + "," + iterator2.y2 + "," + iterator2.z2);
            Main.logDebug("Starting block: " + iterator2.x + "," + iterator2.y + "," + iterator2.z);
            Main.logDebug("Steps: " + iterator2.xStep + "," + iterator2.yStep + "," + iterator2.zStep);
            Main.logDebug("Cube iterator execution order: " + iterator2.executionOrder);
            return iterator2;
        }
        catch (Exception e) {
            Main.logError("Could not create cube iterator. Please check your brush parameters/if you have a selection box.", player, e);
            return null;
        }
    }

    @Override
    public BlockWrapper getNextBlock(CommandSender player, boolean getBlock) {
        if (this.executionOrder == 0) {
            this.x += this.xStep;
            ++this.doneBlocks;
            if (this.inRange(this.x, this.x1, this.x2)) {
                this.z += this.zStep;
                this.x = this.x1;
            }
            if (this.inRange(this.z, this.z1, this.z2)) {
                this.y += this.yStep;
                this.z = this.z1;
            }
            if (this.inRange(this.y, this.y1, this.y2)) {
                return null;
            }
        }
        if (this.executionOrder == 1) {
            this.x += this.xStep;
            ++this.doneBlocks;
            if (this.inRange(this.x, this.x1, this.x2)) {
                this.y += this.yStep;
                this.x = this.x1;
            }
            if (this.inRange(this.y, this.y1, this.y2)) {
                this.z += this.zStep;
                this.y = this.y1;
            }
            if (this.inRange(this.z, this.z1, this.z2)) {
                return null;
            }
        }
        if (this.executionOrder == 2) {
            this.z += this.zStep;
            ++this.doneBlocks;
            if (this.inRange(this.z, this.z1, this.z2)) {
                this.x += this.xStep;
                this.z = this.z1;
            }
            if (this.inRange(this.x, this.x1, this.x2)) {
                this.y += this.yStep;
                this.x = this.x1;
            }
            if (this.inRange(this.y, this.y1, this.y2)) {
                return null;
            }
        }
        if (this.executionOrder == 3) {
            this.y += this.yStep;
            ++this.doneBlocks;
            if (this.inRange(this.y, this.y1, this.y2)) {
                this.x += this.xStep;
                this.y = this.y1;
            }
            if (this.inRange(this.x, this.x1, this.x2)) {
                this.z += this.zStep;
                this.x = this.x1;
            }
            if (this.inRange(this.z, this.z1, this.z2)) {
                return null;
            }
        }
        if (this.executionOrder == 4) {
            this.z += this.zStep;
            ++this.doneBlocks;
            if (this.inRange(this.z, this.z1, this.z2)) {
                this.y += this.yStep;
                this.z = this.z1;
            }
            if (this.inRange(this.y, this.y1, this.y2)) {
                this.x += this.xStep;
                this.y = this.y1;
            }
            if (this.inRange(this.x, this.x1, this.x2)) {
                return null;
            }
        }
        if (this.executionOrder == 5) {
            this.y += this.yStep;
            ++this.doneBlocks;
            if (this.inRange(this.y, this.y1, this.y2)) {
                this.z += this.zStep;
                this.y = this.y1;
            }
            if (this.inRange(this.z, this.z1, this.z2)) {
                this.x += this.xStep;
                this.z = this.z1;
            }
            if (this.inRange(this.x, this.x1, this.x2)) {
                return null;
            }
        }
        if (getBlock) {
            return new BlockWrapper(this.iterWorld.getBlockAt(this.x, this.y, this.z), this.x, this.y, this.z);
        }
        return new BlockWrapper(null, this.x, this.y, this.z);
    }

    @Override
    public long getTotalBlocks() {
        return this.totalBlocks;
    }

    @Override
    public long getRemainingBlocks() {
        return this.totalBlocks - this.doneBlocks;
    }

    private boolean inRange(int val, int r1, int r2) {
        int max;
        int min;
        if (r1 <= r2) {
            min = r1;
            max = r2;
        } else {
            min = r2;
            max = r1;
        }
        return val < min || val > max;
    }
}

