/*
 * Decompiled with CFR 0.152.
 */
package com._14ercooper.worldeditor.blockiterator.iterators;

import com._14ercooper.math.Point3;
import com._14ercooper.worldeditor.blockiterator.BlockIterator;
import com._14ercooper.worldeditor.blockiterator.BlockWrapper;
import com._14ercooper.worldeditor.main.Main;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.bukkit.World;
import org.bukkit.command.CommandSender;

public class BlobIterator
extends BlockIterator {
    long totalBlocks;
    int xC;
    int yC;
    int zC;
    int radius;
    int vectorCount;
    double vectorAmplitude;
    double radiusBoost;
    double radiusCorrection;
    int boostedRadius;
    List<Point3> vectors;
    List<Double> amplitudes;

    @Override
    public BlobIterator newIterator(List<String> args2, World world, CommandSender player) {
        try {
            BlobIterator iterator2 = new BlobIterator();
            iterator2.iterWorld = world;
            iterator2.xC = Integer.parseInt(args2.get(0));
            iterator2.yC = Integer.parseInt(args2.get(1));
            iterator2.zC = Integer.parseInt(args2.get(2));
            iterator2.radius = Integer.parseInt(args2.get(3));
            iterator2.vectorCount = Integer.parseInt(args2.get(4));
            iterator2.vectorAmplitude = Double.parseDouble(args2.get(5));
            iterator2.radiusBoost = Double.parseDouble(args2.get(6));
            iterator2.radiusCorrection = Double.parseDouble(args2.get(7));
            iterator2.boostedRadius = (int)((double)iterator2.radius * (iterator2.vectorAmplitude + iterator2.radiusBoost)) + 1;
            if (iterator2.vectorCount < 1) {
                iterator2.vectorCount = 1;
            }
            Random random = new Random();
            iterator2.vectors = new ArrayList<Point3>(iterator2.vectorCount);
            iterator2.amplitudes = new ArrayList<Double>(iterator2.vectorCount);
            for (int i = 0; i < iterator2.vectorCount; ++i) {
                Point3 point = new Point3(this.randomDouble(random), this.randomDouble(random), this.randomDouble(random));
                point.normalize();
                iterator2.vectors.add(point);
                iterator2.amplitudes.add(iterator2.vectorAmplitude * (1.0 / (double)(i + 1)));
            }
            iterator2.totalBlocks = (2L * (long)iterator2.boostedRadius + 1L) * (2L * (long)iterator2.boostedRadius + 1L) * (2L * (long)iterator2.boostedRadius + 1L);
            iterator2.x = -iterator2.boostedRadius - 1;
            iterator2.y = -iterator2.boostedRadius;
            iterator2.z = -iterator2.boostedRadius;
            return iterator2;
        }
        catch (Exception e) {
            Main.logError("Error creating blob iterator. Please check your brush parameters.", player, e);
            return null;
        }
    }

    @Override
    public BlockWrapper getNextBlock(CommandSender player, boolean getBlock) {
        double modAmp;
        Point3 point;
        double radius;
        do {
            if (this.incrXYZ(this.boostedRadius, this.boostedRadius, this.boostedRadius, this.xC, this.yC, this.zC, player)) {
                return null;
            }
            point = new Point3(this.x, this.y, this.z);
            Point3 pointNorm = new Point3(this.x, this.y, this.z);
            pointNorm.normalize();
            modAmp = 0.0;
            for (int i = 0; i < this.vectorCount; ++i) {
                double dot = pointNorm.dot(this.vectors.get(i));
                if (dot < 0.0) continue;
                modAmp += dot * this.amplitudes.get(i) * (double)this.radius;
            }
        } while ((radius = point.magnitude() + modAmp) * radius >= ((double)this.radius + this.radiusCorrection) * ((double)this.radius + this.radiusCorrection));
        if (getBlock) {
            return new BlockWrapper(this.iterWorld.getBlockAt(this.x + this.xC, this.y + this.yC, this.z + this.zC), this.x + this.xC, this.y + this.yC, this.z + this.zC);
        }
        return new BlockWrapper(null, this.x + this.xC, this.y + this.yC, this.z + this.zC);
    }

    @Override
    public long getTotalBlocks() {
        return this.totalBlocks;
    }

    @Override
    public long getRemainingBlocks() {
        return this.totalBlocks - this.doneBlocks;
    }

    private double randomDouble(Random random) {
        return -1.0 + 2.0 * random.nextDouble();
    }
}

