/*
 * Decompiled with CFR 0.152.
 */
package com._14ercooper.worldeditor.blockiterator;

import com._14ercooper.worldeditor.blockiterator.BlockWrapper;
import com._14ercooper.worldeditor.player.PlayerManager;
import com._14ercooper.worldeditor.player.PlayerWrapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.World;
import org.bukkit.command.CommandSender;

public abstract class BlockIterator {
    public Map<String, Object> objectArgs = new HashMap<String, Object>();
    private int originX;
    private int originY;
    private int originZ;
    public int x;
    public int y;
    public int z;
    public long doneBlocks = 0L;
    protected World iterWorld;

    public abstract BlockIterator newIterator(List<String> var1, World var2, CommandSender var3);

    public void setOrigin(int originX, int originY, int originZ) {
        this.originX = originX;
        this.originY = originY;
        this.originZ = originZ;
    }

    public int getOriginX() {
        return this.originX;
    }

    public int getOriginY() {
        return this.originY;
    }

    public int getOriginZ() {
        return this.originZ;
    }

    public void setObjectArgs(String key, Object value) {
        this.objectArgs.put(key, value);
    }

    public abstract BlockWrapper getNextBlock(CommandSender var1, boolean var2);

    public List<BlockWrapper> getNext(int num, CommandSender player, boolean getBlock) {
        BlockWrapper next;
        ArrayList<BlockWrapper> blocks = new ArrayList<BlockWrapper>();
        for (int i = 0; i < num && (next = this.getNextBlock(player, getBlock)) != null; ++i) {
            blocks.add(next);
        }
        return blocks;
    }

    public abstract long getTotalBlocks();

    public abstract long getRemainingBlocks();

    public boolean incrXYZ(int radX, int radY, int radZ, int xOff, int yOff, int zOff, CommandSender player) {
        PlayerWrapper playerManager = PlayerManager.getPlayerWrapper(player);
        ++this.x;
        ++this.doneBlocks;
        if (this.x > radX || (long)(this.x + xOff) > playerManager.getMaxEditX()) {
            ++this.y;
            this.x = -radX;
            if ((long)(this.x + xOff) < playerManager.getMinEditX()) {
                this.x = (int)playerManager.getMinEditX() - xOff;
            }
        }
        if (this.y > radY || (long)(this.y + yOff) > playerManager.getMaxEditY()) {
            ++this.z;
            if ((long)(this.z + zOff) < playerManager.getMinEditZ()) {
                this.z = (int)playerManager.getMinEditZ() - zOff;
            }
            this.y = -radY;
            while ((long)(this.y + yOff) < playerManager.getMinEditY()) {
                ++this.y;
                ++this.doneBlocks;
            }
        }
        return this.z > radZ || (long)(this.z + zOff) > playerManager.getMaxEditZ();
    }
}

