/*
 * Decompiled with CFR 0.152.
 */
package com._14ercooper.worldeditor.async;

import com._14ercooper.schematics.SchemLite;
import com._14ercooper.worldeditor.async.AsyncOperation;
import com._14ercooper.worldeditor.blockiterator.BlockIterator;
import com._14ercooper.worldeditor.blockiterator.BlockWrapper;
import com._14ercooper.worldeditor.blockiterator.iterators.SchemBrushIterator;
import com._14ercooper.worldeditor.main.Main;
import com._14ercooper.worldeditor.main.NBTExtractor;
import com._14ercooper.worldeditor.main.SetBlock;
import com._14ercooper.worldeditor.operations.Operator;
import com._14ercooper.worldeditor.operations.OperatorState;
import com._14ercooper.worldeditor.undo.UndoElement;
import com._14ercooper.worldeditor.undo.UndoMode;
import com._14ercooper.worldeditor.undo.UndoSystem;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitScheduler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010!\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0007J\u0010\u0010$\u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0007J\b\u0010%\u001a\u00020!H\u0007J\u0010\u0010&\u001a\u00020\n2\u0006\u0010'\u001a\u00020(H\u0002J\u0016\u0010)\u001a\b\u0012\u0004\u0012\u00020+0*2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u001e\u0010,\u001a\u00020\u00042\u0006\u0010-\u001a\u00020\u00042\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00100*H\u0003J\u0010\u0010/\u001a\u00020!2\u0006\u00100\u001a\u00020\u0004H\u0007J\b\u00101\u001a\u00020!H\u0002J*\u00102\u001a\u00020!2\b\u00103\u001a\u0004\u0018\u0001042\u0006\u00105\u001a\u00020\n2\u0006\u0010\"\u001a\u0002062\u0006\u00107\u001a\u000208H\u0007J2\u00102\u001a\u00020!2\b\u00103\u001a\u0004\u0018\u0001042\u0006\u00105\u001a\u00020\n2\u0006\u0010\"\u001a\u0002062\u0006\u00107\u001a\u0002082\u0006\u0010'\u001a\u00020(H\u0007J2\u00102\u001a\u00020!2\b\u00109\u001a\u0004\u0018\u00010:2\u0006\u0010;\u001a\u0002082\u0006\u0010<\u001a\u00020\u00152\u0006\u0010=\u001a\u00020\n2\u0006\u0010\"\u001a\u000206H\u0007J\"\u00102\u001a\u00020!2\b\u0010>\u001a\u0004\u0018\u00010?2\u0006\u0010\"\u001a\u00020#2\u0006\u00109\u001a\u00020:H\u0007J*\u00102\u001a\u00020!2\b\u0010>\u001a\u0004\u0018\u00010?2\u0006\u0010\"\u001a\u00020#2\u0006\u00109\u001a\u00020:2\u0006\u0010@\u001a\u00020(H\u0007J\u001e\u00102\u001a\u00020!2\f\u0010A\u001a\b\u0012\u0004\u0012\u00020(0\u00172\u0006\u0010B\u001a\u00020#H\u0007J.\u00102\u001a\u00020!2\u000e\u0010C\u001a\n\u0012\u0006\b\u0001\u0012\u00020:0\u00172\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020?0\u00172\u0006\u0010\"\u001a\u00020#H\u0007J6\u00102\u001a\u00020!2\u000e\u0010C\u001a\n\u0012\u0006\b\u0001\u0012\u00020:0\u00172\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020?0\u00172\u0006\u0010\"\u001a\u00020#2\u0006\u0010@\u001a\u00020(H\u0007J\u0012\u0010D\u001a\u00020(2\b\u0010E\u001a\u0004\u0018\u00010#H\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0006\"\u0004\b\u0013\u0010\bR\u000e\u0010\u0014\u001a\u00020\u0015X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00100\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00100\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001a\u001a\u00020\u00048FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u001b\u0010\u0002\u001a\u0004\b\u001c\u0010\u0006R\u001a\u0010\u001d\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u0006\"\u0004\b\u001f\u0010\b\u00a8\u0006F"}, d2={"Lcom/_14ercooper/worldeditor/async/AsyncManager;", "", "()V", "blocksPerAsync", "", "getBlocksPerAsync", "()J", "setBlocksPerAsync", "(J)V", "countEdits", "", "getCountEdits", "()Z", "setCountEdits", "(Z)V", "currentAsyncOp", "Lcom/_14ercooper/worldeditor/async/AsyncOperation;", "doneOperations", "getDoneOperations", "setDoneOperations", "opBlockSize", "", "operations", "", "queueDropped", "queuedOperations", "remainingBlocks", "getRemainingBlocks$annotations", "getRemainingBlocks", "ticksPerAsync", "getTicksPerAsync", "setTicksPerAsync", "asyncDump", "", "p", "Lorg/bukkit/command/CommandSender;", "asyncProgress", "dropAsync", "finishUndo", "undo", "Lcom/_14ercooper/worldeditor/undo/UndoElement;", "getBlock", "", "Lcom/_14ercooper/worldeditor/blockiterator/BlockWrapper;", "getRemBlocks", "remBlocks", "ops", "incrementDoneOperations", "amount", "performOperation", "scheduleEdit", "sl", "Lcom/_14ercooper/schematics/SchemLite;", "saveSchem", "Lorg/bukkit/entity/Player;", "origin", "", "b", "Lcom/_14ercooper/worldeditor/blockiterator/BlockIterator;", "offset", "times", "delOriginal", "o", "Lcom/_14ercooper/worldeditor/operations/Operator;", "ue", "undos", "player", "iterators", "startUndo", "sender", "14erEdit"})
public final class AsyncManager {
    private static long blocksPerAsync;
    private static long ticksPerAsync;
    private static boolean countEdits;
    private static final int opBlockSize = 1;
    private static boolean queueDropped;
    private static List<AsyncOperation> operations;
    private static List<AsyncOperation> queuedOperations;
    private static long doneOperations;
    private static AsyncOperation currentAsyncOp;
    @NotNull
    public static final AsyncManager INSTANCE;

    public final long getBlocksPerAsync() {
        return blocksPerAsync;
    }

    public final void setBlocksPerAsync(long l) {
        blocksPerAsync = l;
    }

    public final long getTicksPerAsync() {
        return ticksPerAsync;
    }

    public final void setTicksPerAsync(long l) {
        ticksPerAsync = l;
    }

    public final boolean getCountEdits() {
        return countEdits;
    }

    public final void setCountEdits(boolean bl) {
        countEdits = bl;
    }

    public final long getDoneOperations() {
        return doneOperations;
    }

    public final void setDoneOperations(long l) {
        doneOperations = l;
    }

    private final UndoElement startUndo(CommandSender sender) {
        return UndoSystem.findUserUndo(sender).getNewUndoElement();
    }

    private final boolean finishUndo(UndoElement undo) {
        return undo.getCurrentState() == UndoMode.WAITING_FOR_BLOCKS ? undo.getUserUndo().finalizeUndo(undo) : true;
    }

    @JvmStatic
    public static final void dropAsync() {
        Main.Companion.logDebug("Async queue dropped.");
        for (AsyncOperation asyncOp : operations) {
            if (asyncOp.getUndo().getCurrentState() != UndoMode.WAITING_FOR_BLOCKS) continue;
            INSTANCE.finishUndo(asyncOp.getUndo());
        }
        for (AsyncOperation asyncOp : queuedOperations) {
            if (asyncOp.getUndo().getCurrentState() != UndoMode.WAITING_FOR_BLOCKS) continue;
            INSTANCE.finishUndo(asyncOp.getUndo());
        }
        boolean bl = false;
        operations = new ArrayList();
        bl = false;
        queuedOperations = new ArrayList();
        queueDropped = true;
        doneOperations += (long)0x3FFFFFFF;
    }

    @JvmStatic
    public static /* synthetic */ void getRemainingBlocks$annotations() {
    }

    public static final long getRemainingBlocks() {
        long remBlocks = 0L;
        remBlocks = AsyncManager.getRemBlocks(remBlocks, operations);
        remBlocks = AsyncManager.getRemBlocks(remBlocks, queuedOperations);
        return remBlocks;
    }

    @JvmStatic
    private static final long getRemBlocks(long remBlocks, List<AsyncOperation> ops) {
        long remBlocksSum = remBlocks;
        for (AsyncOperation a : ops) {
            if (a.getBlocks() != null) {
                BlockIterator blockIterator = a.getBlocks();
                Intrinsics.checkNotNull(blockIterator);
                remBlocksSum += blockIterator.getRemainingBlocks();
                continue;
            }
            remBlocksSum += (long)100;
        }
        return remBlocksSum;
    }

    @JvmStatic
    public static final void asyncProgress(@NotNull CommandSender p) {
        Intrinsics.checkNotNullParameter(p, "p");
        long remBlocks = AsyncManager.getRemainingBlocks();
        int remTime = (int)((double)remBlocks / ((double)blocksPerAsync * (20.0 / (double)ticksPerAsync)));
        p.sendMessage("\u00a7aThere are " + remBlocks + " blocks in the async queue, for an estimated remaining time of less than " + remTime + " seconds.");
    }

    @JvmStatic
    public static final void asyncDump(@NotNull CommandSender p) {
        Intrinsics.checkNotNullParameter(p, "p");
        p.sendMessage("\u00a7aThere are currently " + (operations.size() + queuedOperations.size()) + " operations in the async queue for " + AsyncManager.getRemainingBlocks() + " blocks.");
        p.sendMessage("\u00a7aPer Operation Stats:");
        for (AsyncOperation a : queuedOperations) {
            BlockIterator blockIterator = a.getBlocks();
            BlockIterator blockIterator2 = a.getBlocks();
            p.sendMessage("\u00a7a[Queued] " + (blockIterator != null ? Long.valueOf(blockIterator.getRemainingBlocks()) : null) + " blocks remaining out of " + (blockIterator2 != null ? Long.valueOf(blockIterator2.getTotalBlocks()) : null) + " total blocks. Undo? " + (Object)((Object)a.getUndo().getCurrentState()) + " " + String.valueOf(a.getBlocks()));
        }
        for (AsyncOperation a : operations) {
            BlockIterator blockIterator = a.getBlocks();
            BlockIterator blockIterator3 = a.getBlocks();
            p.sendMessage("\u00a7a[Running] " + (blockIterator != null ? Long.valueOf(blockIterator.getRemainingBlocks()) : null) + " blocks remaining out of " + (blockIterator3 != null ? Long.valueOf(blockIterator3.getTotalBlocks()) : null) + " total blocks. Undo? " + (Object)((Object)a.getUndo().getCurrentState()) + " " + String.valueOf(a.getBlocks()));
        }
    }

    @JvmStatic
    public static final void scheduleEdit(@Nullable Operator o, @NotNull CommandSender p, @NotNull BlockIterator b) {
        Intrinsics.checkNotNullParameter(p, "p");
        Intrinsics.checkNotNullParameter(b, "b");
        queuedOperations.add(new AsyncOperation(o, p, b, INSTANCE.startUndo(p)));
    }

    @JvmStatic
    public static final void scheduleEdit(@Nullable Operator o, @NotNull CommandSender p, @NotNull BlockIterator b, @NotNull UndoElement ue) {
        Intrinsics.checkNotNullParameter(p, "p");
        Intrinsics.checkNotNullParameter(b, "b");
        Intrinsics.checkNotNullParameter(ue, "ue");
        queuedOperations.add(new AsyncOperation(o, p, b, ue));
    }

    @JvmStatic
    public static final void scheduleEdit(@NotNull List<? extends BlockIterator> iterators, @NotNull List<Operator> operations, @NotNull CommandSender p) {
        Intrinsics.checkNotNullParameter(iterators, "iterators");
        Intrinsics.checkNotNullParameter(operations, "operations");
        Intrinsics.checkNotNullParameter(p, "p");
        queuedOperations.add(new AsyncOperation(iterators, operations, p, INSTANCE.startUndo(p)));
    }

    @JvmStatic
    public static final void scheduleEdit(@NotNull List<? extends BlockIterator> iterators, @NotNull List<Operator> operations, @NotNull CommandSender p, @NotNull UndoElement ue) {
        Intrinsics.checkNotNullParameter(iterators, "iterators");
        Intrinsics.checkNotNullParameter(operations, "operations");
        Intrinsics.checkNotNullParameter(p, "p");
        Intrinsics.checkNotNullParameter(ue, "ue");
        queuedOperations.add(new AsyncOperation(iterators, operations, p, ue));
    }

    @JvmStatic
    public static final void scheduleEdit(@Nullable SchemLite sl, boolean saveSchem, @NotNull Player p, @NotNull int[] origin) {
        Intrinsics.checkNotNullParameter(p, "p");
        Intrinsics.checkNotNullParameter(origin, "origin");
        queuedOperations.add(new AsyncOperation(sl, saveSchem, origin, (CommandSender)p, INSTANCE.startUndo((CommandSender)p)));
    }

    @JvmStatic
    public static final void scheduleEdit(@Nullable SchemLite sl, boolean saveSchem, @NotNull Player p, @NotNull int[] origin, @NotNull UndoElement undo) {
        Intrinsics.checkNotNullParameter(p, "p");
        Intrinsics.checkNotNullParameter(origin, "origin");
        Intrinsics.checkNotNullParameter(undo, "undo");
        queuedOperations.add(new AsyncOperation(sl, saveSchem, origin, (CommandSender)p, undo));
    }

    @JvmStatic
    public static final void scheduleEdit(@Nullable BlockIterator b, @NotNull int[] offset, int times, boolean delOriginal, @NotNull Player p) {
        Intrinsics.checkNotNullParameter(offset, "offset");
        Intrinsics.checkNotNullParameter(p, "p");
        queuedOperations.add(new AsyncOperation(b, offset, times, delOriginal, (CommandSender)p, INSTANCE.startUndo((CommandSender)p)));
    }

    @JvmStatic
    public static final void scheduleEdit(@NotNull List<UndoElement> undos, @NotNull CommandSender player) {
        Intrinsics.checkNotNullParameter(undos, "undos");
        Intrinsics.checkNotNullParameter(player, "player");
        queuedOperations.add(new AsyncOperation(undos, player));
    }

    @JvmStatic
    public static final void incrementDoneOperations(long amount) {
        doneOperations += amount;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void performOperation() {
        Main.Companion.outputDebug();
        if (operations.size() < 10) {
            int i = 0;
            while (i < queuedOperations.size() && operations.size() < 10) {
                operations.add(queuedOperations.get(i));
                queuedOperations.remove(i);
            }
        }
        if (operations.size() == 0) {
            if (!UndoSystem.isFlushed()) {
                UndoSystem.flush();
            }
            return;
        }
        doneOperations = 0L;
        if (queueDropped) {
            queueDropped = false;
        }
        block11: while (true) {
            if (doneOperations < blocksPerAsync && operations.size() > 0) {
                if (queueDropped) {
                    queueDropped = false;
                    return;
                }
            } else {
                if (doneOperations > 0L) {
                    Main.Companion.logDebug("Performed " + doneOperations + " async operations");
                }
                return;
            }
            int opSize = operations.size();
            int i = 0;
            while (true) {
                block157: {
                    World world;
                    block163: {
                        block165: {
                            block167: {
                                String[] results;
                                block166: {
                                    block164: {
                                        block160: {
                                            long undoBatchSize;
                                            block162: {
                                                String name;
                                                block161: {
                                                    block159: {
                                                        List<BlockWrapper> b;
                                                        World world2;
                                                        block158: {
                                                            if (i >= opSize) continue block11;
                                                            if (queueDropped) {
                                                                queueDropped = false;
                                                                return;
                                                            }
                                                            AsyncOperation asyncOperation = currentAsyncOp = operations.get(i);
                                                            if (asyncOperation == null) {
                                                                Intrinsics.throwUninitializedPropertyAccessException("currentAsyncOp");
                                                            }
                                                            if (asyncOperation.getBlocks() != null) {
                                                                AsyncOperation asyncOperation2 = currentAsyncOp;
                                                                if (asyncOperation2 == null) {
                                                                    Intrinsics.throwUninitializedPropertyAccessException("currentAsyncOp");
                                                                }
                                                                BlockIterator blockIterator = asyncOperation2.getBlocks();
                                                                Intrinsics.checkNotNull(blockIterator);
                                                                if (blockIterator.getRemainingBlocks() == 0L) {
                                                                    AsyncOperation asyncOperation3 = currentAsyncOp;
                                                                    if (asyncOperation3 == null) {
                                                                        Intrinsics.throwUninitializedPropertyAccessException("currentAsyncOp");
                                                                    }
                                                                    this.finishUndo(asyncOperation3.getUndo());
                                                                    AsyncOperation asyncOperation4 = currentAsyncOp;
                                                                    if (asyncOperation4 == null) {
                                                                        Intrinsics.throwUninitializedPropertyAccessException("currentAsyncOp");
                                                                    }
                                                                    if (StringsKt.equals(asyncOperation4.getKey(), "saveschem", true)) {
                                                                        AsyncOperation asyncOperation5 = currentAsyncOp;
                                                                        if (asyncOperation5 == null) {
                                                                            Intrinsics.throwUninitializedPropertyAccessException("currentAsyncOp");
                                                                        }
                                                                        asyncOperation5.getPlayer().sendMessage("\u00a7aSelection saved");
                                                                    }
                                                                    AsyncOperation asyncOperation6 = currentAsyncOp;
                                                                    if (asyncOperation6 == null) {
                                                                        Intrinsics.throwUninitializedPropertyAccessException("currentAsyncOp");
                                                                    }
                                                                    if (asyncOperation6.getBlocks() instanceof SchemBrushIterator) {
                                                                        AsyncOperation asyncOperation7 = currentAsyncOp;
                                                                        if (asyncOperation7 == null) {
                                                                            Intrinsics.throwUninitializedPropertyAccessException("currentAsyncOp");
                                                                        }
                                                                        BlockIterator blockIterator2 = asyncOperation7.getBlocks();
                                                                        if (blockIterator2 == null) {
                                                                            throw new NullPointerException("null cannot be cast to non-null type com._14ercooper.worldeditor.blockiterator.iterators.SchemBrushIterator");
                                                                        }
                                                                        ((SchemBrushIterator)blockIterator2).cleanup();
                                                                    }
                                                                    operations.remove(i);
                                                                    --i;
                                                                    --opSize;
                                                                    ++i;
                                                                    continue;
                                                                }
                                                            }
                                                            AsyncOperation asyncOperation8 = currentAsyncOp;
                                                            if (asyncOperation8 == null) {
                                                                Intrinsics.throwUninitializedPropertyAccessException("currentAsyncOp");
                                                            }
                                                            if (StringsKt.equals(asyncOperation8.getKey(), "iteredit", true)) break block158;
                                                            AsyncOperation asyncOperation9 = currentAsyncOp;
                                                            if (asyncOperation9 == null) {
                                                                Intrinsics.throwUninitializedPropertyAccessException("currentAsyncOp");
                                                            }
                                                            if (!StringsKt.equals(asyncOperation9.getKey(), "rawiteredit", true)) break block159;
                                                        }
                                                        AsyncOperation asyncOperation = currentAsyncOp;
                                                        if (asyncOperation == null) {
                                                            Intrinsics.throwUninitializedPropertyAccessException("currentAsyncOp");
                                                        }
                                                        if (asyncOperation.getPlayer() instanceof Player) {
                                                            AsyncOperation asyncOperation10 = currentAsyncOp;
                                                            if (asyncOperation10 == null) {
                                                                Intrinsics.throwUninitializedPropertyAccessException("currentAsyncOp");
                                                            }
                                                            CommandSender commandSender = asyncOperation10.getPlayer();
                                                            if (commandSender == null) {
                                                                throw new NullPointerException("null cannot be cast to non-null type org.bukkit.entity.Player");
                                                            }
                                                            world2 = ((Player)commandSender).getWorld();
                                                        } else {
                                                            Plugin plugin = Main.Companion.getPlugin();
                                                            Intrinsics.checkNotNull(plugin);
                                                            Server server = plugin.getServer();
                                                            Intrinsics.checkNotNullExpressionValue(server, "Main.plugin!!.server");
                                                            world2 = (World)server.getWorlds().get(0);
                                                        }
                                                        World currWorld = world2;
                                                        BlockWrapper blockWrapper = new BlockWrapper(currWorld.getBlockAt(14, 14, 14), 14, 14, 14);
                                                        AsyncOperation asyncOperation11 = currentAsyncOp;
                                                        if (asyncOperation11 == null) {
                                                            Intrinsics.throwUninitializedPropertyAccessException("currentAsyncOp");
                                                        }
                                                        CommandSender commandSender = asyncOperation11.getPlayer();
                                                        World world3 = currWorld;
                                                        Intrinsics.checkNotNullExpressionValue(world3, "currWorld");
                                                        AsyncOperation asyncOperation12 = currentAsyncOp;
                                                        if (asyncOperation12 == null) {
                                                            Intrinsics.throwUninitializedPropertyAccessException("currentAsyncOp");
                                                        }
                                                        OperatorState tempState = new OperatorState(blockWrapper, commandSender, world3, asyncOperation12.getUndo(), new Location(currWorld, 14.0, 14.0, 14.0));
                                                        AsyncOperation asyncOperation13 = currentAsyncOp;
                                                        if (asyncOperation13 == null) {
                                                            Intrinsics.throwUninitializedPropertyAccessException("currentAsyncOp");
                                                        }
                                                        BlockIterator blockIterator = asyncOperation13.getBlocks();
                                                        Intrinsics.checkNotNull(blockIterator);
                                                        blockIterator.setObjectArgs("OperatorState", tempState);
                                                        AsyncOperation asyncOperation14 = currentAsyncOp;
                                                        if (asyncOperation14 == null) {
                                                            Intrinsics.throwUninitializedPropertyAccessException("currentAsyncOp");
                                                        }
                                                        if ((b = this.getBlock(asyncOperation14)).isEmpty()) {
                                                            AsyncOperation asyncOperation15 = currentAsyncOp;
                                                            if (asyncOperation15 == null) {
                                                                Intrinsics.throwUninitializedPropertyAccessException("currentAsyncOp");
                                                            }
                                                            this.finishUndo(asyncOperation15.getUndo());
                                                            AsyncOperation asyncOperation16 = currentAsyncOp;
                                                            if (asyncOperation16 == null) {
                                                                Intrinsics.throwUninitializedPropertyAccessException("currentAsyncOp");
                                                            }
                                                            if (asyncOperation16.getBlocks() instanceof SchemBrushIterator) {
                                                                AsyncOperation asyncOperation17 = currentAsyncOp;
                                                                if (asyncOperation17 == null) {
                                                                    Intrinsics.throwUninitializedPropertyAccessException("currentAsyncOp");
                                                                }
                                                                BlockIterator blockIterator3 = asyncOperation17.getBlocks();
                                                                if (blockIterator3 == null) {
                                                                    throw new NullPointerException("null cannot be cast to non-null type com._14ercooper.worldeditor.blockiterator.iterators.SchemBrushIterator");
                                                                }
                                                                ((SchemBrushIterator)blockIterator3).cleanup();
                                                            }
                                                            operations.remove(i);
                                                            --i;
                                                            --opSize;
                                                            ++i;
                                                            continue;
                                                        }
                                                        b.stream().forEach((Consumer)new Consumer<BlockWrapper>(currWorld){
                                                            final /* synthetic */ World $currWorld;

                                                            public final void accept(BlockWrapper it) {
                                                                BlockWrapper blockWrapper = it;
                                                                Intrinsics.checkNotNullExpressionValue(blockWrapper, "it");
                                                                CommandSender commandSender = AsyncManager.access$getCurrentAsyncOp$p(AsyncManager.INSTANCE).getPlayer();
                                                                World world = this.$currWorld;
                                                                Intrinsics.checkNotNullExpressionValue(world, "currWorld");
                                                                UndoElement undoElement = AsyncManager.access$getCurrentAsyncOp$p(AsyncManager.INSTANCE).getUndo();
                                                                BlockIterator blockIterator = AsyncManager.access$getCurrentAsyncOp$p(AsyncManager.INSTANCE).getBlocks();
                                                                Intrinsics.checkNotNull(blockIterator);
                                                                double d = blockIterator.getOriginX();
                                                                BlockIterator blockIterator2 = AsyncManager.access$getCurrentAsyncOp$p(AsyncManager.INSTANCE).getBlocks();
                                                                Intrinsics.checkNotNull(blockIterator2);
                                                                double d2 = blockIterator2.getOriginY();
                                                                BlockIterator blockIterator3 = AsyncManager.access$getCurrentAsyncOp$p(AsyncManager.INSTANCE).getBlocks();
                                                                Intrinsics.checkNotNull(blockIterator3);
                                                                OperatorState state = new OperatorState(blockWrapper, commandSender, world, undoElement, new Location(this.$currWorld, d, d2, (double)blockIterator3.getOriginZ()));
                                                                Operator operator = AsyncManager.access$getCurrentAsyncOp$p(AsyncManager.INSTANCE).getOperation();
                                                                Intrinsics.checkNotNull(operator);
                                                                operator.operateOnBlock(state);
                                                            }
                                                            {
                                                                this.$currWorld = world;
                                                            }
                                                        });
                                                        doneOperations += (long)b.size();
                                                        break block157;
                                                    }
                                                    AsyncOperation asyncOperation = currentAsyncOp;
                                                    if (asyncOperation == null) {
                                                        Intrinsics.throwUninitializedPropertyAccessException("currentAsyncOp");
                                                    }
                                                    if (!StringsKt.equals(asyncOperation.getKey(), "undoedit", true)) break block160;
                                                    undoBatchSize = 32L;
                                                    AsyncOperation asyncOperation18 = currentAsyncOp;
                                                    if (asyncOperation18 == null) {
                                                        Intrinsics.throwUninitializedPropertyAccessException("currentAsyncOp");
                                                    }
                                                    List<UndoElement> list = asyncOperation18.getUndoList();
                                                    Intrinsics.checkNotNull(list);
                                                    if (list.isEmpty()) {
                                                        operations.remove(i);
                                                        --i;
                                                        --opSize;
                                                        ++i;
                                                        continue;
                                                    }
                                                    AsyncOperation asyncOperation19 = currentAsyncOp;
                                                    if (asyncOperation19 == null) {
                                                        Intrinsics.throwUninitializedPropertyAccessException("currentAsyncOp");
                                                    }
                                                    List<UndoElement> list2 = asyncOperation19.getUndoList();
                                                    Intrinsics.checkNotNull(list2);
                                                    if (list2.get(0).getCurrentState() == UndoMode.UNDO_FINISHED) break block161;
                                                    AsyncOperation asyncOperation20 = currentAsyncOp;
                                                    if (asyncOperation20 == null) {
                                                        Intrinsics.throwUninitializedPropertyAccessException("currentAsyncOp");
                                                    }
                                                    List<UndoElement> list3 = asyncOperation20.getUndoList();
                                                    Intrinsics.checkNotNull(list3);
                                                    if (list3.get(0).getCurrentState() != UndoMode.REDO_FINISHED) break block162;
                                                }
                                                AsyncOperation asyncOperation = currentAsyncOp;
                                                if (asyncOperation == null) {
                                                    Intrinsics.throwUninitializedPropertyAccessException("currentAsyncOp");
                                                }
                                                List<UndoElement> list = asyncOperation.getUndoList();
                                                Intrinsics.checkNotNull(list);
                                                if (list.get(0).getCurrentState() == UndoMode.UNDO_FINISHED) {
                                                    String string;
                                                    AsyncOperation asyncOperation21 = currentAsyncOp;
                                                    if (asyncOperation21 == null) {
                                                        Intrinsics.throwUninitializedPropertyAccessException("currentAsyncOp");
                                                    }
                                                    List<UndoElement> list4 = asyncOperation21.getUndoList();
                                                    Intrinsics.checkNotNull(list4);
                                                    list4.get(0).finalizeUndo();
                                                    AsyncOperation asyncOperation22 = currentAsyncOp;
                                                    if (asyncOperation22 == null) {
                                                        Intrinsics.throwUninitializedPropertyAccessException("currentAsyncOp");
                                                    }
                                                    if (asyncOperation22.getUndoList() == null) {
                                                        string = "null";
                                                    } else {
                                                        AsyncOperation asyncOperation23 = currentAsyncOp;
                                                        if (asyncOperation23 == null) {
                                                            Intrinsics.throwUninitializedPropertyAccessException("currentAsyncOp");
                                                        }
                                                        List<UndoElement> list5 = asyncOperation23.getUndoList();
                                                        Intrinsics.checkNotNull(list5);
                                                        string = list5.get(0).getName();
                                                    }
                                                    name = string;
                                                    Main.Companion.logDebug("Undo " + name + " finalized");
                                                } else {
                                                    String string;
                                                    AsyncOperation asyncOperation24 = currentAsyncOp;
                                                    if (asyncOperation24 == null) {
                                                        Intrinsics.throwUninitializedPropertyAccessException("currentAsyncOp");
                                                    }
                                                    List<UndoElement> list6 = asyncOperation24.getUndoList();
                                                    Intrinsics.checkNotNull(list6);
                                                    list6.get(0).finalizeRedo();
                                                    AsyncOperation asyncOperation25 = currentAsyncOp;
                                                    if (asyncOperation25 == null) {
                                                        Intrinsics.throwUninitializedPropertyAccessException("currentAsyncOp");
                                                    }
                                                    if (asyncOperation25.getUndoList() == null) {
                                                        string = "null";
                                                    } else {
                                                        AsyncOperation asyncOperation26 = currentAsyncOp;
                                                        if (asyncOperation26 == null) {
                                                            Intrinsics.throwUninitializedPropertyAccessException("currentAsyncOp");
                                                        }
                                                        List<UndoElement> list7 = asyncOperation26.getUndoList();
                                                        Intrinsics.checkNotNull(list7);
                                                        string = list7.get(0).getName();
                                                    }
                                                    name = string;
                                                    Main.Companion.logDebug("Redo " + name + " finalized");
                                                }
                                                AsyncOperation asyncOperation27 = currentAsyncOp;
                                                if (asyncOperation27 == null) {
                                                    Intrinsics.throwUninitializedPropertyAccessException("currentAsyncOp");
                                                }
                                                List<UndoElement> list8 = asyncOperation27.getUndoList();
                                                Intrinsics.checkNotNull(list8);
                                                list8.remove(0);
                                                AsyncOperation asyncOperation28 = currentAsyncOp;
                                                if (asyncOperation28 == null) {
                                                    Intrinsics.throwUninitializedPropertyAccessException("currentAsyncOp");
                                                }
                                                List<UndoElement> list9 = asyncOperation28.getUndoList();
                                                Intrinsics.checkNotNull(list9);
                                                if (list9.size() == 0) {
                                                    operations.remove(i);
                                                    --i;
                                                    --opSize;
                                                    AsyncOperation asyncOperation29 = currentAsyncOp;
                                                    if (asyncOperation29 == null) {
                                                        Intrinsics.throwUninitializedPropertyAccessException("currentAsyncOp");
                                                    }
                                                    asyncOperation29.getPlayer().sendMessage("\u00a7aUndo operation finished");
                                                    Main.Companion.logDebug("All undos in set finished");
                                                    ++i;
                                                    continue;
                                                }
                                                break block157;
                                            }
                                            AsyncOperation asyncOperation = currentAsyncOp;
                                            if (asyncOperation == null) {
                                                Intrinsics.throwUninitializedPropertyAccessException("currentAsyncOp");
                                            }
                                            List<UndoElement> list = asyncOperation.getUndoList();
                                            Intrinsics.checkNotNull(list);
                                            if (list.get(0).getCurrentState() == UndoMode.PERFORMING_UNDO) {
                                                AsyncOperation asyncOperation30 = currentAsyncOp;
                                                if (asyncOperation30 == null) {
                                                    Intrinsics.throwUninitializedPropertyAccessException("currentAsyncOp");
                                                }
                                                List<UndoElement> list10 = asyncOperation30.getUndoList();
                                                Intrinsics.checkNotNull(list10);
                                                list10.get(0).applyUndo(undoBatchSize);
                                                doneOperations += undoBatchSize;
                                                break block157;
                                            } else {
                                                AsyncOperation asyncOperation31 = currentAsyncOp;
                                                if (asyncOperation31 == null) {
                                                    Intrinsics.throwUninitializedPropertyAccessException("currentAsyncOp");
                                                }
                                                List<UndoElement> list11 = asyncOperation31.getUndoList();
                                                Intrinsics.checkNotNull(list11);
                                                if (list11.get(0).getCurrentState() == UndoMode.PERFORMING_REDO) {
                                                    AsyncOperation asyncOperation32 = currentAsyncOp;
                                                    if (asyncOperation32 == null) {
                                                        Intrinsics.throwUninitializedPropertyAccessException("currentAsyncOp");
                                                    }
                                                    List<UndoElement> list12 = asyncOperation32.getUndoList();
                                                    Intrinsics.checkNotNull(list12);
                                                    list12.get(0).applyRedo(undoBatchSize);
                                                    doneOperations += undoBatchSize;
                                                }
                                            }
                                            break block157;
                                        }
                                        AsyncOperation asyncOperation = currentAsyncOp;
                                        if (asyncOperation == null) {
                                            Intrinsics.throwUninitializedPropertyAccessException("currentAsyncOp");
                                        }
                                        if (StringsKt.equals(asyncOperation.getKey(), "multibrush", true)) break block163;
                                        AsyncOperation asyncOperation33 = currentAsyncOp;
                                        if (asyncOperation33 == null) {
                                            Intrinsics.throwUninitializedPropertyAccessException("currentAsyncOp");
                                        }
                                        if (!StringsKt.equals(asyncOperation33.getKey(), "saveschem", true)) break block164;
                                        AsyncOperation asyncOperation34 = currentAsyncOp;
                                        if (asyncOperation34 == null) {
                                            Intrinsics.throwUninitializedPropertyAccessException("currentAsyncOp");
                                        }
                                        boolean b = asyncOperation34.getBlocks() != null;
                                        boolean originX = false;
                                        boolean originY = false;
                                        if (_Assertions.ENABLED && !b) {
                                            boolean originZ22 = false;
                                            String originZ22 = "Assertion failed";
                                            throw (Throwable)((Object)new AssertionError((Object)originZ22));
                                        }
                                        AsyncOperation asyncOperation35 = currentAsyncOp;
                                        if (asyncOperation35 == null) {
                                            Intrinsics.throwUninitializedPropertyAccessException("currentAsyncOp");
                                        }
                                        BlockIterator blockIterator = asyncOperation35.getBlocks();
                                        Intrinsics.checkNotNull(blockIterator);
                                        AsyncOperation asyncOperation36 = currentAsyncOp;
                                        if (asyncOperation36 == null) {
                                            Intrinsics.throwUninitializedPropertyAccessException("currentAsyncOp");
                                        }
                                        BlockWrapper b2 = blockIterator.getNext(1, asyncOperation36.getPlayer(), true).get(0);
                                        AsyncOperation asyncOperation37 = currentAsyncOp;
                                        if (asyncOperation37 == null) {
                                            Intrinsics.throwUninitializedPropertyAccessException("currentAsyncOp");
                                        }
                                        if (!asyncOperation37.getStartedWrite()) {
                                            try {
                                                AsyncOperation asyncOperation38 = currentAsyncOp;
                                                if (asyncOperation38 == null) {
                                                    Intrinsics.throwUninitializedPropertyAccessException("currentAsyncOp");
                                                }
                                                SchemLite schemLite = asyncOperation38.getSchem();
                                                Intrinsics.checkNotNull(schemLite);
                                                schemLite.resetWrite();
                                                AsyncOperation asyncOperation39 = currentAsyncOp;
                                                if (asyncOperation39 == null) {
                                                    Intrinsics.throwUninitializedPropertyAccessException("currentAsyncOp");
                                                }
                                                asyncOperation39.setStartedWrite(true);
                                            }
                                            catch (IOException e) {
                                                AsyncOperation asyncOperation40 = currentAsyncOp;
                                                if (asyncOperation40 == null) {
                                                    Intrinsics.throwUninitializedPropertyAccessException("currentAsyncOp");
                                                }
                                                Main.Companion.logError("Could not write to schematic file", asyncOperation40.getPlayer(), (Exception)e);
                                            }
                                        }
                                        Block block = b2.block;
                                        Intrinsics.checkNotNullExpressionValue(block, "b.block");
                                        String material = block.getType().toString();
                                        Block block2 = b2.block;
                                        Intrinsics.checkNotNullExpressionValue(block2, "b.block");
                                        BlockData blockData = block2.getBlockData();
                                        Intrinsics.checkNotNullExpressionValue(blockData, "b.block.blockData");
                                        Intrinsics.checkNotNullExpressionValue(blockData.getAsString(), "b.block.blockData.asString");
                                        NBTExtractor nbtE = new NBTExtractor();
                                        Block block3 = b2.block;
                                        Intrinsics.checkNotNullExpressionValue(block3, "b.block");
                                        String nbt = nbtE.getNBT(block3);
                                        try {
                                            String data;
                                            AsyncOperation asyncOperation41 = currentAsyncOp;
                                            if (asyncOperation41 == null) {
                                                Intrinsics.throwUninitializedPropertyAccessException("currentAsyncOp");
                                            }
                                            SchemLite schemLite = asyncOperation41.getSchem();
                                            Intrinsics.checkNotNull(schemLite);
                                            schemLite.writeBlock(material, data, nbt);
                                        }
                                        catch (IOException state) {
                                            // empty catch block
                                        }
                                        long state = doneOperations;
                                        doneOperations = state + 1L;
                                        break block157;
                                    }
                                    AsyncOperation asyncOperation = currentAsyncOp;
                                    if (asyncOperation == null) {
                                        Intrinsics.throwUninitializedPropertyAccessException("currentAsyncOp");
                                    }
                                    if (!StringsKt.equals(asyncOperation.getKey(), "loadschem", true)) break block165;
                                    AsyncOperation asyncOperation42 = currentAsyncOp;
                                    if (asyncOperation42 == null) {
                                        Intrinsics.throwUninitializedPropertyAccessException("currentAsyncOp");
                                    }
                                    BlockIterator blockIterator = asyncOperation42.getBlocks();
                                    Intrinsics.checkNotNull(blockIterator);
                                    AsyncOperation asyncOperation43 = currentAsyncOp;
                                    if (asyncOperation43 == null) {
                                        Intrinsics.throwUninitializedPropertyAccessException("currentAsyncOp");
                                    }
                                    if ((b = blockIterator.getNext(1, asyncOperation43.getPlayer(), true).get(0)) == null) {
                                        AsyncOperation asyncOperation44 = currentAsyncOp;
                                        if (asyncOperation44 == null) {
                                            Intrinsics.throwUninitializedPropertyAccessException("currentAsyncOp");
                                        }
                                        this.finishUndo(asyncOperation44.getUndo());
                                        operations.remove(i);
                                        --i;
                                        --opSize;
                                        try {
                                            AsyncOperation asyncOperation45 = currentAsyncOp;
                                            if (asyncOperation45 == null) {
                                                Intrinsics.throwUninitializedPropertyAccessException("currentAsyncOp");
                                            }
                                            SchemLite schemLite = asyncOperation45.getSchem();
                                            Intrinsics.checkNotNull(schemLite);
                                            schemLite.closeRead();
                                        }
                                        catch (IOException material) {
                                            // empty catch block
                                        }
                                        AsyncOperation asyncOperation46 = currentAsyncOp;
                                        if (asyncOperation46 == null) {
                                            Intrinsics.throwUninitializedPropertyAccessException("currentAsyncOp");
                                        }
                                        asyncOperation46.getPlayer().sendMessage("\u00a7aData loaded");
                                        ++i;
                                        continue;
                                    }
                                    results = new String[]{};
                                    try {
                                        AsyncOperation asyncOperation47 = currentAsyncOp;
                                        if (asyncOperation47 == null) {
                                            Intrinsics.throwUninitializedPropertyAccessException("currentAsyncOp");
                                        }
                                        SchemLite schemLite = asyncOperation47.getSchem();
                                        Intrinsics.checkNotNull(schemLite);
                                        String[] stringArray = schemLite.readNext();
                                        Intrinsics.checkNotNullExpressionValue(stringArray, "currentAsyncOp.schem!!.readNext()");
                                        results = stringArray;
                                    }
                                    catch (IOException data) {
                                        // empty catch block
                                    }
                                    Material m = Material.matchMaterial((String)results[0]);
                                    if (m != null && !m.isAir()) break block166;
                                    AsyncOperation asyncOperation48 = currentAsyncOp;
                                    if (asyncOperation48 == null) {
                                        Intrinsics.throwUninitializedPropertyAccessException("currentAsyncOp");
                                    }
                                    SchemLite schemLite = asyncOperation48.getSchem();
                                    Intrinsics.checkNotNull(schemLite);
                                    if (!schemLite.setAir()) break block167;
                                }
                                Block block = b.block;
                                Intrinsics.checkNotNullExpressionValue(block, "b.block");
                                Material material = Material.matchMaterial((String)results[0]);
                                AsyncOperation asyncOperation = currentAsyncOp;
                                if (asyncOperation == null) {
                                    Intrinsics.throwUninitializedPropertyAccessException("currentAsyncOp");
                                }
                                UndoElement undoElement = asyncOperation.getUndo();
                                AsyncOperation asyncOperation49 = currentAsyncOp;
                                if (asyncOperation49 == null) {
                                    Intrinsics.throwUninitializedPropertyAccessException("currentAsyncOp");
                                }
                                SetBlock.setMaterial(block, material, false, undoElement, asyncOperation49.getPlayer());
                                Block block4 = b.block;
                                Intrinsics.checkNotNullExpressionValue(block4, "b.block");
                                block4.setBlockData(Bukkit.getServer().createBlockData(results[1]));
                                CharSequence nbtE = results[2];
                                boolean nbt = false;
                                if (nbtE.length() > 0) {
                                    String command22 = "data merge block " + b.x + " " + b.y + " " + b.z + " " + results[2];
                                    Bukkit.dispatchCommand((CommandSender)((CommandSender)Bukkit.getConsoleSender()), (String)command22);
                                }
                            }
                            long command22 = doneOperations;
                            doneOperations = command22 + 1L;
                            break block157;
                        }
                        AsyncOperation asyncOperation = currentAsyncOp;
                        if (asyncOperation == null) {
                            Intrinsics.throwUninitializedPropertyAccessException("currentAsyncOp");
                        }
                        if (StringsKt.equals(asyncOperation.getKey(), "selclone", true)) {
                            AsyncOperation asyncOperation50 = currentAsyncOp;
                            if (asyncOperation50 == null) {
                                Intrinsics.throwUninitializedPropertyAccessException("currentAsyncOp");
                            }
                            b = asyncOperation50.getBlocks() != null;
                            int results = 0;
                            int n = 0;
                            if (_Assertions.ENABLED && !b) {
                                boolean command22 = false;
                                String command22 = "Assertion failed";
                                throw (Throwable)((Object)new AssertionError((Object)command22));
                            }
                            AsyncOperation asyncOperation51 = currentAsyncOp;
                            if (asyncOperation51 == null) {
                                Intrinsics.throwUninitializedPropertyAccessException("currentAsyncOp");
                            }
                            BlockIterator blockIterator = asyncOperation51.getBlocks();
                            Intrinsics.checkNotNull(blockIterator);
                            AsyncOperation asyncOperation52 = currentAsyncOp;
                            if (asyncOperation52 == null) {
                                Intrinsics.throwUninitializedPropertyAccessException("currentAsyncOp");
                            }
                            if ((b = blockIterator.getNext(1, asyncOperation52.getPlayer(), true).get(0)) == null) {
                                AsyncOperation asyncOperation53 = currentAsyncOp;
                                if (asyncOperation53 == null) {
                                    Intrinsics.throwUninitializedPropertyAccessException("currentAsyncOp");
                                }
                                this.finishUndo(asyncOperation53.getUndo());
                                operations.remove(i);
                                --i;
                                --opSize;
                                ++i;
                                continue;
                            }
                            results = 0;
                            AsyncOperation asyncOperation54 = currentAsyncOp;
                            if (asyncOperation54 == null) {
                                Intrinsics.throwUninitializedPropertyAccessException("currentAsyncOp");
                            }
                            n = asyncOperation54.getTimes();
                            while (results < n) {
                                Block toEdit;
                                void timesDone;
                                Block block = b.block;
                                AsyncOperation asyncOperation55 = currentAsyncOp;
                                if (asyncOperation55 == null) {
                                    Intrinsics.throwUninitializedPropertyAccessException("currentAsyncOp");
                                }
                                int n2 = asyncOperation55.getOffset()[0] * (1 + timesDone);
                                AsyncOperation asyncOperation56 = currentAsyncOp;
                                if (asyncOperation56 == null) {
                                    Intrinsics.throwUninitializedPropertyAccessException("currentAsyncOp");
                                }
                                int n3 = asyncOperation56.getOffset()[1] * (1 + timesDone);
                                AsyncOperation asyncOperation57 = currentAsyncOp;
                                if (asyncOperation57 == null) {
                                    Intrinsics.throwUninitializedPropertyAccessException("currentAsyncOp");
                                }
                                Intrinsics.checkNotNullExpressionValue(block.getRelative(n2, n3, asyncOperation57.getOffset()[2] * (1 + timesDone)), "b.block.getRelative(\n   \u2026                        )");
                                Block block5 = b.block;
                                Intrinsics.checkNotNullExpressionValue(block5, "b.block");
                                Material material = block5.getType();
                                Block block6 = b.block;
                                Intrinsics.checkNotNullExpressionValue(block6, "b.block");
                                BlockData blockData = block6.getBlockData();
                                AsyncOperation asyncOperation58 = currentAsyncOp;
                                if (asyncOperation58 == null) {
                                    Intrinsics.throwUninitializedPropertyAccessException("currentAsyncOp");
                                }
                                UndoElement undoElement = asyncOperation58.getUndo();
                                AsyncOperation asyncOperation59 = currentAsyncOp;
                                if (asyncOperation59 == null) {
                                    Intrinsics.throwUninitializedPropertyAccessException("currentAsyncOp");
                                }
                                SetBlock.setMaterial(toEdit, material, blockData, false, undoElement, asyncOperation59.getPlayer());
                                NBTExtractor nbt = new NBTExtractor();
                                Block block7 = b.block;
                                Intrinsics.checkNotNullExpressionValue(block7, "b.block");
                                String nbtStr = nbt.getNBT(block7);
                                if (nbtStr.length() > 2) {
                                    String command2 = "data merge block " + toEdit.getX() + " " + toEdit.getY() + " " + toEdit.getZ() + " " + nbtStr;
                                    Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getConsoleSender(), command2);
                                    long l = doneOperations;
                                    doneOperations = l + 1L;
                                }
                                ++timesDone;
                            }
                            AsyncOperation asyncOperation60 = currentAsyncOp;
                            if (asyncOperation60 == null) {
                                Intrinsics.throwUninitializedPropertyAccessException("currentAsyncOp");
                            }
                            if (asyncOperation60.getDelOriginal()) {
                                Block block = b.block;
                                Intrinsics.checkNotNullExpressionValue(block, "b.block");
                                AsyncOperation asyncOperation61 = currentAsyncOp;
                                if (asyncOperation61 == null) {
                                    Intrinsics.throwUninitializedPropertyAccessException("currentAsyncOp");
                                }
                                UndoElement undoElement = asyncOperation61.getUndo();
                                AsyncOperation asyncOperation62 = currentAsyncOp;
                                if (asyncOperation62 == null) {
                                    Intrinsics.throwUninitializedPropertyAccessException("currentAsyncOp");
                                }
                                SetBlock.setMaterial(block, Material.AIR, false, undoElement, asyncOperation62.getPlayer());
                                long l = doneOperations;
                                doneOperations = l + 1L;
                            }
                            AsyncOperation asyncOperation63 = currentAsyncOp;
                            if (asyncOperation63 == null) {
                                Intrinsics.throwUninitializedPropertyAccessException("currentAsyncOp");
                            }
                            doneOperations += (long)asyncOperation63.getTimes();
                            break block157;
                        } else {
                            AsyncOperation asyncOperation64 = currentAsyncOp;
                            if (asyncOperation64 == null) {
                                Intrinsics.throwUninitializedPropertyAccessException("currentAsyncOp");
                            }
                            this.finishUndo(asyncOperation64.getUndo());
                            Main.Companion.logError("Invalid operation in async queue. Removing operation.", (CommandSender)Bukkit.getConsoleSender(), null);
                            operations.remove(i);
                            --i;
                            --opSize;
                        }
                        break block157;
                    }
                    BlockWrapper b = null;
                    int originX = 14;
                    int originY = 14;
                    int originZ22 = 14;
                    while (true) {
                        AsyncOperation asyncOperation = currentAsyncOp;
                        if (asyncOperation == null) {
                            Intrinsics.throwUninitializedPropertyAccessException("currentAsyncOp");
                        }
                        if (asyncOperation.getIterators().size() == 0) {
                            b = null;
                            break;
                        }
                        try {
                            AsyncOperation asyncOperation65 = currentAsyncOp;
                            if (asyncOperation65 == null) {
                                Intrinsics.throwUninitializedPropertyAccessException("currentAsyncOp");
                            }
                            AsyncOperation asyncOperation66 = currentAsyncOp;
                            if (asyncOperation66 == null) {
                                Intrinsics.throwUninitializedPropertyAccessException("currentAsyncOp");
                            }
                            b = asyncOperation65.getIterators().get(0).getNextBlock(asyncOperation66.getPlayer(), true);
                            AsyncOperation asyncOperation67 = currentAsyncOp;
                            if (asyncOperation67 == null) {
                                Intrinsics.throwUninitializedPropertyAccessException("currentAsyncOp");
                            }
                            originX = asyncOperation67.getIterators().get(0).getOriginX();
                            AsyncOperation asyncOperation68 = currentAsyncOp;
                            if (asyncOperation68 == null) {
                                Intrinsics.throwUninitializedPropertyAccessException("currentAsyncOp");
                            }
                            originY = asyncOperation68.getIterators().get(0).getOriginY();
                            AsyncOperation asyncOperation69 = currentAsyncOp;
                            if (asyncOperation69 == null) {
                                Intrinsics.throwUninitializedPropertyAccessException("currentAsyncOp");
                            }
                            originZ22 = asyncOperation69.getIterators().get(0).getOriginZ();
                        }
                        catch (IndexOutOfBoundsException e) {
                            AsyncOperation asyncOperation70 = currentAsyncOp;
                            if (asyncOperation70 == null) {
                                Intrinsics.throwUninitializedPropertyAccessException("currentAsyncOp");
                            }
                            Main.Companion.logError("Multibrush error: no iterators (does the file exist?)", asyncOperation70.getPlayer(), (Exception)e);
                            AsyncManager.dropAsync();
                            return;
                        }
                        if (b != null) break;
                        AsyncOperation asyncOperation71 = currentAsyncOp;
                        if (asyncOperation71 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException("currentAsyncOp");
                        }
                        if (asyncOperation71.getIterators().get(0) instanceof SchemBrushIterator) {
                            AsyncOperation asyncOperation72 = currentAsyncOp;
                            if (asyncOperation72 == null) {
                                Intrinsics.throwUninitializedPropertyAccessException("currentAsyncOp");
                            }
                            BlockIterator blockIterator = asyncOperation72.getIterators().get(0);
                            if (blockIterator == null) {
                                throw new NullPointerException("null cannot be cast to non-null type com._14ercooper.worldeditor.blockiterator.iterators.SchemBrushIterator");
                            }
                            ((SchemBrushIterator)blockIterator).cleanup();
                        }
                        AsyncOperation asyncOperation73 = currentAsyncOp;
                        if (asyncOperation73 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException("currentAsyncOp");
                        }
                        CollectionsKt.removeFirst(asyncOperation73.getIterators());
                        AsyncOperation asyncOperation74 = currentAsyncOp;
                        if (asyncOperation74 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException("currentAsyncOp");
                        }
                        CollectionsKt.removeFirst(asyncOperation74.getOperations());
                    }
                    if (b == null) {
                        AsyncOperation asyncOperation = currentAsyncOp;
                        if (asyncOperation == null) {
                            Intrinsics.throwUninitializedPropertyAccessException("currentAsyncOp");
                        }
                        this.finishUndo(asyncOperation.getUndo());
                        operations.remove(i);
                        --i;
                        --opSize;
                        ++i;
                        continue;
                    }
                    AsyncOperation asyncOperation = currentAsyncOp;
                    if (asyncOperation == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("currentAsyncOp");
                    }
                    if (asyncOperation.getPlayer() instanceof Player) {
                        AsyncOperation asyncOperation75 = currentAsyncOp;
                        if (asyncOperation75 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException("currentAsyncOp");
                        }
                        CommandSender commandSender = asyncOperation75.getPlayer();
                        if (commandSender == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.bukkit.entity.Player");
                        }
                        world = ((Player)commandSender).getWorld();
                    } else {
                        Plugin plugin = Main.Companion.getPlugin();
                        Intrinsics.checkNotNull(plugin);
                        Server server = plugin.getServer();
                        Intrinsics.checkNotNullExpressionValue(server, "Main.plugin!!.server");
                        world = (World)server.getWorlds().get(0);
                    }
                    World currWorld = world;
                    AsyncOperation asyncOperation76 = currentAsyncOp;
                    if (asyncOperation76 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("currentAsyncOp");
                    }
                    CommandSender commandSender = asyncOperation76.getPlayer();
                    World world4 = currWorld;
                    Intrinsics.checkNotNullExpressionValue(world4, "currWorld");
                    AsyncOperation asyncOperation77 = currentAsyncOp;
                    if (asyncOperation77 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("currentAsyncOp");
                    }
                    OperatorState state = new OperatorState(b, commandSender, world4, asyncOperation77.getUndo(), new Location(currWorld, (double)originX, (double)originY, (double)originZ22));
                    AsyncOperation asyncOperation78 = currentAsyncOp;
                    if (asyncOperation78 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("currentAsyncOp");
                    }
                    asyncOperation78.getOperations().get(0).operateOnBlock(state);
                    ++doneOperations;
                }
                ++i;
            }
            break;
        }
    }

    private final List<BlockWrapper> getBlock(AsyncOperation currentAsyncOp) {
        boolean bl = currentAsyncOp.getBlocks() != null;
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        BlockIterator blockIterator = currentAsyncOp.getBlocks();
        Intrinsics.checkNotNull(blockIterator);
        List<BlockWrapper> list = blockIterator.getNext(1, currentAsyncOp.getPlayer(), true);
        Intrinsics.checkNotNullExpressionValue(list, "currentAsyncOp.blocks!!.\u2026rentAsyncOp.player, true)");
        return list;
    }

    private AsyncManager() {
    }

    static {
        AsyncManager asyncManager;
        INSTANCE = asyncManager = new AsyncManager();
        blocksPerAsync = 10000L;
        ticksPerAsync = 4L;
        boolean bl = false;
        operations = new ArrayList();
        bl = false;
        queuedOperations = new ArrayList();
        try {
            Server server = Bukkit.getServer();
            Intrinsics.checkNotNullExpressionValue(server, "Bukkit.getServer()");
            BukkitScheduler bukkitScheduler = server.getScheduler();
            Intrinsics.checkNotNullExpressionValue(bukkitScheduler, "Bukkit.getServer().scheduler");
            BukkitScheduler scheduler = bukkitScheduler;
            Plugin plugin = Main.Companion.getPlugin();
            Intrinsics.checkNotNull(plugin);
            scheduler.scheduleSyncRepeatingTask(plugin, (Runnable)1.INSTANCE, ticksPerAsync, ticksPerAsync);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public static final /* synthetic */ AsyncOperation access$getCurrentAsyncOp$p(AsyncManager $this) {
        AsyncManager asyncManager = $this;
        AsyncOperation asyncOperation = currentAsyncOp;
        if (asyncOperation == null) {
            Intrinsics.throwUninitializedPropertyAccessException("currentAsyncOp");
        }
        return asyncOperation;
    }

    public static final /* synthetic */ void access$setCurrentAsyncOp$p(AsyncManager $this, AsyncOperation asyncOperation) {
        AsyncManager asyncManager = $this;
        currentAsyncOp = asyncOperation;
    }
}

