/*
 * Decompiled with CFR 0.152.
 */
package com._14ercooper.schematics;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.util.LinkedList;

public class Schematic
implements Serializable {
    private final LinkedList<String> blockData;
    private final LinkedList<String> blockEntityData;
    String author = "Unset";
    String name = "Unset";
    private int[] origin = new int[]{0, 0, 0};
    private int[] dimensions = new int[]{0, 0, 0};
    private LinkedList<String> entityData;
    private LinkedList<String> biomeData;

    public Schematic(int[] schematicOrigin, int[] schematicDimensions, LinkedList<String> blocks, LinkedList<String> blockNbt) {
        this.origin = schematicOrigin;
        this.dimensions = schematicDimensions;
        this.blockData = blocks;
        this.blockEntityData = blockNbt;
    }

    public Schematic(String schematicName, String schematicAuthor, int[] schematicOrigin, int[] schematicDimensions, LinkedList<String> blocks, LinkedList<String> blockNbt) {
        this.origin = schematicOrigin;
        this.dimensions = schematicDimensions;
        this.name = schematicName;
        this.author = schematicAuthor;
        this.blockData = blocks;
        this.blockEntityData = blockNbt;
    }

    public static int[] getLoaderVersion() {
        return new int[]{3};
    }

    public int[] getOrigin() {
        return this.origin;
    }

    public int[] getDimensions() {
        return this.dimensions;
    }

    public LinkedList<String> getBlocks() {
        return this.blockData;
    }

    public LinkedList<String> getBlockNbt() {
        return this.blockEntityData;
    }

    public String getName() {
        return this.name;
    }

    public String getAuthor() {
        return this.author;
    }

    public boolean saveSchematic(String filePath) {
        filePath = filePath.concat(".matschem");
        new File(filePath).mkdirs();
        try {
            Files.deleteIfExists(new File(filePath).toPath());
            ObjectOutputStream oo = new ObjectOutputStream(new FileOutputStream(filePath));
            oo.writeObject(this);
            oo.close();
            return true;
        }
        catch (FileNotFoundException e) {
            System.out.println("[Schematic] File not found or could not be created while saving schematic.");
            return false;
        }
        catch (IOException e) {
            System.out.println("[Schematic] File I/O error while saving schematic.");
            return false;
        }
    }

    public static Schematic loadSchematic(String filePath) {
        System.out.println(new File(filePath).toPath());
        Schematic schem = null;
        try {
            ObjectInputStream oi = new ObjectInputStream(new FileInputStream(filePath));
            Object schematicObj = oi.readObject();
            schem = (Schematic)schematicObj;
            oi.close();
        }
        catch (FileNotFoundException e) {
            System.out.println("[Schematic] File not found while loading schematic");
        }
        catch (IOException e) {
            System.out.println("[Schematic] File I/O error while loading schematic");
        }
        catch (ClassNotFoundException e) {
            System.out.println("[Schematic] Class not found while loading schematic");
        }
        return schem;
    }

    public int getVersion() {
        int formatVersion = 3;
        return formatVersion;
    }
}

