/*
 * Decompiled with CFR 0.152.
 */
package com._14ercooper.schematics;

import com._14ercooper.worldeditor.blockiterator.BlockIterator;
import com._14ercooper.worldeditor.blockiterator.IteratorManager;
import com._14ercooper.worldeditor.main.Main;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.CommandSender;

public class SchemLite {
    int xSize;
    int ySize;
    int zSize;
    String outPath;
    String authorName;
    String creationDate;
    BufferedReader reader;
    BufferedWriter writer;
    boolean xMirror = false;
    boolean yMirror = false;
    boolean zMirror = false;
    int executionOrder = 0;
    boolean setAir = true;

    public SchemLite(int x, int y, int z, String outPath, String author, String date) {
        this.xSize = x;
        this.ySize = y;
        this.zSize = z;
        this.outPath = "plugins/14erEdit/schematics/" + outPath;
        this.authorName = author;
        this.creationDate = date;
        try {
            this.resetWrite();
        }
        catch (IOException e) {
            Main.logDebug("Error initializing schematic file.");
        }
    }

    public SchemLite(String inPath, boolean setAir, int executionOrder) {
        this.outPath = "plugins/14erEdit/schematics/" + inPath;
        this.setAir = setAir;
        this.executionOrder = executionOrder;
    }

    public BlockIterator getIterator(int xStart, int yStart, int zStart, World world) {
        int temp;
        int xS = xStart;
        int yS = yStart;
        int zS = zStart;
        int xE = xStart + this.xSize - 1;
        int yE = yStart + this.ySize - 1;
        int zE = zStart + this.zSize - 1;
        if (this.xMirror) {
            temp = xS;
            xS = xE;
            xE = temp;
        }
        if (this.yMirror) {
            temp = yS;
            yS = yE;
            yE = temp;
        }
        if (this.zMirror) {
            temp = zS;
            zS = zE;
            zE = temp;
        }
        ArrayList<String> iterArgs = new ArrayList<String>();
        iterArgs.add(Integer.toString(xS));
        iterArgs.add(Integer.toString(yS));
        iterArgs.add(Integer.toString(zS));
        iterArgs.add(Integer.toString(xE));
        iterArgs.add(Integer.toString(yE));
        iterArgs.add(Integer.toString(zE));
        iterArgs.add(Integer.toString(this.executionOrder));
        return IteratorManager.INSTANCE.getIterator("cube").newIterator(iterArgs, world, (CommandSender)Bukkit.getConsoleSender());
    }

    public void resetWrite() throws IOException {
        Files.deleteIfExists(Paths.get(this.outPath, new String[0]));
        this.writer = Files.newBufferedWriter(Paths.get(this.outPath, new String[0]), StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.APPEND);
        this.writer.write(Integer.toString(this.xSize));
        this.writer.newLine();
        this.writer.write(Integer.toString(this.ySize));
        this.writer.newLine();
        this.writer.write(Integer.toString(this.zSize));
        this.writer.newLine();
        this.writer.write(this.authorName);
        this.writer.newLine();
        this.writer.write(this.creationDate);
        this.writer.newLine();
        this.writer.close();
    }

    public void writeBlock(String material, String data, String nbt) throws IOException {
        this.writer = Files.newBufferedWriter(Paths.get(this.outPath, new String[0]), StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.APPEND);
        this.writer.write(material);
        this.writer.newLine();
        this.writer.write(data);
        this.writer.newLine();
        this.writer.write(nbt.replaceAll("[\\n\\r]", "\u65b0\u3057\u3044\u7dda"));
        this.writer.newLine();
        this.writer.close();
    }

    public void writeBlock(String[] block) throws IOException {
        this.writeBlock(block[0], block[1], block[2]);
    }

    public void openRead() throws IOException {
        this.reader = Files.newBufferedReader(Paths.get(this.outPath, new String[0]));
        this.xSize = Integer.parseInt(this.reader.readLine());
        this.ySize = Integer.parseInt(this.reader.readLine());
        this.zSize = Integer.parseInt(this.reader.readLine());
        this.authorName = this.reader.readLine();
        this.creationDate = this.reader.readLine();
        Main.logDebug("Opened read");
    }

    public String[] readNext() throws IOException {
        String[] array = new String[]{this.reader.readLine(), this.reader.readLine(), this.reader.readLine()};
        if (array[2] != null) {
            array[2] = array[2].replaceAll("\u65b0\u3057\u3044\u7dda", "\n");
        }
        return array;
    }

    public void closeRead() throws IOException {
        this.reader.close();
    }

    public void moveRef(String newPath) throws IOException {
        Files.move(Paths.get(this.outPath, new String[0]), Paths.get("plugins/14erEdit/schematics/" + newPath, new String[0]), StandardCopyOption.REPLACE_EXISTING);
        this.outPath = "plugins/14erEdit/" + newPath;
    }

    public void cloneTo(String path) throws IOException {
        Files.copy(Paths.get(this.outPath, new String[0]), Paths.get("plugins/14erEdit/schematics/" + path, new String[0]), StandardCopyOption.REPLACE_EXISTING);
    }

    public void loadFrom(String path) throws IOException {
        Files.copy(Paths.get("plugins/14erEdit/schematics/" + path, new String[0]), Paths.get(this.outPath, new String[0]), StandardCopyOption.REPLACE_EXISTING);
    }

    public void mirror(boolean x, boolean y, boolean z) {
        this.xMirror = x;
        this.yMirror = y;
        this.zMirror = z;
    }

    public int getXSize() {
        return this.xSize;
    }

    public int getYSize() {
        return this.ySize;
    }

    public int getZSize() {
        return this.zSize;
    }

    public boolean setAir() {
        return this.setAir;
    }
}

