/*
 * Decompiled with CFR 0.152.
 */
package com._14ercooper.megaserver;

import com._14ercooper.megaserver.Artifacts;
import com._14ercooper.megaserver.FileIO;
import com._14ercooper.megaserver.Properties;
import com._14ercooper.megaserver.UserInput;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\b2\u0006\u0010\t\u001a\u00020\u0004H\u0002J\b\u0010\n\u001a\u00020\u0006H\u0002J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0004H\u0002J\u0019\u0010\r\u001a\u00020\u00062\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u000f\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u0011\u001a\u00020\u0004H\u0002J\u0014\u0010\u0012\u001a\u00020\u00062\n\u0010\u0013\u001a\u00060\u0014j\u0002`\u0015H\u0002J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u0004H\u0002J\b\u0010\u001a\u001a\u00020\u0006H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/_14ercooper/megaserver/Main;", "", "()V", "javaPath", "", "choosePlugins", "", "plugins", "", "version", "clearConsole", "inProfile", "profile", "mainStageTwo", "args", "", "([Ljava/lang/String;)V", "newProfile", "onError", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "runProcess", "Ljava/lang/Process;", "cmd", "dir", "setup", "14erEdit"})
public final class Main {
    private static String javaPath;
    @NotNull
    public static final Main INSTANCE;

    public final void mainStageTwo(@NotNull String[] args2) {
        Intrinsics.checkNotNullParameter(args2, "args");
        boolean updateArtifacts = false;
        while (true) {
            try {
                String s2;
                for (String s2 : args2) {
                    if (StringsKt.equals(s2, "--force-offline", true)) {
                        Artifacts.INSTANCE.setForceOffline(true);
                    }
                    if (StringsKt.equals(s2, "--update", true)) {
                        updateArtifacts = true;
                    }
                    if (!StringsKt.contains$default((CharSequence)s2, "--javaPath", false, 2, null)) continue;
                    Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)s2, new String[]{"="}, false, 0, 6, null);
                    boolean $i$f$toTypedArray = false;
                    Collection thisCollection$iv = $this$toTypedArray$iv;
                    String[] stringArray = thisCollection$iv.toArray(new String[0]);
                    if (stringArray == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                    }
                    javaPath = stringArray[1];
                }
                this.clearConsole();
                s2 = "14erEdit - Mapmaking Megaserver";
                int n = 0;
                System.out.println((Object)s2);
                s2 = "Contributors on the GitHub. Licensed under GPL-3.0. All rights reserved.";
                n = 0;
                System.out.println((Object)s2);
                s2 = "Not affiliated with Mojang, Minecraft, or Microsoft.";
                n = 0;
                System.out.println((Object)s2);
                s2 = "This is free software. You should not have paid for this.";
                n = 0;
                System.out.println((Object)s2);
                s2 = "This software comes with no warranties.";
                n = 0;
                System.out.println((Object)s2);
                Thread.sleep(5000L);
                this.clearConsole();
                if (!FileIO.INSTANCE.exists("init.mms")) {
                    this.setup();
                }
                if (Artifacts.INSTANCE.internetConnected()) {
                    if (updateArtifacts) {
                        FileIO.INSTANCE.deleteFile("artifacts", true);
                        FileIO.INSTANCE.makePath("artifacts");
                        s2 = "Redownloading all artifacts (this could take a LONG time)...";
                        n = 0;
                        System.out.println((Object)s2);
                    }
                    Artifacts.INSTANCE.updateArtifacts();
                    s2 = "Updated all artifacts";
                    n = 0;
                    System.out.println((Object)s2);
                }
                Artifacts.INSTANCE.loadLocalArtifacts();
                while (true) {
                    this.clearConsole();
                    s2 = "What profile?";
                    n = 0;
                    System.out.println((Object)s2);
                    ArrayList<String> profiles = new ArrayList<String>();
                    profiles.addAll((Collection)FileIO.INSTANCE.listFiles("profiles", true));
                    if (profiles.size() == 0) {
                        this.newProfile();
                        continue;
                    }
                    profiles.add("New profile");
                    profiles.add("Exit Server");
                    String profile = UserInput.INSTANCE.fromList((List<String>)profiles);
                    if (StringsKt.equals(profile, "new profile", true)) {
                        profile = this.newProfile();
                    }
                    if (StringsKt.equals(profile, "exit server", true)) {
                        return;
                    }
                    this.inProfile(profile);
                }
            }
            catch (Exception e) {
                this.onError(e);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void inProfile(String profile) throws IOException, InterruptedException {
        int input;
        do {
            boolean bl;
            int n;
            this.clearConsole();
            String string = "Options for " + profile + ':';
            boolean bl2 = false;
            System.out.println((Object)string);
            string = "\t1) Start server";
            bl2 = false;
            System.out.println((Object)string);
            string = "\t2) Change version";
            bl2 = false;
            System.out.println((Object)string);
            string = "\t3) Change plugins";
            bl2 = false;
            System.out.println((Object)string);
            string = "\t4) Change RAM";
            bl2 = false;
            System.out.println((Object)string);
            string = "\t5) Delete backups";
            bl2 = false;
            System.out.println((Object)string);
            string = "\t6) Delete profile";
            bl2 = false;
            System.out.println((Object)string);
            string = "\t7) Back";
            bl2 = false;
            System.out.println((Object)string);
            string = "  > ";
            bl2 = false;
            System.out.print((Object)string);
            input = UserInput.INSTANCE.numberRange(1, 7);
            ArrayList vars = new ArrayList();
            Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)FileIO.INSTANCE.readFromFile("profiles/" + profile + "/data.mms"), new String[]{"&"}, false, 0, 6, null);
            boolean $i$f$toTypedArray = false;
            Object thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            if (stringArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            vars.addAll(CollectionsKt.listOf(Arrays.copyOf(stringArray, stringArray.length)));
            Object e = vars.get(0);
            Intrinsics.checkNotNullExpressionValue(e, "vars[0]");
            String version = StringsKt.replace$default(StringsKt.replace$default((String)e, "\n", "", false, 4, null), "\r", "", false, 4, null);
            try {
                Object e2 = vars.get(1);
                Intrinsics.checkNotNullExpressionValue(e2, "vars[1]");
                thisCollection$iv = StringsKt.replace$default(StringsKt.replace$default((String)e2, "\n", "", false, 4, null), "\r", "", false, 4, null);
            }
            catch (IndexOutOfBoundsException e3) {
                thisCollection$iv = "2048";
            }
            Object ramAmt = thisCollection$iv;
            List plugins = new ArrayList();
            int e3 = 2;
            int n2 = vars.size();
            while (e3 < n2) {
                void i;
                Object e4 = vars.get((int)i);
                Intrinsics.checkNotNullExpressionValue(e4, "vars[i]");
                plugins.add(StringsKt.replace$default(StringsKt.replace$default((String)e4, "\n", "", false, 4, null), "\r", "", false, 4, null));
                ++i;
            }
            if (input == 1) {
                String jarPath = Artifacts.INSTANCE.getArtifactPath("Server", version, "Paper");
                if (StringsKt.equals(jarPath, "", true)) {
                    String string2 = "Could not locate jar file";
                    n = 0;
                    System.out.println((Object)string2);
                    Thread.sleep(5000L);
                }
                FileIO.INSTANCE.copyFile(jarPath, "profiles/" + profile + "/server.jar", false);
                for (String s : plugins) {
                    String path22 = Artifacts.INSTANCE.getArtifactPath("Plugin", version, s);
                    if (StringsKt.equals(path22, "", true)) continue;
                    FileIO.INSTANCE.copyFile(path22, "profiles/" + profile + "/plugins/" + s + ".jar", false);
                }
                try {
                    Files.createSymbolicLink(Paths.get("profiles/" + profile + "/plugins/14erEdit", new String[0]).toAbsolutePath(), Paths.get("14erEdit", new String[0]).toAbsolutePath(), new FileAttribute[0]);
                }
                catch (Exception e5) {
                    try {
                        FileIO.INSTANCE.copyFile("14erEdit", "profiles/" + profile + "/plugins/14erEdit", true);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        FileIO.INSTANCE.deleteFile("14erEdit/undo", true);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                Object object = ramAmt;
                boolean path22 = false;
                String quarterRam = String.valueOf(Integer.parseInt((String)object) / 4);
                Object path22 = ramAmt;
                bl = false;
                String eighthRam = String.valueOf(Integer.parseInt((String)path22) / 8);
                String command2 = javaPath + " -jar -Dlog4j2.formatMsgNoLookups=true -DIReallyKnowWhatIAmDoingISwear=true -Xmx" + (String)ramAmt + "M -Xms" + (String)ramAmt + "M -XX:+UseZGC server.jar nogui";
                this.clearConsole();
                Process p = this.runProcess(command2, "profiles/" + profile);
                while (p.isAlive()) {
                    Thread.sleep(5000L);
                }
                try {
                    FileIO.INSTANCE.deleteFile("profiles/" + profile + "/plugins/14erEdit", false);
                }
                catch (Exception e6) {
                    try {
                        FileIO.INSTANCE.copyFile("profiles/" + profile + "/plugins/14erEdit", "14erEdit", true);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        FileIO.INSTANCE.deleteFile("profiles/" + profile + "/plugins/14erEdit", true);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                FileIO.INSTANCE.deleteFile("profiles/" + profile + "/logs", true);
                FileIO.INSTANCE.deleteFile("profiles/" + profile + "/server.jar", false);
                for (String s : plugins) {
                    FileIO.INSTANCE.deleteFile("profiles/" + profile + "/plugins/" + s + ".jar", false);
                }
                File file = new File("profiles/" + profile);
                File file2 = new File("backups");
                StringBuilder stringBuilder = new StringBuilder().append(profile).append("_");
                Instant instant = Instant.now();
                Intrinsics.checkNotNullExpressionValue(instant, "Instant.now()");
                FileIO.INSTANCE.zipDirectory(file, file2, profile, stringBuilder.append(String.valueOf(instant.getEpochSecond())).toString());
            }
            if (input == 2) {
                List<String> versions = Artifacts.INSTANCE.getVersions();
                String quarterRam = "What Minecraft version?";
                boolean bl3 = false;
                System.out.println((Object)quarterRam);
                version = UserInput.INSTANCE.fromList(versions);
                input = 3;
            }
            if (input == 3) {
                plugins = new ArrayList();
                this.choosePlugins(plugins, version);
            }
            if (input == 4) {
                String versions = "How much RAM should the server use (MB)?";
                boolean quarterRam = false;
                System.out.println((Object)versions);
                int max = 8192;
                ramAmt = String.valueOf(UserInput.INSTANCE.numberRange(512, max));
            }
            if (input == 5) {
                List<String> backups = FileIO.INSTANCE.listFiles("backups", false);
                for (String s22 : backups) {
                    if (!StringsKt.contains$default((CharSequence)s22, profile, false, 2, null)) continue;
                    FileIO.INSTANCE.deleteFile("backups/" + s22, false);
                }
            }
            if (input == 6) {
                String backups = "Please type the profile name to confirm deletion.";
                boolean s22 = false;
                System.out.println((Object)backups);
                String confirmDelete = UserInput.INSTANCE.patternMatch("[A-Za-z0-9\\-_]");
                String s22 = profile;
                boolean bl4 = false;
                String string3 = s22;
                if (string3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                if (string3.contentEquals(confirmDelete)) {
                    FileIO.INSTANCE.deleteFile("profiles/" + profile, true);
                    return;
                }
            }
            String data = version + '&';
            data = data + (String)ramAmt + '&';
            for (String s : plugins) {
                data = data + s + '&';
            }
            String string4 = data;
            n = 0;
            int n3 = data.length() - 1;
            bl = false;
            String string5 = string4;
            if (string5 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string6 = string5.substring(n, n3);
            Intrinsics.checkNotNullExpressionValue(string6, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            data = string6;
            FileIO.INSTANCE.writeToFile("profiles/" + profile + "/data.mms", false, data);
        } while (input != 7);
    }

    private final void choosePlugins(List<String> plugins, String version) {
        while (true) {
            String s22;
            String string = "Plugins to install:\nInstalled: ";
            boolean bl = false;
            System.out.println((Object)string);
            for (String s22 : plugins) {
                String string2 = s22 + ' ';
                boolean bl2 = false;
                System.out.print((Object)string2);
            }
            boolean s22 = false;
            System.out.println();
            s22 = "Install which plugins?";
            boolean bl3 = false;
            System.out.println((Object)s22);
            List<String> artifactList = Artifacts.INSTANCE.getLocalArtifacts("Plugin", version);
            List pluginList = new ArrayList();
            for (String s : artifactList) {
                Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)s, new String[]{";"}, false, 0, 6, null);
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                String[] stringArray = thisCollection$iv.toArray(new String[0]);
                if (stringArray == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                pluginList.add(stringArray[2]);
            }
            pluginList.add("Done");
            String plugin = UserInput.INSTANCE.fromList(pluginList);
            if (StringsKt.equals(plugin, "done", true)) break;
            if (plugins.contains(plugin)) {
                plugins.remove(plugin);
                continue;
            }
            plugins.add(plugin);
        }
    }

    private final String newProfile() throws IOException {
        String s2;
        String string = "Profile name? (alphanumeric only)";
        boolean bl = false;
        System.out.println((Object)string);
        String name = UserInput.INSTANCE.patternMatch("[A-Za-z0-9\\-_]");
        List<String> versions = Artifacts.INSTANCE.getVersions();
        String string2 = "What Minecraft version?";
        boolean bl2 = false;
        System.out.println((Object)string2);
        String version = UserInput.INSTANCE.fromList(versions);
        List plugins = new ArrayList();
        this.choosePlugins(plugins, version);
        String data = version + '&';
        data = data + "2048&";
        for (String s2 : plugins) {
            data = data + s2 + '&';
        }
        s2 = data;
        int n = 0;
        int n2 = data.length() - 1;
        boolean bl3 = false;
        String string3 = s2;
        if (string3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue(string4, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        data = string4;
        FileIO.INSTANCE.makePath("profiles/" + name);
        FileIO.INSTANCE.makePath("profiles/" + name + "/plugins");
        FileIO.INSTANCE.writeToFile("profiles/" + name + "/data.mms", false, data);
        FileIO.INSTANCE.writeToFile("profiles/" + name + "/eula.txt", false, "eula=true");
        String serverProps = Properties.INSTANCE.getServer() + "level-name=" + name;
        FileIO.INSTANCE.writeToFile("profiles/" + name + "/server.properties", false, serverProps);
        FileIO.INSTANCE.writeToFile("profiles/" + name + "/spigot.yml", false, Properties.INSTANCE.getSpigot());
        FileIO.INSTANCE.writeToFile("profiles/" + name + "/paper.yml", false, Properties.INSTANCE.getPaper());
        return name;
    }

    private final void setup() throws Exception {
        if (!Artifacts.INSTANCE.internetConnected()) {
            String string = "Internet required for setup. Please connect to the internet.";
            boolean bl = false;
            System.out.println((Object)string);
            throw (Throwable)new Exception();
        }
        String string = "Performing first time setup...\nMaking directories...";
        boolean bl = false;
        System.out.println((Object)string);
        FileIO.INSTANCE.makePath("artifacts");
        FileIO.INSTANCE.makePath("profiles");
        FileIO.INSTANCE.makePath("backups");
        FileIO.INSTANCE.makePath("14erEdit/Commands");
        FileIO.INSTANCE.makePath("14erEdit/ops");
        FileIO.INSTANCE.makePath("14erEdit/schematics");
        FileIO.INSTANCE.makePath("14erEdit/vars");
        FileIO.INSTANCE.makePath("14erEdit/templates");
        FileIO.INSTANCE.makePath("14erEdit/multibrushes");
        FileIO.INSTANCE.makePath("14erEdit/functions");
        FileIO.INSTANCE.makePath("14erEdit/undo");
        string = "Downloading artifacts (this could take a LONG time)...";
        bl = false;
        System.out.println((Object)string);
        Artifacts.INSTANCE.updateArtifacts();
        FileIO.INSTANCE.writeToFile("init.mms", false, "");
    }

    private final Process runProcess(String cmd, String dir) throws IOException {
        Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)cmd, new String[]{" "}, false, 0, 6, null);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        String[] cmdList = stringArray;
        ProcessBuilder pb = new ProcessBuilder(Arrays.copyOf(cmdList, cmdList.length));
        pb.directory(new File(dir));
        Process process = pb.inheritIO().start();
        Intrinsics.checkNotNullExpressionValue(process, "pb.inheritIO().start()");
        return process;
    }

    private final void clearConsole() {
        String string = "\u001b[H\u001b[2J";
        boolean bl = false;
        System.out.print((Object)string);
        System.out.flush();
        try {
            String string2 = System.getProperty("os.name");
            Intrinsics.checkNotNullExpressionValue(string2, "System.getProperty(\"os.name\")");
            if (StringsKt.contains$default((CharSequence)string2, "Windows", false, 2, null)) {
                new ProcessBuilder("cmd", "/c", "cls").inheritIO().start().waitFor();
            } else {
                Runtime.getRuntime().exec("clear");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private final void onError(Exception e) {
        try {
            String string = "Something went wrong. Restarting in 5 seconds...";
            boolean bl = false;
            System.out.println((Object)string);
            String out = StringsKt.trimIndent("\n                " + e.getMessage() + "\n                \n                ");
            e.printStackTrace();
            for (StackTraceElement ste : e.getStackTrace()) {
                out = out + StringsKt.trimIndent("\n                    " + ste + "\n                    \n                    ");
            }
            StringBuilder stringBuilder = new StringBuilder().append("error_");
            Instant instant = Instant.now();
            Intrinsics.checkNotNullExpressionValue(instant, "Instant.now()");
            FileIO.INSTANCE.writeToFile(stringBuilder.append(String.valueOf(instant.getEpochSecond())).append(".txt").toString(), false, out);
            Thread.sleep(5000L);
        }
        catch (Exception e1) {
            String string = "Error";
            boolean bl = false;
            System.out.println((Object)string);
        }
    }

    private Main() {
    }

    static {
        Main main;
        INSTANCE = main = new Main();
        javaPath = "java";
    }
}

