/*
 * Decompiled with CFR 0.152.
 */
package com._14ercooper.megaserver;

import com._14ercooper.megaserver.FileIO;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import java.util.List;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0002J\u001e\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0006H\u0002J\u0016\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0006J\u000e\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0006J\u001c\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u00132\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\nJ\u000e\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0006J\u000e\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0006J\u001e\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u0006J&\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020\u0006J(\u0010 \u001a\u00020\u00042\u0006\u0010!\u001a\u00020\u001c2\u0006\u0010\"\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u001e\u001a\u00020\u0006H\u0002\u00a8\u0006%"}, d2={"Lcom/_14ercooper/megaserver/FileIO;", "", "()V", "copyDirectory", "", "src", "", "dest", "copyFile", "folder", "", "delDirectory", "target", "deleteFile", "exists", "path", "getHash", "file", "listFiles", "", "folders", "makePath", "readFromFile", "writeToFile", "append", "text", "zipDirectory", "directoryToCompress", "Ljava/io/File;", "outputDirectory", "topFolderName", "outFile", "zipDirectoryHelper", "rootDirectory", "currentDirectory", "out", "Ljava/util/zip/ZipOutputStream;", "14erEdit"})
public final class FileIO {
    @NotNull
    public static final FileIO INSTANCE;

    public final void copyFile(@NotNull String src, @NotNull String dest, boolean folder) throws IOException {
        Intrinsics.checkNotNullParameter(src, "src");
        Intrinsics.checkNotNullParameter(dest, "dest");
        if (!folder) {
            Files.copy(Paths.get(src, new String[0]), Paths.get(dest, new String[0]), StandardCopyOption.REPLACE_EXISTING);
        } else {
            this.copyDirectory(src, dest);
        }
    }

    public final void deleteFile(@NotNull String src, boolean folder) throws IOException {
        Intrinsics.checkNotNullParameter(src, "src");
        if (!folder) {
            Files.deleteIfExists(Paths.get(src, new String[0]));
        } else {
            this.delDirectory(src);
        }
    }

    public final void makePath(@NotNull String path) {
        Intrinsics.checkNotNullParameter(path, "path");
        new File(path).mkdirs();
    }

    public final void zipDirectory(@NotNull File directoryToCompress, @NotNull File outputDirectory, @NotNull String topFolderName, @NotNull String outFile) throws InterruptedException {
        Intrinsics.checkNotNullParameter(directoryToCompress, "directoryToCompress");
        Intrinsics.checkNotNullParameter(outputDirectory, "outputDirectory");
        Intrinsics.checkNotNullParameter(topFolderName, "topFolderName");
        Intrinsics.checkNotNullParameter(outFile, "outFile");
        try {
            FileOutputStream dest = new FileOutputStream(new File(outputDirectory, outFile + ".zip"));
            ZipOutputStream zipOutputStream = new ZipOutputStream(dest);
            this.zipDirectoryHelper(directoryToCompress, directoryToCompress, zipOutputStream, topFolderName);
            zipOutputStream.close();
        }
        catch (Exception e) {
            String string = "Zip error";
            boolean bl = false;
            System.out.println((Object)string);
            Thread.sleep(2000L);
        }
    }

    @NotNull
    public final List<String> listFiles(@NotNull String path, boolean folders) {
        String[] directories2;
        Intrinsics.checkNotNullParameter(path, "path");
        if (!folders) {
            File f = new File(path);
            String[] stringArray = f.list();
            Intrinsics.checkNotNull(stringArray);
            return CollectionsKt.listOf(Arrays.copyOf(stringArray, stringArray.length));
        }
        File file = new File(path);
        String[] stringArray = directories2 = file.list(listFiles.directories.1.INSTANCE);
        Intrinsics.checkNotNull(directories2);
        return CollectionsKt.listOf(Arrays.copyOf(stringArray, stringArray.length));
    }

    @NotNull
    public final String readFromFile(@NotNull String file) throws IOException {
        String string;
        Intrinsics.checkNotNullParameter(file, "file");
        try {
            String string2 = Files.readString(Paths.get(file, new String[0]));
            Intrinsics.checkNotNullExpressionValue(string2, "Files.readString(Paths.get(file))");
            string = string2;
        }
        catch (NoSuchFileException e) {
            string = "";
        }
        return string;
    }

    public final boolean exists(@NotNull String path) {
        Intrinsics.checkNotNullParameter(path, "path");
        return new File(path).exists();
    }

    public final void writeToFile(@NotNull String file, boolean append, @NotNull String text) throws IOException {
        Intrinsics.checkNotNullParameter(file, "file");
        Intrinsics.checkNotNullParameter(text, "text");
        FileWriter fileWriter = new FileWriter(file, append);
        BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
        bufferedWriter.write(text);
        bufferedWriter.close();
        fileWriter.close();
    }

    private final void delDirectory(String target) throws IOException {
        Path directory = Paths.get(target, new String[0]);
        Files.walkFileTree(directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @NotNull
            public FileVisitResult visitFile(@NotNull Path file, @NotNull BasicFileAttributes attrs) throws IOException {
                Intrinsics.checkNotNullParameter(file, "file");
                Intrinsics.checkNotNullParameter(attrs, "attrs");
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @NotNull
            public FileVisitResult postVisitDirectory(@NotNull Path dir, @Nullable IOException exc) throws IOException {
                Intrinsics.checkNotNullParameter(dir, "dir");
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private final void zipDirectoryHelper(File rootDirectory, File currentDirectory, ZipOutputStream out, String topFolderName) throws Exception {
        byte[] data = new byte[2048];
        File[] files = currentDirectory.listFiles();
        if (files != null) {
            File[] fileArray = files;
            int n = fileArray.length;
            for (int i = 0; i < n; ++i) {
                File file;
                File file2 = file = fileArray[i];
                Intrinsics.checkNotNullExpressionValue(file2, "file");
                if (file2.isDirectory() && Intrinsics.areEqual(file.getName(), "") ^ true) {
                    this.zipDirectoryHelper(rootDirectory, file, out, topFolderName);
                    continue;
                }
                FileInputStream fi = new FileInputStream(file);
                String string = file.getAbsolutePath();
                Intrinsics.checkNotNullExpressionValue(string, "file.absolutePath");
                String string2 = rootDirectory.getAbsolutePath();
                Intrinsics.checkNotNullExpressionValue(string2, "rootDirectory.absolutePath");
                String name = StringsKt.replace$default(string, string2, topFolderName, false, 4, null);
                ZipEntry entry = new ZipEntry(name);
                out.putNextEntry(entry);
                int count2 = 0;
                BufferedInputStream origin = new BufferedInputStream(fi, 2048);
                while (true) {
                    int n2 = origin.read(data, 0, 2048);
                    boolean bl = false;
                    boolean bl2 = false;
                    int it = n2;
                    boolean bl3 = false;
                    count2 = it;
                    if (n2 == -1) break;
                    out.write(data, 0, count2);
                }
                origin.close();
            }
        }
    }

    private final void copyDirectory(String src, String dest) throws IOException {
        File source = new File(src);
        File destination = new File(dest);
        if (source.isDirectory()) {
            String[] files;
            if (!destination.exists()) {
                destination.mkdirs();
            }
            String[] stringArray = source.list();
            Intrinsics.checkNotNull(stringArray);
            for (String file : files = stringArray) {
                File srcFile = new File(source, file);
                File destFile = new File(destination, file);
                String string = srcFile.toString();
                Intrinsics.checkNotNullExpressionValue(string, "srcFile.toString()");
                String string2 = destFile.toString();
                Intrinsics.checkNotNullExpressionValue(string2, "destFile.toString()");
                this.copyDirectory(string, string2);
            }
        } else {
            InputStream in = null;
            OutputStream out = null;
            try {
                in = new FileInputStream(source);
                out = new FileOutputStream(destination);
                byte[] buffer = new byte[1024];
                int length = 0;
                while (true) {
                    int n = in.read(buffer);
                    boolean bl = false;
                    boolean bl2 = false;
                    int it = n;
                    boolean bl3 = false;
                    length = it;
                    if (n > 0) {
                        out.write(buffer, 0, length);
                        continue;
                    }
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            InputStream inputStream = in;
            Intrinsics.checkNotNull(inputStream);
            inputStream.close();
            OutputStream outputStream = out;
            Intrinsics.checkNotNull(outputStream);
            outputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final String getHash(@NotNull String file) {
        Intrinsics.checkNotNullParameter(file, "file");
        Closeable closeable = Files.newInputStream(Paths.get(file, new String[0]), new OpenOption[0]);
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            InputStream it = (InputStream)closeable;
            boolean bl3 = false;
            CRC32 crc = new CRC32();
            int c = 0;
            while (c != -1) {
                c = it.read();
                crc.update(c);
            }
            String string = Integer.toHexString((int)crc.getValue());
            Intrinsics.checkNotNullExpressionValue(string, "Integer.toHexString(crc.value.toInt())");
            String string2 = string;
            return string2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
    }

    private FileIO() {
    }

    static {
        FileIO fileIO;
        INSTANCE = fileIO = new FileIO();
    }
}

