/*
 * Decompiled with CFR 0.152.
 */
package com._14ercooper.math;

public class Point3 {
    private double x;
    private double y;
    private double z;

    public Point3(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Point3(Point3 original) {
        this.x = original.x;
        this.y = original.y;
        this.z = original.z;
    }

    public void normalize() {
        double invMag = 1.0 / this.magnitude();
        this.x *= invMag;
        this.y *= invMag;
        this.z *= invMag;
    }

    public double distance(Point3 other) {
        double xD = this.x - other.x;
        double yD = this.y - other.y;
        double zD = this.z - other.z;
        return Math.sqrt(xD * xD + yD * yD + zD * zD);
    }

    public double magnitude() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public Point3 add(Point3 other) {
        double xN = this.x + other.x;
        double yN = this.y + other.y;
        double zN = this.z + other.z;
        return new Point3(xN, yN, zN);
    }

    public Point3 sub(Point3 other) {
        double xN = this.x - other.x;
        double yN = this.y - other.y;
        double zN = this.z - other.z;
        return new Point3(xN, yN, zN);
    }

    public Point3 mult(double magnitude) {
        return new Point3(this.x * magnitude, this.y * magnitude, this.z * magnitude);
    }

    public double dot(Point3 other) {
        return this.x * other.x + this.y * other.y + this.z * other.z;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public String toString() {
        return "Point3{x=" + this.x + ", y=" + this.y + ", z=" + this.z + "}";
    }

    public static Point3 fromString(String string) {
        if (!string.startsWith("Point3")) {
            return null;
        }
        String minusStart = string.substring(7);
        String minusEnd = minusStart.substring(0, minusStart.length() - 1);
        String[] split = minusEnd.split(",");
        double x = Double.parseDouble(split[0].trim().substring(2));
        double y = Double.parseDouble(split[1].trim().substring(2));
        double z = Double.parseDouble(split[2].trim().substring(2));
        return new Point3(x, y, z);
    }
}

