/*
 * Decompiled with CFR 0.152.
 */
package me.loving11ish.speedlimit.updatesystem;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Scanner;
import java.util.logging.Logger;
import me.loving11ish.speedlimit.SpeedLimit;
import me.loving11ish.speedlimit.utils.ColorUtils;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Consumer;

public class UpdateChecker {
    private Plugin plugin;
    private int resourceId;
    FileConfiguration messagesFile;
    String PREFIX;
    final String PREFIX_PLACEHOLDER = "%PREFIX%";
    final String ERROR_PLACEHOLDER = "%ERROR%";
    Logger logger;

    public UpdateChecker(Plugin plugin, int resourceId) {
        this.messagesFile = SpeedLimit.getPlugin().messagesDataManager.getMessagesConfig();
        this.PREFIX = ColorUtils.translateColorCodes(this.messagesFile.getString("plugin-prefix"));
        this.PREFIX_PLACEHOLDER = "%PREFIX%";
        this.ERROR_PLACEHOLDER = "%ERROR%";
        this.logger = SpeedLimit.getPlugin().getLogger();
        this.plugin = plugin;
        this.resourceId = resourceId;
    }

    public void getVersion(Consumer<String> consumer) {
        Bukkit.getScheduler().runTaskAsynchronously(this.plugin, () -> {
            try (InputStream inputStream = new URL("https://api.spigotmc.org/legacy/update.php?resource=" + this.resourceId).openStream();
                 Scanner scanner = new Scanner(inputStream);){
                if (scanner.hasNext()) {
                    consumer.accept((Object)scanner.next());
                }
            }
            catch (IOException exception) {
                this.logger.warning(ColorUtils.translateColorCodes(this.messagesFile.getString("update-check-failure-1").replace("%PREFIX%", this.PREFIX).replace("%ERROR%", exception.getMessage())));
                this.logger.warning(ColorUtils.translateColorCodes(this.messagesFile.getString("update-check-failure-2").replace("%PREFIX%", this.PREFIX).replace("%ERROR%", exception.getMessage())));
                this.logger.warning(ColorUtils.translateColorCodes(this.messagesFile.getString("update-check-failure-3").replace("%PREFIX%", this.PREFIX).replace("%ERROR%", exception.getMessage())));
            }
        });
    }
}

