/*
 * Decompiled with CFR 0.152.
 */
package me.loving11ish.speedlimit.filemanager;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.logging.Logger;
import me.loving11ish.speedlimit.SpeedLimit;
import me.loving11ish.speedlimit.utils.ColorUtils;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class MessagesDataManager {
    private SpeedLimit plugin;
    private FileConfiguration dataConfig = null;
    private File configFile = null;
    Logger logger = SpeedLimit.getPlugin().getLogger();

    public void MessagesDataManager(SpeedLimit plugin) {
        this.plugin = plugin;
        this.saveDefaultMessagesConfig();
    }

    public void reloadMessagesConfig() {
        if (this.configFile == null) {
            this.configFile = new File(this.plugin.getDataFolder(), "messages.yml");
        }
        this.dataConfig = YamlConfiguration.loadConfiguration((File)this.configFile);
        InputStream defaultStream = this.plugin.getResource("messages.yml");
        if (defaultStream != null) {
            YamlConfiguration defaultConfig = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(defaultStream));
            this.dataConfig.setDefaults((Configuration)defaultConfig);
        }
    }

    public FileConfiguration getMessagesConfig() {
        if (this.dataConfig == null) {
            this.reloadMessagesConfig();
        }
        return this.dataConfig;
    }

    public void saveMessagesConfig() {
        if (this.dataConfig == null || this.configFile == null) {
            return;
        }
        try {
            this.getMessagesConfig().save(this.configFile);
        }
        catch (IOException e) {
            this.logger.severe(ColorUtils.translateColorCodes("&7[&6Speed&3Limit&7] - &4Could not save messages.yml"));
            this.logger.severe(ColorUtils.translateColorCodes("&7[&6Speed&3Limit&7] - &4Check the below message for the reasons!"));
            e.printStackTrace();
        }
    }

    public void saveDefaultMessagesConfig() {
        if (this.configFile == null) {
            this.configFile = new File(this.plugin.getDataFolder(), "messages.yml");
        }
        if (!this.configFile.exists()) {
            this.plugin.saveResource("messages.yml", false);
        }
    }
}

