/*
 * Decompiled with CFR 0.152.
 */
package me.loving11ish.speedlimit.events;

import me.loving11ish.speedlimit.SpeedLimit;
import me.loving11ish.speedlimit.utils.ColorUtils;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.plugin.Plugin;

public class ElytraFlightEvent
implements Listener {
    public static Integer taskID1;
    private static double velocityTriggerMultiplier;
    FileConfiguration configFile = SpeedLimit.getPlugin().getConfig();
    FileConfiguration messagesFile;
    String PREFIX;
    final String PREFIX_PLACEHOLDER = "%PREFIX%";

    public ElytraFlightEvent() {
        this.messagesFile = SpeedLimit.getPlugin().messagesDataManager.getMessagesConfig();
        this.PREFIX = this.messagesFile.getString("plugin-prefix");
        this.PREFIX_PLACEHOLDER = "%PREFIX%";
    }

    public static void updateElytraTriggerValue() {
        taskID1 = Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)SpeedLimit.getPlugin(), new Runnable(){

            @Override
            public void run() {
                velocityTriggerMultiplier = SpeedLimit.getPlugin().getConfig().getDouble("elytra-flight-event.speed-limit.trigger-speed");
            }
        }, 10L);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onElytraFlight(PlayerMoveEvent event) {
        Player player = event.getPlayer();
        double x = event.getFrom().getX();
        double y = event.getFrom().getY();
        double z = event.getFrom().getZ();
        float yaw = event.getFrom().getYaw();
        float pitch = event.getFrom().getPitch();
        if (this.configFile.getBoolean("elytra-flight-event.disable-all-elytra-flight")) {
            if (player.isGliding()) {
                Location location = new Location(player.getWorld(), x, y + 1.0, z, yaw, pitch);
                player.setGliding(false);
                player.teleport(location);
                player.sendMessage(ColorUtils.translateColorCodes(this.messagesFile.getString("elytras-disabled-warning").replace("%PREFIX%", this.PREFIX)));
            }
            return;
        }
        if (!this.configFile.getBoolean("elytra-flight-event.speed-limit.enabled")) {
            return;
        }
        if (this.configFile.getList("disabled-Worlds").contains(player.getWorld().getName())) {
            return;
        }
        if (player.hasPermission("SpeedLimit.bypass.elytra") || player.hasPermission("SpeedLimit.bypass") || player.hasPermission("SpeedLimit.*") || player.isOp()) {
            return;
        }
        if (player.isGliding() && (Math.abs(event.getFrom().getX() - event.getTo().getX()) > velocityTriggerMultiplier || Math.abs(event.getFrom().getY() - event.getTo().getY()) > velocityTriggerMultiplier || Math.abs(event.getFrom().getZ() - event.getTo().getZ()) > velocityTriggerMultiplier)) {
            Location oldLocation = new Location(player.getWorld(), x, y + 1.0, z, yaw, pitch);
            if (this.configFile.getBoolean("elytra-flight-event.speed-limit.cancel-event")) {
                event.setCancelled(true);
            } else {
                player.teleport(oldLocation);
            }
            if (this.configFile.getBoolean("elytra-flight-event.speed-limit.send-message")) {
                player.sendMessage(ColorUtils.translateColorCodes(this.messagesFile.getString("elytra-triggered-warning").replace("%PREFIX%", this.PREFIX)));
            }
        }
    }
}

