/*
 * Decompiled with CFR 0.152.
 */
package me.loving11ish.speedlimit;

import java.util.logging.Logger;
import me.loving11ish.speedlimit.commands.SLHelp;
import me.loving11ish.speedlimit.commands.SLReload;
import me.loving11ish.speedlimit.events.ElytraFlightEvent;
import me.loving11ish.speedlimit.events.ElytraTPSFlightEvent;
import me.loving11ish.speedlimit.events.FlightEvent;
import me.loving11ish.speedlimit.events.PlayerWalkEvent;
import me.loving11ish.speedlimit.filemanager.MessagesDataManager;
import me.loving11ish.speedlimit.tasks.TPSCheckTasks;
import me.loving11ish.speedlimit.updatesystem.JoinEvent;
import me.loving11ish.speedlimit.updatesystem.UpdateChecker;
import me.loving11ish.speedlimit.utils.ColorUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.util.Consumer;

public final class SpeedLimit
extends JavaPlugin {
    private final PluginDescriptionFile pluginInfo = this.getDescription();
    private final String pluginVersion = this.pluginInfo.getVersion();
    private static SpeedLimit plugin;
    public MessagesDataManager messagesDataManager;
    private static Double serverTPS;
    private final String PREFIX_PLACEHOLDER = "%PREFIX%";
    Logger logger = this.getLogger();

    public void onEnable() {
        plugin = this;
        if (!(Bukkit.getServer().getVersion().contains("1.13") || Bukkit.getServer().getVersion().contains("1.14") || Bukkit.getServer().getVersion().contains("1.15") || Bukkit.getServer().getVersion().contains("1.16") || Bukkit.getServer().getVersion().contains("1.17") || Bukkit.getServer().getVersion().contains("1.18") || Bukkit.getServer().getVersion().contains("1.19"))) {
            this.logger.warning(ChatColor.RED + "-------------------------------------------");
            this.logger.warning(ChatColor.RED + "SpeedLimit - This plugin is only supported on the Minecraft versions listed below:");
            this.logger.warning(ChatColor.RED + "SpeedLimit - 1.13.x");
            this.logger.warning(ChatColor.RED + "SpeedLimit - 1.14.x");
            this.logger.warning(ChatColor.RED + "SpeedLimit - 1.15.x");
            this.logger.warning(ChatColor.RED + "SpeedLimit - 1.16.x");
            this.logger.warning(ChatColor.RED + "SpeedLimit - 1.17.x");
            this.logger.warning(ChatColor.RED + "SpeedLimit - 1.18.x");
            this.logger.warning(ChatColor.RED + "SpeedLimit - 1.19.x");
            this.logger.warning(ChatColor.RED + "SpeedLimit - Is now disabling!");
            this.logger.warning(ChatColor.RED + "-------------------------------------------");
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
        } else {
            this.logger.info(ChatColor.GREEN + "-------------------------------------------");
            this.logger.info(ChatColor.GREEN + "SpeedLimit - A supported Minecraft version has been detected");
            this.logger.info(ChatColor.GREEN + "SpeedLimit - Continuing plugin startup");
            this.logger.info(ChatColor.GREEN + "-------------------------------------------");
        }
        this.getConfig().options().copyDefaults();
        this.saveDefaultConfig();
        this.messagesDataManager = new MessagesDataManager();
        this.messagesDataManager.MessagesDataManager(this);
        this.getCommand("slhelp").setExecutor((CommandExecutor)new SLHelp());
        this.getCommand("slreload").setExecutor((CommandExecutor)new SLReload());
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerWalkEvent(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new FlightEvent(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new ElytraFlightEvent(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new ElytraTPSFlightEvent(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new JoinEvent(), (Plugin)this);
        ElytraFlightEvent.updateElytraTriggerValue();
        TPSCheckTasks tpsCheckTasks = new TPSCheckTasks();
        tpsCheckTasks.checkTPSOne();
        this.logger.info("-------------------------------------------");
        this.logger.info(ColorUtils.translateColorCodes("&7[&bSpeed&3Limit&7] &bPlugin by Loving11ish"));
        this.logger.info(ColorUtils.translateColorCodes("&7[&bSpeed&3Limit&7] &bPlugin successfully enabled!"));
        this.logger.info(ColorUtils.translateColorCodes("&7[&bSpeed&3Limit&7] &bPlugin Version &d" + this.pluginVersion));
        this.logger.info("-------------------------------------------");
        String PREFIX = this.messagesDataManager.getMessagesConfig().getString("plugin-prefix");
        new UpdateChecker((Plugin)this, 75269).getVersion((Consumer<String>)((Consumer)version -> {
            if (this.getDescription().getVersion().equalsIgnoreCase((String)version)) {
                this.logger.info(ColorUtils.translateColorCodes(this.messagesDataManager.getMessagesConfig().getString("plugin-no-update-1").replace("%PREFIX%", PREFIX)));
                this.logger.info(ColorUtils.translateColorCodes(this.messagesDataManager.getMessagesConfig().getString("plugin-no-update-2").replace("%PREFIX%", PREFIX)));
                this.logger.info(ColorUtils.translateColorCodes(this.messagesDataManager.getMessagesConfig().getString("plugin-no-update-3").replace("%PREFIX%", PREFIX)));
            } else {
                this.logger.info(ColorUtils.translateColorCodes(this.messagesDataManager.getMessagesConfig().getString("plugin-update-available-1").replace("%PREFIX%", PREFIX)));
                this.logger.info(ColorUtils.translateColorCodes(this.messagesDataManager.getMessagesConfig().getString("plugin-update-available-2").replace("%PREFIX%", PREFIX)));
                this.logger.info(ColorUtils.translateColorCodes(this.messagesDataManager.getMessagesConfig().getString("plugin-update-available-3").replace("%PREFIX%", PREFIX)));
            }
        }));
    }

    public void onDisable() {
        this.logger.info("-------------------------------------------");
        this.logger.info(ColorUtils.translateColorCodes("&7[&bSpeed&3Limit&7] &bPlugin by Loving11ish"));
        this.logger.info(ColorUtils.translateColorCodes("&7[&bSpeed&3Limit&7] &bPlugin Version &d" + this.pluginVersion));
        try {
            if (Bukkit.getScheduler().isCurrentlyRunning(ElytraFlightEvent.taskID1.intValue()) || Bukkit.getScheduler().isQueued(ElytraFlightEvent.taskID1.intValue())) {
                Bukkit.getScheduler().cancelTask(ElytraFlightEvent.taskID1.intValue());
            }
            if (Bukkit.getScheduler().isCurrentlyRunning(TPSCheckTasks.taskID2.intValue()) || Bukkit.getScheduler().isQueued(TPSCheckTasks.taskID2.intValue())) {
                Bukkit.getScheduler().cancelTask(TPSCheckTasks.taskID2.intValue());
            }
            if (Bukkit.getScheduler().isCurrentlyRunning(TPSCheckTasks.taskID3.intValue()) || Bukkit.getScheduler().isQueued(TPSCheckTasks.taskID3.intValue())) {
                Bukkit.getScheduler().cancelTask(TPSCheckTasks.taskID3.intValue());
            }
            this.logger.info(ColorUtils.translateColorCodes("&7[&bSpeed&3Limit&7] &bAll background tasks disabled successfully!"));
        }
        catch (Exception e) {
            this.logger.info(ColorUtils.translateColorCodes("&7[&bSpeed&3Limit&7] &bAll background tasks disabled successfully!"));
        }
        this.logger.info(ColorUtils.translateColorCodes("&7[&bSpeed&3Limit&7] &bPlugin shutdown successfully!"));
        this.logger.info("-------------------------------------------");
    }

    public static SpeedLimit getPlugin() {
        return plugin;
    }

    public static Double getServerTPS() {
        return serverTPS;
    }

    public static void setServerTPS(Double serverTPS) {
        SpeedLimit.serverTPS = serverTPS;
    }

    static {
        serverTPS = 20.0;
    }
}

