/*
 * Decompiled with CFR 0.152.
 */
package fr.k0bus.k0buslib.utils;

import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;

public class Math {
    private static final NavigableMap<Long, String> suffixes = new TreeMap<Long, String>();
    private static final NavigableMap<Double, String> suffixes_d;

    public static boolean isInteger(String s) {
        try {
            Integer.parseInt(s);
        }
        catch (NullPointerException | NumberFormatException e) {
            return false;
        }
        return true;
    }

    public static boolean isDouble(String s) {
        try {
            Double.parseDouble(s);
        }
        catch (NullPointerException | NumberFormatException e) {
            return false;
        }
        return true;
    }

    public static String simplify(long value) {
        if (value == Long.MIN_VALUE) {
            return Math.simplify(-9223372036854775807L);
        }
        if (value < 0L) {
            return "-" + Math.simplify(-value);
        }
        if (value < 1000L) {
            return Long.toString(value);
        }
        Map.Entry<Long, String> e = suffixes.floorEntry(value);
        Long divideBy = e.getKey();
        String suffix = e.getValue();
        long truncated = value / (divideBy / 10L);
        boolean hasDecimal = truncated < 100L && (double)truncated / 10.0 != (double)(truncated / 10L);
        double finalValue = hasDecimal ? (double)truncated / 10.0 : (double)(truncated / 10L);
        finalValue = (double)java.lang.Math.round(finalValue * 100.0) / 100.0;
        return finalValue + suffix;
    }

    public static String simplify(double value) {
        if (value == -9.223372036854776E18) {
            return Math.simplify(-9223372036854775807L);
        }
        if (value < 0.0) {
            return "-" + Math.simplify(-value);
        }
        if (value < 1000.0) {
            return Double.toString(value);
        }
        Map.Entry<Double, String> e = suffixes_d.floorEntry(value);
        Double divideBy = e.getKey();
        String suffix = e.getValue();
        double truncated = value / (divideBy / 10.0);
        boolean hasDecimal = truncated < 100.0 && truncated / 10.0 != truncated / 10.0;
        double finalValue = hasDecimal ? truncated / 10.0 : truncated / 10.0;
        finalValue = (double)java.lang.Math.round(finalValue * 100.0) / 100.0;
        return finalValue + suffix;
    }

    static {
        suffixes.put(1000L, "k");
        suffixes.put(1000000L, "M");
        suffixes.put(1000000000L, "G");
        suffixes.put(1000000000000L, "T");
        suffixes.put(1000000000000000L, "P");
        suffixes.put(1000000000000000000L, "E");
        suffixes_d = new TreeMap<Double, String>();
        suffixes_d.put(1000.0, "k");
        suffixes_d.put(1000000.0, "M");
        suffixes_d.put(1.0E9, "G");
        suffixes_d.put(1.0E12, "T");
        suffixes_d.put(1.0E15, "P");
        suffixes_d.put(1.0E18, "E");
    }
}

