/*
 * Decompiled with CFR 0.152.
 */
package fr.k0bus.k0buslib.updater;

import fr.k0bus.k0buslib.updater.VersionType;
import fr.k0bus.k0buslib.utils.Math;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class Version
implements Comparable<Version>,
Serializable {
    List<Integer> num = new ArrayList<Integer>();
    VersionType type;
    String version;

    public Version(String version) {
        String[] args;
        this.version = version;
        for (VersionType vType : VersionType.values()) {
            String v = version.toLowerCase();
            if (!v.contains(vType.getName())) continue;
            this.type = vType;
            break;
        }
        if (this.type == null) {
            this.type = VersionType.RELEASE;
        }
        version = version.replaceAll("[^\\d.]", "");
        for (String v : args = version.split("\\.")) {
            if (!Math.isInteger(v)) continue;
            this.num.add(Integer.parseInt(v));
        }
    }

    public String toString() {
        return this.version;
    }

    @Override
    public int compareTo(Version toCompare) {
        if (toCompare == null) {
            return 1;
        }
        int i = 0;
        for (int n : this.num) {
            int compare;
            if (n > (compare = toCompare.num.get(i).intValue())) {
                return 1;
            }
            if (n < compare) {
                return -1;
            }
            ++i;
        }
        if (this.type.level < toCompare.type.level) {
            return -1;
        }
        if (this.type.level > toCompare.type.level) {
            return 1;
        }
        return 0;
    }
}

