/*
 * Decompiled with CFR 0.152.
 */
package fr.k0bus.k0buslib.updater;

import fr.k0bus.k0buslib.updater.Version;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Scanner;
import org.bukkit.plugin.java.JavaPlugin;

public class UpdateChecker {
    private final JavaPlugin plugin;
    private final Version version;
    private final Version spigotVersion;
    private final int resourceId;

    public UpdateChecker(JavaPlugin plugin, int resourceId) {
        this.plugin = plugin;
        this.version = new Version(this.plugin.getDescription().getVersion());
        this.resourceId = resourceId;
        this.spigotVersion = this.getVersion();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Version getVersion() {
        try (InputStream inputStream = new URL("https://api.spigotmc.org/legacy/update.php?resource=" + this.resourceId).openStream();
             Scanner scanner = new Scanner(inputStream);){
            if (!scanner.hasNext()) return null;
            Version version = new Version(scanner.next());
            return version;
        }
        catch (IOException exception) {
            this.plugin.getLogger().info("Cannot look for updates: " + exception.getMessage());
        }
        return null;
    }

    public boolean isUpToDate() {
        return this.spigotVersion.compareTo(this.version) < 0;
    }

    public boolean isStable() {
        return this.version.type.isStable();
    }
}

