/*
 * Decompiled with CFR 0.152.
 */
package fr.k0bus.k0buslib.settings;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.apache.commons.lang.Validate;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class Configuration {
    JavaPlugin plugin;
    File file;
    FileConfiguration configuration;
    String filename;

    public Configuration(String filename, JavaPlugin instance) {
        this.plugin = instance;
        this.filename = filename;
        this.file = new File(instance.getDataFolder(), filename);
        this.loadConfig();
    }

    public Configuration(String filename, JavaPlugin instance, String dirName) {
        this.plugin = instance;
        this.filename = filename;
        File dir = new File(this.plugin.getDataFolder(), dirName);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        this.file = dir.isDirectory() ? new File(dir, filename) : new File(dir.getParentFile(), filename);
        this.loadConfig();
    }

    public void loadConfig() {
        if (this.plugin.getResource(this.filename) != null) {
            if (!this.file.exists()) {
                this.plugin.saveResource(this.filename, false);
            } else {
                this.file.mkdirs();
                try {
                    this.file.createNewFile();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        if (this.file.exists()) {
            try {
                this.configuration = Configuration.loadConfiguration(this.file);
            }
            catch (InvalidConfigurationException e) {
                this.plugin.getLogger().log(Level.SEVERE, this.filename + " can't be loaded ! Check file syntax first !");
                this.plugin.getLogger().log(Level.SEVERE, e.getMessage());
                File renamed = new File(this.file.getParentFile(), this.filename + ".old");
                if (renamed.exists()) {
                    renamed.delete();
                }
                this.file.renameTo(renamed);
                this.loadConfig();
            }
            catch (IOException ex) {
                this.plugin.getLogger().log(Level.SEVERE, "Can't read file " + this.filename);
                this.configuration = new YamlConfiguration();
            }
        } else {
            this.configuration = new YamlConfiguration();
        }
    }

    private static YamlConfiguration loadConfiguration(File file) throws IOException, InvalidConfigurationException {
        Validate.notNull((Object)file, (String)"File cannot be null");
        YamlConfiguration config = new YamlConfiguration();
        try {
            config.load(file);
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (InvalidConfigurationException ex) {
            throw ex;
        }
        return config;
    }

    public void save() {
        try {
            this.configuration.save(this.file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getString(String path) {
        return this.configuration.getString(path);
    }

    public boolean getBoolean(String path) {
        return this.configuration.getBoolean(path);
    }

    public int getInt(String path) {
        return this.configuration.getInt(path);
    }

    public double getDouble(String path) {
        return this.configuration.getDouble(path);
    }

    public ConfigurationSection getConfigurationSection(String path) {
        return this.configuration.getConfigurationSection(path);
    }

    public boolean contains(String path) {
        return this.configuration.contains(path);
    }

    public boolean isString(String path) {
        return this.configuration.isString(path);
    }

    public Set<String> getKeys(boolean deep) {
        return this.configuration.getKeys(deep);
    }

    public Set<String> getKeysFromPath(String path, boolean deep) {
        return this.configuration.getConfigurationSection(path).getKeys(deep);
    }

    public List<String> getStringList(String path) {
        return this.configuration.getStringList(path);
    }

    public File getFile() {
        return this.file;
    }

    public void set(String path, Object o) {
        this.configuration.set(path, o);
        try {
            this.configuration.save(this.file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void updateConfig(String cfg, JavaPlugin plugin) {
        File file = new File(plugin.getDataFolder(), cfg);
        file.getParentFile().mkdirs();
        if (!file.exists()) {
            plugin.saveResource(cfg, false);
        }
        YamlConfiguration default_conf = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(plugin.getResource(cfg)));
        YamlConfiguration conf = null;
        try {
            conf = Configuration.loadConfiguration(file);
        }
        catch (InvalidConfigurationException e) {
            plugin.getLogger().log(Level.SEVERE, cfg + " can't be loaded ! Check file syntax first !");
            plugin.getLogger().log(Level.SEVERE, e.getMessage());
            File renamed = new File(file.getParentFile(), cfg + ".old");
            if (renamed.exists()) {
                renamed.delete();
            }
            file.renameTo(renamed);
            return;
        }
        catch (IOException ex) {
            plugin.getLogger().log(Level.SEVERE, "Can't read file " + cfg);
        }
        for (String path : default_conf.getKeys(true)) {
            if (conf.contains(path) && conf.get(path).getClass().getName() == default_conf.get(path).getClass().getName()) continue;
            plugin.getLogger().log(Level.WARNING, path + " added to " + cfg);
            conf.set(path, default_conf.get(path));
        }
        for (String path : conf.getKeys(true)) {
            if (default_conf.contains(path) && conf.get(path).getClass().getName() == default_conf.get(path).getClass().getName()) continue;
            plugin.getLogger().log(Level.WARNING, path + " removed to " + cfg);
            conf.set(path, null);
        }
        try {
            conf.save(file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public FileConfiguration getConfiguration() {
        return this.configuration;
    }
}

