/*
 * Decompiled with CFR 0.152.
 */
package com.betafase.mcmanager.web;

import com.betafase.mcmanager.MCManager;
import com.betafase.mcmanager.web.DownloadHandler;
import com.betafase.mcmanager.web.UploadHandler;
import com.sun.net.httpserver.BasicAuthenticator;
import com.sun.net.httpserver.HttpContext;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.configuration.ConfigurationSection;

public class WebServer {
    private HttpServer server;
    private int port;
    private EasyAuth auth;

    public int getPort() {
        return this.port;
    }

    public boolean isOnline() {
        return this.server != null;
    }

    public static Map<String, String> getQueryMap(String query) throws UnsupportedEncodingException {
        HashMap<String, String> map = new HashMap<String, String>();
        if (query != null && !query.isEmpty()) {
            String[] params;
            for (String param : params = query.split("&")) {
                String name = param.split("=")[0];
                String value = param.split("=")[1];
                map.put(name, URLDecoder.decode(value, "UTF-8"));
            }
        }
        return map;
    }

    public void start(int port) {
        if (this.server != null) {
            this.stop();
        }
        try {
            this.auth = new EasyAuth("Please log in to use this service");
            this.port = port;
            this.server = HttpServer.create(new InetSocketAddress(port), 0);
            HttpContext download = this.server.createContext("/download");
            HttpContext upload = this.server.createContext("/upload");
            upload.setHandler(new UploadHandler());
            upload.setAuthenticator(this.auth);
            download.setHandler(new DownloadHandler());
            download.setAuthenticator(this.auth);
            this.server.start();
        }
        catch (Exception ex) {
            Logger.getLogger(WebServer.class.getName()).log(Level.WARNING, "Failed to start WebServer", ex);
        }
    }

    public void stop() {
        if (this.server != null) {
            this.server.stop(0);
            this.server = null;
        }
    }

    public HttpContext addProtectedContext(String context, HttpHandler handler) {
        HttpContext http = this.server.createContext(context);
        http.setAuthenticator(this.auth);
        http.setHandler(handler);
        return http;
    }

    private class EasyAuth
    extends BasicAuthenticator {
        public EasyAuth(String string) {
            super(string);
        }

        @Override
        public boolean checkCredentials(String string, String string1) {
            if (MCManager.getInstance().getConfig().isConfigurationSection("webserver.accounts")) {
                ConfigurationSection users = MCManager.getInstance().getConfig().getConfigurationSection("webserver.accounts");
                return users.contains(string) && users.getString(string).equals(string1);
            }
            return true;
        }
    }
}

