/*
 * Decompiled with CFR 0.152.
 */
package com.betafase.mcmanager.web;

import com.betafase.mcmanager.MCManager;
import com.betafase.mcmanager.api.ExecutableMenuItem;
import com.betafase.mcmanager.api.GUIUtils;
import com.betafase.mcmanager.api.Menu;
import com.betafase.mcmanager.api.MenuItem;
import com.betafase.mcmanager.api.SignInputHandler;
import com.betafase.mcmanager.api.SimpleExecutableMenuItem;
import com.betafase.mcmanager.api.SimpleMenu;
import com.betafase.mcmanager.gui.plugin.PluginMenu;
import com.betafase.mcmanager.utils.Text;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.plugin.Plugin;

public class WebManager
implements ExecutableMenuItem {
    @Override
    public MenuItem getDisplayItem(String lang) {
        return new MenuItem(Material.EMERALD, "\u00a77\u00a7lWebServer");
    }

    @Override
    public void onClick(InventoryClickEvent e) {
        Player p = (Player)e.getWhoClicked();
        new WebMenu(Text.getLanguage(p)).open(p);
    }

    private class AccountsMenu
    extends Menu {
        private int page;
        ConfigurationSection section;

        public AccountsMenu(String lang, int page) {
            super("\u00a77Manage Accounts", 27, lang);
            this.section = MCManager.getConfiguration().getConfigurationSection("webserver.accounts");
            this.page = page;
            if (page > 0) {
                this.setItem(21, GUIUtils.previous_pageOld(lang, page));
            }
            int counter = -page * 18;
            this.setItem(22, GUIUtils.backOld(lang));
            Map values = this.section.getValues(false);
            for (Map.Entry e : values.entrySet()) {
                if (counter >= 0) {
                    if (counter == 18) {
                        this.setItem(23, GUIUtils.next_pageOld(lang, page + 2));
                        break;
                    }
                    MenuItem account = new MenuItem(Material.NAME_TAG, "\u00a77\u00a7l" + (String)e.getKey(), "\u00a78Password: \u00a7e" + e.getValue(), "", "\u00a7a\u00bb Click to delete");
                    this.setItem(counter, account);
                }
                ++counter;
            }
            if (counter >= 0 && counter < 18) {
                MenuItem add = new MenuItem(Material.STAINED_CLAY, 1, 5, "\u00a7a\u00a7lAdd...", "\u00a78First Line: username, Second Line: password");
                this.setItem(counter, add);
            }
        }

        @Override
        public void onClick(InventoryClickEvent e) {
            final Player p = (Player)e.getWhoClicked();
            if (e.getSlot() < 18) {
                if (e.getCurrentItem().getType() == Material.NAME_TAG) {
                    String key = ChatColor.stripColor((String)e.getCurrentItem().getItemMeta().getDisplayName());
                    this.section.set(key, null);
                    MCManager.saveConfiguration();
                    new AccountsMenu(this.lang, this.page).open(p);
                } else if (e.getCurrentItem().getType() == Material.STAINED_CLAY) {
                    e.getView().close();
                    if (!MCManager.requestInput(p, new SignInputHandler(){

                        @Override
                        public void handleTextInput(String[] lines) {
                            if (lines[0].isEmpty() || lines[1].isEmpty()) {
                                p.sendMessage("\u00a7cYou didn't enter a text. If you do this again, the plugin will explode.");
                                return;
                            }
                            String user = lines[0];
                            if (AccountsMenu.this.section.contains(user)) {
                                p.sendMessage("\u00a7cOoops. It looks like the user you are trying to create already exists. Time travelling is dangerous.");
                                return;
                            }
                            AccountsMenu.this.section.set(user, (Object)lines[1]);
                            if (!lines[2].isEmpty() || !lines[3].isEmpty()) {
                                p.sendMessage("\u00a7eWhy did you enter text here? Suspicious.");
                            }
                            new AccountsMenu(AccountsMenu.this.lang, AccountsMenu.this.page).open(p);
                        }

                        @Override
                        public String[] getDefault() {
                            return new String[]{"<username>", "<password>", "", ""};
                        }
                    })) {
                        p.sendMessage("\u00a7cThis would normally open a Sign GUI. It seems like you don't have ProtocolLib installed. If you don't wish to install it, you can edit the accounts in the config, aswell.");
                    }
                }
            } else {
                switch (e.getSlot()) {
                    case 22: {
                        new WebMenu(this.lang).open(p);
                        break;
                    }
                    case 21: {
                        if (e.getCurrentItem().getType() != Material.STICK) break;
                        new AccountsMenu(this.lang, this.page - 1).open(p);
                        break;
                    }
                    case 23: {
                        if (e.getCurrentItem().getType() != Material.STICK) break;
                        new AccountsMenu(this.lang, this.page + 1).open(p);
                    }
                }
            }
        }
    }

    private class WebMenu
    extends SimpleMenu {
        public WebMenu(final String lang) {
            super("\u00a79WebServer", 9, lang);
            this.setItem(1, new ExecutableMenuItem(){

                @Override
                public void onClick(InventoryClickEvent e) {
                }

                @Override
                public MenuItem getDisplayItem(String lang) {
                    return new MenuItem(Material.EMERALD, "\u00a77\u00a7lWebServer", "\u00a78Status: " + (MCManager.getWebServer().isOnline() ? "\u00a7aONLINE" : "\u00a7cOFFLINE"));
                }
            });
            this.setItem(3, new ExecutableMenuItem(){

                @Override
                public void onClick(InventoryClickEvent e) {
                    Player p = (Player)e.getWhoClicked();
                    if (MCManager.getWebServer().isOnline()) {
                        MCManager.getWebServer().stop();
                    } else {
                        MCManager.getWebServer().start(MCManager.getConfiguration().getInt("webserver.port", 8282));
                    }
                    new WebMenu(lang).open(p);
                }

                @Override
                public MenuItem getDisplayItem(String lang2) {
                    if (MCManager.getWebServer().isOnline()) {
                        return new MenuItem(Material.STAINED_CLAY, 1, 6, "\u00a7c\u00a7lStop");
                    }
                    return new MenuItem(Material.STAINED_CLAY, 1, 5, "\u00a7a\u00a7lStart");
                }
            });
            this.setItem(4, new ExecutableMenuItem(){

                @Override
                public void onClick(InventoryClickEvent e) {
                    Player p = (Player)e.getWhoClicked();
                    new AccountsMenu(Text.getLanguage(p), 0).open(p);
                }

                @Override
                public MenuItem getDisplayItem(String lang) {
                    return new MenuItem(Material.NAME_TAG, "\u00a77\u00a7lAccounts");
                }
            });
            this.setItem(8, new SimpleExecutableMenuItem(GUIUtils.backOld(lang)){

                @Override
                public void onClick(InventoryClickEvent e) {
                    new PluginMenu((Plugin)MCManager.getInstance(), lang).open((Player)e.getWhoClicked());
                }
            });
        }
    }
}

