/*
 * Decompiled with CFR 0.152.
 */
package com.betafase.mcmanager.web;

import com.betafase.mcmanager.security.ModuleManager;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.RequestContext;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;

public class UploadHandler
implements HttpHandler {
    @Override
    public void handle(final HttpExchange t) throws IOException {
        String alert = "";
        if (t.getRequestMethod().equalsIgnoreCase("POST")) {
            DiskFileItemFactory d = new DiskFileItemFactory();
            try {
                if (!ModuleManager.isValid("file.upload")) {
                    throw new SecurityException("Module is not enabled!");
                }
                ServletFileUpload up = new ServletFileUpload(d);
                List<FileItem> result = up.parseRequest(new RequestContext(){

                    @Override
                    public String getCharacterEncoding() {
                        return "UTF-8";
                    }

                    @Override
                    public int getContentLength() {
                        return 0;
                    }

                    @Override
                    public String getContentType() {
                        return t.getRequestHeaders().getFirst("Content-type");
                    }

                    @Override
                    public InputStream getInputStream() throws IOException {
                        return t.getRequestBody();
                    }
                });
                String dest = "";
                FileItem file = null;
                for (FileItem fi : result) {
                    try {
                        if (fi.isFormField()) {
                            if (!fi.getFieldName().equalsIgnoreCase("destination")) continue;
                            dest = fi.getString("UTF-8");
                            continue;
                        }
                        file = fi;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                if (file == null || file.getSize() > 0xA00000L) {
                    alert = "<div class=\"alert alert-danger alert-dismissable fade in\">\n<a href=\"#\" class=\"close\" data-dismiss=\"alert\" aria-label=\"close\">&times;</a>\n  <strong>Error!</strong> The File you are trying to upload is too large.\n</div>";
                    if (file != null) {
                        file.delete();
                    }
                } else {
                    File dir = dest == null || dest.isEmpty() ? new File(System.getProperty("user.dir")) : new File(dest);
                    File f = new File(dir, file.getName());
                    if (ModuleManager.isFileEnabled(null, f)) {
                        if (!dir.exists()) {
                            dir.mkdirs();
                        }
                        file.write(f);
                        alert = "<div class=\"alert alert-success alert-dismissable fade in\">\n<a href=\"#\" class=\"close\" data-dismiss=\"alert\" aria-label=\"close\">&times;</a>\n  <strong>Upload complete!</strong> Saved as " + f.getPath() + "\n</div>";
                    } else {
                        alert = "<div class=\"alert alert-danger alert-dismissable fade in\">\n<a href=\"#\" class=\"close\" data-dismiss=\"alert\" aria-label=\"close\">&times;</a>\n  <strong>Error!</strong> Access to this file has been denied.\n</div>";
                    }
                }
            }
            catch (Exception e) {
                alert = "<div class=\"alert alert-danger alert-dismissable fade in\">\n<a href=\"#\" class=\"close\" data-dismiss=\"alert\" aria-label=\"close\">&times;</a>\n  <strong>Error!</strong> A " + e.getClass().getSimpleName() + " occured. Check log for details.\n</div>";
                e.printStackTrace();
            }
        }
        OutputStream os = t.getResponseBody();
        String html = "<!DOCTYPE html>\n<html lang=\"en\">\n    <head>\n        <title>File Upload | MCManager</title>\n        <meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">\n        <meta name=\"viewport\" content=\"width=device-width, initial-scale=1\">\n        <link rel=\"stylesheet\" href=\"https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/css/bootstrap.min.css\" integrity=\"sha384-BVYiiSIFeK1dGmJRAkycuHAHRg32OmUcww7on3RYdg4Va+PmSTsz/K68vbdEjh4u\" crossorigin=\"anonymous\">\n\n        <script src=\"https://ajax.googleapis.com/ajax/libs/jquery/3.1.1/jquery.min.js\"></script>\n        <script src=\"https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/js/bootstrap.min.js\"></script>\n    </head>\n    <body>\n        <div class=\"container\">\n" + alert + "            <form method=\"POST\" action=\"upload\" enctype=\"multipart/form-data\" >\n                <h3>MCManager File Upload</h3>\n                <p>Please select the file to upload and the folder to upload to.</p>\n                <div class=\"form-group\">\n                    <label for=\"destination\">Upload Directory</label>\n                    <input type=\"text\" name=\"destination\" class=\"form-control\" id=\"destination\" aria-describedby=\"destinationHelp\" placeholder=\"Upload Directory\">\n                    <small id=\"destinationHelp\" class=\"form-text text-muted\">Enter the upload directory or leave it empty for default.</small>\n                </div>\n                <div class=\"form-group\">\n                    <label for=\"file\">File</label>\n                    <input type=\"file\" name=\"file\" class=\"form-control-file\" id=\"file\" aria-describedby=\"fileHelp\">\n                    <small id=\"fileHelp\" class=\"form-text text-muted\">Select a file to upload, should be smaller than 10MB</small>\n                </div>\n                <button type=\"submit\" class=\"btn btn-primary\">Upload</button>\n            </form>\n        </div>\n    </body>\n</html>";
        byte[] b = html.getBytes("UTF-8");
        t.getResponseHeaders().add("Content-type", "text/html");
        t.sendResponseHeaders(200, b.length);
        os.write(b);
        os.close();
    }
}

