/*
 * Decompiled with CFR 0.152.
 */
package com.betafase.mcmanager.utils.spiget;

import com.betafase.mcmanager.MCManager;
import com.betafase.mcmanager.command.WgetCommand;
import com.betafase.mcmanager.utils.Utils;
import com.betafase.mcmanager.utils.spiget.AuthorNameRequest;
import com.betafase.mcmanager.utils.spiget.ServerRequest;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import org.bukkit.entity.Player;

public class SpigetPlugin {
    String name = "Unknown";
    String author = "Unknown";
    String tag = "Unknown";
    String last_update = "Unknown";
    final int id;
    boolean external;
    String file_size;
    String download_url;
    String rating;
    int downloads;

    public SpigetPlugin(int id) {
        this.id = id;
        this.external = true;
        this.file_size = "Unknown";
        this.download_url = "";
        this.rating = "-/-";
        this.downloads = 0;
    }

    public void loadInformation() {
        this.author = new AuthorNameRequest(this.id).getName();
        ServerRequest r = new ServerRequest("resources/" + this.id);
        JsonObject o = r.getAsJsonObject();
        this.name = o.get("name").getAsString();
        if (this.name.length() > 60) {
            this.name = this.name.substring(0, 60);
        }
        this.tag = o.get("tag").getAsString();
        JsonObject file = o.getAsJsonObject("file");
        this.external = file.get("type").getAsString().equalsIgnoreCase("external");
        this.file_size = file.get("size").getAsDouble() + " " + file.get("sizeUnit").getAsString();
        this.download_url = "https://spigotmc.org/" + file.get("url").getAsString();
        JsonObject ro = o.getAsJsonObject("rating");
        this.rating = ro.get("average").getAsDouble() + " / 5 (" + ro.get("count") + " reviews)";
        this.downloads = o.get("downloads").getAsInt();
        this.last_update = Utils.makeDateReadable(o.get("updateDate").getAsLong() * 1000L);
    }

    public void downloadDirectly(Player notifier, String path) {
        WgetCommand.downloadFile("https://api.spiget.org/v2/resources/" + this.id + "/download", path, notifier);
    }

    public boolean hasDirectDownload() {
        HttpURLConnection con = null;
        try {
            con = (HttpURLConnection)new URL("https://api.spiget.org/v2/resources/" + this.id + "/download").openConnection();
            if (con.getResponseCode() == 200) {
                con.disconnect();
                return true;
            }
        }
        catch (MalformedURLException ex) {
            MCManager.getLog().log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            MCManager.getLog().log(Level.SEVERE, null, ex);
        }
        if (con != null) {
            con.disconnect();
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public int getID() {
        return this.id;
    }

    public String getRating() {
        return this.rating;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getTag() {
        return this.tag;
    }

    public String getLastUpdate() {
        return this.last_update;
    }

    public boolean isExternalDownload() {
        return this.external;
    }

    public String getFileSize() {
        return this.isExternalDownload() ? "-/-" : this.file_size;
    }

    public String getDownloadURL() {
        return this.download_url;
    }

    public int getDownloads() {
        return this.downloads;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public void setLast_update(String last_update) {
        this.last_update = last_update;
    }

    public void setExternal(boolean external) {
        this.external = external;
    }

    public void setFile_size(String file_size) {
        this.file_size = file_size;
    }

    public void setDownload_url(String download_url) {
        this.download_url = download_url;
    }

    public void setRating(String rating) {
        this.rating = rating;
    }

    public void setDownloads(int downloads) {
        this.downloads = downloads;
    }
}

