/*
 * Decompiled with CFR 0.152.
 */
package com.betafase.mcmanager.utils.spiget;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ServerRequest {
    private String path;
    private String result;
    private final String body;

    @Deprecated
    public ServerRequest(String path) {
        this.path = path;
        this.result = this.requestFromServer();
        this.body = null;
    }

    public ServerRequest(String path, Map<String, String> params, String body) {
        if (!params.isEmpty()) {
            path = path + "?";
            for (Map.Entry<String, String> entries : params.entrySet()) {
                if (!path.endsWith("?")) {
                    path = path + "&";
                }
                try {
                    path = path + entries.getKey() + "=" + URLEncoder.encode(entries.getValue(), "UTF-8");
                }
                catch (UnsupportedEncodingException ex) {
                    Logger.getLogger(ServerRequest.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        this.path = path;
        System.out.println("Path: " + path);
        this.body = body;
        this.result = this.requestFromServer();
    }

    public ServerRequest(String path, Map<String, String> params) {
        this(path, params, null);
    }

    public JsonElement getAsJsonElement() {
        if (this.result == null) {
            JsonObject o = new JsonObject();
            o.addProperty("result", "error");
            o.addProperty("description", "Connection failed!");
            return o;
        }
        return new JsonParser().parse(this.result);
    }

    public JsonObject getAsJsonObject() {
        if (this.result == null) {
            JsonObject o = new JsonObject();
            o.addProperty("result", "error");
            o.addProperty("description", "Connection failed!");
            return o;
        }
        JsonObject o = this.getAsJsonElement().getAsJsonObject();
        return o;
    }

    public String getAsString() {
        return this.result;
    }

    private String requestFromServer() {
        try {
            URL bf = new URL("https://api.spiget.org/v2/" + this.path);
            HttpURLConnection con = (HttpURLConnection)bf.openConnection();
            con.addRequestProperty("User-Agent", "MCManager");
            con.setDoInput(true);
            if (this.body != null) {
                con.setDoOutput(true);
                con.setRequestMethod("POST");
                BufferedWriter w = new BufferedWriter(new OutputStreamWriter(con.getOutputStream()));
                w.write(this.body);
                w.flush();
            }
            int code = con.getResponseCode();
            switch (code) {
                case 200: {
                    BufferedReader r = new BufferedReader(new InputStreamReader(con.getInputStream(), "UTF-8"));
                    String line = null;
                    StringBuilder b = new StringBuilder();
                    while ((line = r.readLine()) != null) {
                        b.append(line);
                    }
                    return b.toString();
                }
                case 401: {
                    JsonObject o = new JsonObject();
                    o.addProperty("result", "error");
                    o.addProperty("code", (Number)code);
                    o.addProperty("description", "Authentication failed!");
                    return o.toString();
                }
            }
            JsonObject o = new JsonObject();
            o.addProperty("result", "error");
            o.addProperty("code", (Number)code);
            o.addProperty("description", con.getResponseMessage());
            return o.toString();
        }
        catch (Exception ex) {
            Logger.getLogger(ServerRequest.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }
}

