/*
 * Decompiled with CFR 0.152.
 */
package com.betafase.mcmanager.utils;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;

public class Updater {
    private final Plugin plugin;
    private String newVersion;
    private String newTitle;
    private String newDescription_en;
    private String currentVersion;
    private String nms;

    public Updater(Plugin plugin) {
        this.plugin = plugin;
        this.nms = Bukkit.getServer().getClass().getPackage().getName();
        this.nms = this.nms.substring(this.nms.lastIndexOf(".") + 1);
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    public String getNewVersion() {
        return this.newVersion;
    }

    public String getOldVersion() {
        return this.currentVersion;
    }

    public String getUpdateTitle() {
        return this.newTitle;
    }

    public String getUpdateDescription_en() {
        return this.newDescription_en;
    }

    public String getDownloadURL() {
        return "https://betafase.com/plugin/" + this.plugin.getName() + "/latest";
    }

    public String getJarName() {
        return this.plugin.getName() + ".jar";
    }

    public void downloadLatest(Player notifier) {
        int preprogress = 0;
        try {
            File target = new File("plugins", this.plugin.getName() + ".jar");
            URL url = new URL("https://betafase.com/plugin/" + this.plugin.getName() + "/latest");
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setInstanceFollowRedirects(true);
            connection.setRequestProperty("User-Agent", "PluginInstaller");
            int filesize = connection.getContentLength();
            float totalDataRead = 0.0f;
            BufferedInputStream in = new BufferedInputStream(connection.getInputStream());
            FileOutputStream fos = new FileOutputStream(target);
            BufferedOutputStream bout = new BufferedOutputStream(fos, 1024);
            byte[] data = new byte[1024];
            int i = 0;
            while ((i = in.read(data, 0, 1024)) >= 0) {
                bout.write(data, 0, i);
                float Percent = (totalDataRead += (float)i) * 100.0f / (float)filesize;
                int progress = (int)Percent;
                if (preprogress == progress) continue;
                this.sendActionBarMessage(notifier, "\u00a76" + progress + "% \u00a77- \u00a78Downloading from " + url.getAuthority());
                preprogress = progress;
            }
            bout.close();
            in.close();
            this.sendActionBarMessage(notifier, "\u00a7aCOMPLETE - \u00a78Saved to " + target.getPath());
            TextComponent c1 = new TextComponent("\u00a77You have to reload the server to apply the Update. Reload now?");
            TextComponent c2 = new TextComponent("\u00a7a\u00a7l[YES]");
            c2.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/reload"));
            TextComponent c3 = new TextComponent("  \u00a7c\u00a7l[NO]");
            notifier.spigot().sendMessage(new BaseComponent[]{c1, c2, c3});
        }
        catch (Exception e) {
            this.sendActionBarMessage(notifier, "\u00a7cERROR \u00a77- \u00a78" + e.getClass().getName());
            notifier.sendMessage("\u00a7c" + e.getLocalizedMessage());
        }
    }

    public boolean hasUpdate() {
        try {
            String inputLine;
            PluginDescriptionFile f = this.plugin.getDescription();
            URL obj = new URL("https://api.betafase.com/plugins/" + f.getName() + "/version");
            HttpURLConnection con = (HttpURLConnection)obj.openConnection();
            con.setRequestMethod("GET");
            con.setRequestProperty("User-Agent", "Mozilla/5.0");
            con.setInstanceFollowRedirects(true);
            int responseCode = con.getResponseCode();
            System.out.println("[" + this.plugin.getName() + "] Checking for updates");
            if (responseCode != 200) {
                System.out.println("[" + this.plugin.getName() + "] Response Code : " + responseCode);
                return false;
            }
            BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
            StringBuilder response = new StringBuilder();
            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine);
            }
            in.close();
            inputLine = response.toString();
            if (inputLine == null) {
                throw new IOException("Could not read Data");
            }
            JsonElement element = new JsonParser().parse(inputLine);
            JsonObject object = element.getAsJsonObject();
            this.newVersion = object.get("version").getAsString();
            this.currentVersion = f.getVersion();
            if (!this.newVersion.equalsIgnoreCase(this.currentVersion)) {
                this.newTitle = object.get("title").getAsString();
                this.newDescription_en = object.get("description_en").getAsString();
                System.out.println("[" + this.plugin.getName() + "] An Update was found: v" + this.newVersion);
                return true;
            }
            System.out.println("[" + this.plugin.getName() + "] You are running the lastest version.");
            return false;
        }
        catch (Exception ex) {
            System.out.println("[" + this.plugin.getName() + "] Failed to check for updates: " + ex.getMessage());
            ex.printStackTrace();
            return false;
        }
    }

    private void sendActionBarMessage(Player pl, String message) {
        pl.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent(message));
    }
}

