/*
 * Decompiled with CFR 0.152.
 */
package com.betafase.mcmanager.utils;

import com.betafase.mcmanager.MCManager;
import com.betafase.mcmanager.api.SignInputHandler;
import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.ProtocolManager;
import com.comphenix.protocol.events.ListenerPriority;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.events.PacketListener;
import com.comphenix.protocol.wrappers.BlockPosition;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class TextInputHandleWrapper
extends PacketAdapter {
    private final HashMap<String, SignInputHandler> handlers = new HashMap();
    private final Random r = new Random();
    private final ProtocolManager protocolManager = ProtocolLibrary.getProtocolManager();

    public TextInputHandleWrapper(Plugin plugin) {
        super(plugin, ListenerPriority.NORMAL, new PacketType[]{PacketType.Play.Client.UPDATE_SIGN});
        this.protocolManager.addPacketListener((PacketListener)this);
    }

    public boolean requestInput(Player p, SignInputHandler h) {
        try {
            BlockPosition pos = new BlockPosition(this.r.nextInt(200) + 100000, 0, this.r.nextInt(200) + 100000);
            String[] s = h.getDefault();
            Location loc = null;
            if (s != null) {
                loc = new Location(p.getWorld(), (double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
                p.sendBlockChange(loc, Material.SIGN, (byte)0);
                p.sendSignChange(loc, s);
            }
            PacketContainer signGui = new PacketContainer(PacketType.Play.Server.OPEN_SIGN_EDITOR);
            signGui.getBlockPositionModifier().write(0, (Object)pos);
            try {
                this.protocolManager.sendServerPacket(p, signGui);
                if (loc != null) {
                    p.sendBlockChange(loc, Material.BEDROCK, (byte)0);
                }
                String dataset = pos.getX() + ":" + pos.getY() + ":" + pos.getZ();
                this.handlers.put(dataset, h);
                return true;
            }
            catch (InvocationTargetException ex) {
                Logger.getLogger(TextInputHandleWrapper.class.getName()).log(Level.SEVERE, null, ex);
                return false;
            }
        }
        catch (Exception exception) {
            MCManager.getLog().log(Level.SEVERE, "Failed to send sign packets", exception);
            return false;
        }
    }

    public void disable() {
        this.protocolManager.removePacketListener((PacketListener)this);
    }

    public void onPacketReceiving(PacketEvent event) {
        PacketContainer packet = event.getPacket();
        BlockPosition pos = (BlockPosition)packet.getBlockPositionModifier().read(0);
        String dataset = pos.getX() + ":" + pos.getY() + ":" + pos.getZ();
        if (this.handlers.containsKey(dataset)) {
            event.setCancelled(true);
            try {
                String[] lines = (String[])event.getPacket().getStringArrays().getValues().get(0);
                this.handlers.get(pos.getX() + ":" + pos.getY() + ":" + pos.getZ()).handleTextInput(lines);
            }
            catch (Exception ex) {
                MCManager.getLog().log(Level.SEVERE, "Failed to correctly parse SignInput.", ex);
                return;
            }
            this.handlers.remove(dataset);
        }
    }
}

