/*
 * Decompiled with CFR 0.152.
 */
package com.betafase.mcmanager.utils;

import com.betafase.mcmanager.MCManager;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.util.ChatPaginator;

public class Text {
    String t;
    Object[] params = null;
    String lang = defaultlang;
    private static HashMap<String, HashMap<String, String>> translations = new HashMap();
    private static String defaultlang = "en_US";
    private static boolean debug = false;
    private static boolean peruserlang = true;
    private static PlayerLanguage playerlang = p -> defaultlang;

    public static void setPlayerLanguageExecutor(PlayerLanguage player_language) {
        playerlang = player_language;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void addLanguage(FileConfiguration cfg) {
        if (!cfg.isString("language.id")) throw new IllegalArgumentException("Invalid Language file format. Check wiki for more information.");
        if (!cfg.isString("language.name") || !cfg.isString("language.region") || !cfg.isString("language.plugin") || !cfg.isString("language.prefix")) throw new IllegalArgumentException("Please provide a region or a list of regions");
        HashMap<Object, Object> lang = translations.containsKey(cfg.getString("language.id")) ? translations.get(cfg.getString("language.id")) : new HashMap();
        for (String s : cfg.getKeys(true)) {
            lang.put(cfg.getString("language.prefix") + "." + s, cfg.getString(s));
        }
        translations.put(cfg.getString("language.id"), lang);
        Bukkit.getLogger().log(Level.INFO, "[Translator] Loaded language ''{0}({1})'' into cache for Plugin ''{2}''", new Object[]{cfg.getString("language.name"), cfg.getString("language.region"), cfg.getString("language.plugin")});
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void addLanguage(Properties props) {
        if (!props.containsKey("language.id")) throw new IllegalArgumentException("Invalid Language file format. Check wiki for more information.");
        if (!props.containsKey("language.name") || !props.containsKey("language.region") || !props.containsKey("language.plugin") || !props.containsKey("language.prefix")) throw new IllegalArgumentException("Please provide a region or a list of regions");
        HashMap<Object, Object> lang = translations.containsKey((String)props.get("language.id")) ? translations.get((String)props.get("language.id")) : new HashMap();
        for (String s : props.stringPropertyNames()) {
            lang.put(props.getProperty("language.prefix") + "." + s, props.getProperty(s));
        }
        translations.put(props.getProperty("language.id"), lang);
        Bukkit.getLogger().log(Level.INFO, "[Translator] Loaded language ''{0}({1})'' into cache for Plugin ''{2}''", new Object[]{props.getProperty("language.name"), props.getProperty("language.region"), props.getProperty("language.plugin")});
    }

    public static boolean removeLanguage(String language) {
        if (translations.containsKey(language)) {
            translations.remove(language);
            return true;
        }
        return false;
    }

    public static HashMap<String, HashMap<String, String>> getTranslations() {
        return translations;
    }

    public static void setDefaultLanguage(String language) {
        defaultlang = language;
    }

    public static void setPerUserLanguage(boolean peruser) {
        peruserlang = peruser;
    }

    public static void setDebugMode(boolean debug) {
        Text.debug = debug;
    }

    public static String getDefaultLanguage() {
        return defaultlang;
    }

    @Deprecated
    public Text(String msg) {
        this.t = msg;
    }

    public Text(String msg, String lang) {
        this.t = msg;
        this.lang = lang;
    }

    public Text(String msg, String lang, Object ... params) {
        this.t = msg;
        this.params = params;
        this.lang = lang;
    }

    public static String getLanguage(Player p) {
        return playerlang.getLanguage(p);
    }

    public List<String> wordWrap(int linelenght, ChatColor color) {
        ArrayList<String> list = new ArrayList<String>();
        for (String s : ChatPaginator.wordWrap((String)this.toString(), (int)linelenght)) {
            list.add(color + ChatColor.stripColor((String)s));
        }
        return list;
    }

    public String[] wordWrapAsArray(int linelength, ChatColor color) {
        List<String> list = this.wordWrap(linelength, color);
        return list.toArray(new String[list.size()]);
    }

    public static List<String> wordWrap(String text, int linelenght, ChatColor color) {
        ArrayList<String> list = new ArrayList<String>();
        for (String s : ChatPaginator.wordWrap((String)text, (int)linelenght)) {
            list.add(color + ChatColor.stripColor((String)s));
        }
        return list;
    }

    public static String[] wordWrapAsArray(String text, int linelength, ChatColor color) {
        List<String> list = Text.wordWrap(text, linelength, color);
        return list.toArray(new String[list.size()]);
    }

    public String toString() {
        String t = this.t;
        if (debug) {
            return t;
        }
        if (peruserlang) {
            if (translations.containsKey(this.lang)) {
                HashMap<String, String> cfg = translations.get(this.lang);
                if (cfg.containsKey(t)) {
                    t = cfg.get(t);
                } else {
                    Bukkit.getLogger().log(Level.WARNING, "[Translator] Language ''{0}'' does not contain the text ''{1}''. Falling back to default language.", new Object[]{this.lang, t});
                }
            } else {
                HashMap<String, String> cfg;
                Bukkit.getLogger().log(Level.WARNING, "[Translator] Did not find client region ''{0}''. Checking for similar regions...", this.lang.substring(2));
                String language = defaultlang;
                for (String s : translations.keySet()) {
                    if (!s.substring(0, 2).equalsIgnoreCase(this.lang.substring(0, 2))) continue;
                    language = s;
                    break;
                }
                if ((cfg = translations.get(language)).containsKey(t)) {
                    t = cfg.get(t);
                } else {
                    Bukkit.getLogger().log(Level.WARNING, "[Translator] Language ''{0}'' does not contain the text ''{1}''. Falling back to default language.", new Object[]{this.lang, t});
                }
            }
        }
        if (!peruserlang || t.equalsIgnoreCase(this.t)) {
            if (translations.containsKey(defaultlang)) {
                if (translations.get(defaultlang).containsKey(t)) {
                    t = translations.get(defaultlang).get(t);
                } else {
                    Bukkit.getLogger().log(Level.SEVERE, "[Translator] Missing text for ''{0}'' in defaultlanguage.", t);
                }
            } else {
                Bukkit.getLogger().log(Level.SEVERE, "[Translator] Fatal error: No language file for the default language existing.");
            }
        }
        t = ChatColor.translateAlternateColorCodes((char)'&', (String)t);
        if (this.params != null && this.params.length != 0) {
            return MessageFormat.format(t, this.params);
        }
        return t;
    }

    public static String reportError(Exception ex, String lang) {
        return MCManager.getPrefix() + new Text("mcm.exception.message", lang, ex.getClass().getSimpleName(), ex.getMessage()).toString();
    }

    public static interface PlayerLanguage {
        public String getLanguage(Player var1);
    }
}

