/*
 * Decompiled with CFR 0.152.
 */
package com.betafase.mcmanager.utils;

import com.betafase.mcmanager.MCManager;
import com.betafase.mcmanager.command.WgetCommand;
import com.betafase.mcmanager.utils.Text;
import com.google.common.base.Charsets;
import com.google.common.io.Resources;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.time.DurationFormatUtils;
import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class SpigotUpdater {
    private String version;
    private static Process p = null;
    private Logger l = MCManager.getInstance().getLogger();

    public String getVersion() {
        return this.version;
    }

    public static void cancelUpdate() {
        if (SpigotUpdater.isUpdating()) {
            p.destroyForcibly();
            p = null;
        }
    }

    public static boolean isUpdating() {
        if (p != null) {
            if (p.isAlive()) {
                return true;
            }
            p = null;
        }
        return false;
    }

    public int buildsBehind() {
        this.version = Bukkit.getVersion();
        if (this.version == null) {
            this.version = "Custom";
        }
        if (this.version.startsWith("git-Spigot-")) {
            String[] parts = this.version.substring("git-Spigot-".length()).split("-");
            int cbVersions = this.getDistance("craftbukkit", parts[1].substring(0, parts[1].indexOf(32)));
            int spigotVersions = this.getDistance("spigot", parts[0]);
            this.version = "Spigot";
            if (cbVersions == -1 || spigotVersions == -1) {
                return -1;
            }
            if (cbVersions == 0 && spigotVersions == 0) {
                return 0;
            }
            return cbVersions + spigotVersions;
        }
        if (this.version.startsWith("git-Bukkit-")) {
            this.version = this.version.substring("git-Bukkit-".length());
            int cbVersions = this.getDistance("craftbukkit", this.version.substring(0, this.version.indexOf(32)));
            this.version = "Bukkit";
            switch (cbVersions) {
                case -1: {
                    return -1;
                }
                case 0: {
                    return 0;
                }
            }
            return cbVersions;
        }
        return -2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getDistance(String repo, String hash) {
        int n;
        BufferedReader reader = Resources.asCharSource((URL)new URL("https://hub.spigotmc.org/stash/rest/api/1.0/projects/SPIGOT/repos/" + repo + "/commits?since=" + URLEncoder.encode(hash, "UTF-8") + "&withCounts=true"), (Charset)Charsets.UTF_8).openBufferedStream();
        try {
            JSONObject obj = (JSONObject)new JSONParser().parse((Reader)reader);
            n = ((Number)obj.get((Object)"totalCount")).intValue();
        }
        catch (ParseException ex) {
            int n2;
            try {
                ex.printStackTrace();
                n2 = -1;
            }
            catch (Throwable throwable) {
                try {
                    reader.close();
                    throw throwable;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return -1;
                }
            }
            reader.close();
            return n2;
        }
        reader.close();
        return n;
    }

    public void performUpdate(String version, Player notifier) {
        File builder;
        if (SpigotUpdater.isUpdating()) {
            this.l.log(Level.SEVERE, "A Update is currently running. Please cancel it first.");
            return;
        }
        long time = System.currentTimeMillis();
        String prefix = MCManager.getPrefix();
        Bukkit.broadcastMessage((String)(prefix + new Text("mcm.spigot.lag_warning")));
        if (notifier != null) {
            notifier.sendMessage(prefix + new Text("mcm.spigot.update_info"));
        }
        if (Bukkit.isPrimaryThread()) {
            this.l.log(Level.SEVERE, "This Action takes a lot of time. Running it in the primary thread would cause a lot of lag and might result in a server crash. Cancelling.");
            return;
        }
        if (version == null) {
            version = "";
        }
        if ((builder = new File("SpigotUpdater")).exists()) {
            try {
                FileUtils.deleteDirectory(builder);
            }
            catch (IOException ex) {
                Logger.getLogger(SpigotUpdater.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        builder.mkdir();
        File buildTools = new File(builder, "BuildTools.jar");
        if (buildTools.exists()) {
            buildTools.delete();
        }
        if (notifier != null) {
            notifier.sendMessage(prefix + new Text("mcm.spigot.build_tools"));
        }
        WgetCommand.downloadFile("https://hub.spigotmc.org/jenkins/job/BuildTools/lastSuccessfulBuild/artifact/target/BuildTools.jar", builder.getPath(), notifier);
        if (!buildTools.exists()) {
            this.l.log(Level.SEVERE, "Failed to download BuildTools, aborting!");
            if (notifier != null) {
                notifier.sendMessage(prefix + "\u00a7cFailed to download BuildTools, aborting. See the log for more details.");
            }
            return;
        }
        try {
            if (notifier != null) {
                notifier.sendMessage(prefix + new Text("mcm.spigot.build_start"));
            }
            p = new ProcessBuilder("java", "-jar", "BuildTools.jar", version).directory(builder).start();
            InputStream toRead = p.getInputStream();
            BufferedReader r = new BufferedReader(new InputStreamReader(toRead));
            String next = null;
            while ((next = r.readLine()) != null) {
                this.l.log(Level.INFO, next);
                if (notifier == null || !notifier.isOnline()) continue;
                notifier.sendMessage(prefix + "\u00a77" + next);
            }
            p.waitFor();
            p = null;
            this.l.log(Level.INFO, "New Files have been created. Check the SpigotUpdater directory ;)");
            time = System.currentTimeMillis() - time;
            if (notifier != null) {
                String lang = Text.getLanguage(notifier);
                notifier.sendMessage(prefix + new Text("mcm.spigot.build_done", Text.getDefaultLanguage(), DurationFormatUtils.formatDurationHMS((long)time)));
                TextComponent pre = new TextComponent(prefix);
                for (File f : builder.listFiles((dir, name) -> !name.equalsIgnoreCase("BuildTools.jar") && name.endsWith(".jar"))) {
                    TextComponent usr = new TextComponent(new Text("mcm.spigot.usr", lang, f.getName()).toString());
                    usr.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/manager usr " + f.getName()));
                    notifier.spigot().sendMessage(new BaseComponent[]{pre, usr});
                }
                notifier.playSound(notifier.getLocation(), Sound.ENTITY_WITHER_DEATH, 0.3f, 1.0f);
            }
        }
        catch (IOException | InterruptedException ex) {
            ex.printStackTrace();
        }
    }
}

