/*
 * Decompiled with CFR 0.152.
 */
package com.betafase.mcmanager.utils;

import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.PlayerInventory;

public class PlayerRestoreData {
    private final PlayerInventory inv;
    private final double health;
    private final int food;
    private final Location loc;
    private final GameMode gm;
    private final UUID uuid;

    public PlayerRestoreData(UUID uuid, PlayerInventory inv, double health, int food, Location loc, GameMode gm) {
        this.inv = inv;
        this.health = health;
        this.food = food;
        this.loc = loc;
        this.gm = gm;
        this.uuid = uuid;
    }

    public void restore(boolean fromDisc) {
        Player p = Bukkit.getPlayer((UUID)this.uuid);
        if (p != null && p.isOnline()) {
            if (this.loc.getBlock().getType() != Material.AIR || this.loc.clone().add(0.0, 1.0, 0.0).getBlock().getType() != Material.AIR) {
                p.teleport(p.getBedSpawnLocation() == null ? this.loc.getWorld().getSpawnLocation() : p.getBedSpawnLocation());
            } else {
                p.teleport(this.loc, PlayerTeleportEvent.TeleportCause.PLUGIN);
            }
            if (fromDisc) {
                p.loadData();
            } else {
                p.getInventory().setContents(this.inv.getContents());
                p.setHealth(this.health);
                p.setFoodLevel(this.food);
            }
            p.setGameMode(this.gm);
        }
    }
}

