/*
 * Decompiled with CFR 0.152.
 */
package com.betafase.mcmanager.utils;

import com.betafase.mcmanager.MCManager;
import com.betafase.mcmanager.utils.Text;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class BackupManager {
    private BukkitTask backup = null;
    private int timing = MCManager.getConfiguration().getInt("backup.interval", 30);
    private boolean paused = false;

    public void restart() {
        this.timing = MCManager.getConfiguration().getInt("backup.interval", 30);
        this.cancel();
        this.start();
    }

    public boolean isActive() {
        return this.backup != null;
    }

    public void start() {
        MCManager.getLog().log(Level.INFO, "Automatic Backup is currently set to {0} minutes. You can change this in the config.", this.timing);
        this.backup = new BukkitRunnable(){

            public void run() {
                while (BackupManager.this.paused) {
                }
                BackupManager.this.backupData();
            }
        }.runTaskTimerAsynchronously((Plugin)MCManager.getInstance(), 20L, (long)(this.timing * 60) * 20L);
    }

    public void cancel() {
        if (this.isActive()) {
            this.backup.cancel();
        }
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void setPaused(boolean paused) {
        this.paused = paused;
    }

    public void backupData() {
        FileConfiguration cfg = MCManager.getConfiguration();
        if (cfg.getBoolean("backup.empty", false) || !Bukkit.getOnlinePlayers().isEmpty()) {
            try {
                List<File> files;
                String name;
                MCManager.getLog().log(Level.INFO, "Starting Backup...");
                Bukkit.broadcastMessage((String)(MCManager.getPrefix() + new Text("mcm.backup.warning")));
                Bukkit.savePlayers();
                for (World w : Bukkit.getWorlds()) {
                    w.save();
                }
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(BackupManager.class.getName()).log(Level.SEVERE, null, ex);
                }
                File backup = new File(cfg.getString("backup.folder", "backups"));
                boolean zip = cfg.getBoolean("backup.zip", true);
                if (cfg.getBoolean("backup.worlds", false)) {
                    name = "worlds-" + new SimpleDateFormat("DDD-HH:mm").format(new Date());
                    if (!backup.exists()) {
                        backup.mkdirs();
                    } else {
                        int amount = cfg.getInt("backup.amount", 5);
                        if (amount != -1 && backup.list().length >= amount) {
                            MCManager.getLog().log(Level.INFO, "Deleting previous files to make space...");
                            files = Arrays.asList(backup.listFiles());
                            files.sort((o1, o2) -> {
                                if (o1.lastModified() < o2.lastModified()) {
                                    return -1;
                                }
                                return 1;
                            });
                            for (File f : files) {
                                if (backup.list().length < amount) break;
                                if (f.isFile()) {
                                    f.delete();
                                    continue;
                                }
                                try {
                                    FileUtils.deleteDirectory(f);
                                }
                                catch (IOException ex) {
                                    MCManager.getLog().log(Level.SEVERE, null, ex);
                                }
                            }
                        }
                    }
                    if (zip) {
                        try {
                            LinkedList<File> toZip = new LinkedList<File>();
                            for (World w : Bukkit.getWorlds()) {
                                BackupManager.getAllFiles(w.getWorldFolder(), toZip);
                            }
                            BackupManager.writeZipFile(Bukkit.getWorldContainer(), new File(backup, name + ".zip"), toZip);
                        }
                        catch (IOException ex) {
                            MCManager.getLog().log(Level.SEVERE, "Failed to create compressed backup.", ex);
                        }
                    } else {
                        try {
                            File newB = new File(backup, name);
                            newB.mkdirs();
                            for (World w : Bukkit.getWorlds()) {
                                FileUtils.copyDirectoryToDirectory(w.getWorldFolder(), newB);
                            }
                        }
                        catch (IOException ex) {
                            MCManager.getLog().log(Level.SEVERE, "Failed to create uncompressed backup.", ex);
                        }
                    }
                }
                if (cfg.getBoolean("backup.plugins", false)) {
                    MCManager.getLog().log(Level.INFO, "Creating additional plugin backups...");
                    name = "plugindata-" + new SimpleDateFormat("DDD-HH:mm").format(new Date());
                    if (!backup.exists()) {
                        backup.mkdirs();
                    } else {
                        int amount = cfg.getInt("backup.amount", 5);
                        if (amount != -1 && backup.list().length >= amount) {
                            MCManager.getLog().log(Level.INFO, "Deleting previous files to make space...");
                            files = Arrays.asList(backup.listFiles());
                            files.sort((o1, o2) -> {
                                if (o1.lastModified() < o2.lastModified()) {
                                    return -1;
                                }
                                return 1;
                            });
                            for (File f : files) {
                                if (backup.list().length < amount) break;
                                if (f.isFile()) {
                                    f.delete();
                                    continue;
                                }
                                try {
                                    FileUtils.deleteDirectory(f);
                                }
                                catch (IOException ex) {
                                    MCManager.getLog().log(Level.SEVERE, null, ex);
                                }
                            }
                        }
                    }
                    if (zip) {
                        try {
                            LinkedList<File> toZip = new LinkedList<File>();
                            for (Plugin pl : Bukkit.getPluginManager().getPlugins()) {
                                if (!pl.getDataFolder().exists()) continue;
                                BackupManager.getAllFiles(pl.getDataFolder(), toZip);
                            }
                            BackupManager.writeZipFile(Bukkit.getWorldContainer(), new File(backup, name + ".zip"), toZip);
                        }
                        catch (IOException ex) {
                            MCManager.getLog().log(Level.SEVERE, "Failed to create compressed plugindata backup.", ex);
                        }
                    } else {
                        try {
                            File newB = new File(backup, name);
                            newB.mkdirs();
                            for (Plugin pl : Bukkit.getPluginManager().getPlugins()) {
                                if (!pl.getDataFolder().exists()) continue;
                                FileUtils.copyDirectoryToDirectory(pl.getDataFolder(), newB);
                            }
                        }
                        catch (IOException ex) {
                            MCManager.getLog().log(Level.SEVERE, "Failed to create uncompressed plugindata backup.", ex);
                        }
                    }
                }
                Bukkit.broadcastMessage((String)(MCManager.getPrefix() + new Text("mcm.backup.complete")));
            }
            catch (Exception e) {
                MCManager.getLog().log(Level.SEVERE, "Failed to create Backup", e);
            }
        }
    }

    public static void getAllFiles(File dir, List<File> fileList) {
        File[] files;
        for (File file : files = dir.listFiles()) {
            fileList.add(file);
            if (!file.isDirectory()) continue;
            BackupManager.getAllFiles(file, fileList);
        }
    }

    public static void writeZipFile(File directory, File zipfile, List<File> fileList) throws FileNotFoundException, IOException {
        FileOutputStream fos = new FileOutputStream(zipfile);
        ZipOutputStream zos = new ZipOutputStream(fos);
        for (File file : fileList) {
            if (file.isDirectory()) continue;
            BackupManager.addToZip(directory, file, zos);
        }
        zos.close();
        fos.close();
    }

    private static void addToZip(File directoryToZip, File file, ZipOutputStream zos) throws FileNotFoundException, IOException {
        int length;
        FileInputStream fis = new FileInputStream(file);
        String zipFilePath = file.getCanonicalPath().substring(directoryToZip.getCanonicalPath().length() + 1, file.getCanonicalPath().length());
        ZipEntry zipEntry = new ZipEntry(zipFilePath);
        zos.putNextEntry(zipEntry);
        byte[] bytes = new byte[1024];
        while ((length = fis.read(bytes)) >= 0) {
            zos.write(bytes, 0, length);
        }
        zos.closeEntry();
        fis.close();
    }
}

