/*
 * Decompiled with CFR 0.152.
 */
package com.betafase.mcmanager.gui.world;

import com.betafase.mcmanager.MCManager;
import com.betafase.mcmanager.api.BlockColor;
import com.betafase.mcmanager.api.GUIUtils;
import com.betafase.mcmanager.api.Menu;
import com.betafase.mcmanager.api.MenuItem;
import com.betafase.mcmanager.api.NotificationPrompt;
import com.betafase.mcmanager.api.RawMenuItem;
import com.betafase.mcmanager.api.SafetyPrompt;
import com.betafase.mcmanager.api.SignInputHandler;
import com.betafase.mcmanager.gui.MainMenu;
import com.betafase.mcmanager.gui.world.WorldCreateMenu;
import com.betafase.mcmanager.security.ModuleManager;
import com.betafase.mcmanager.utils.Text;
import com.betafase.mcmanager.utils.Utils;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Difficulty;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.WorldCreator;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class WorldsMenu
extends Menu {
    private int page;

    public WorldsMenu(final String lang, final int page) {
        super(new Text("mcm.gui.worlds.title", lang).toString(), 36, lang);
        this.page = page;
        MenuItem black = GUIUtils.black();
        for (int i = 0; i < 9; ++i) {
            this.setItem(i, black);
            this.setItem(27 + i, black);
        }
        this.setItem(9, black);
        this.setItem(18, black);
        this.setItem(17, black);
        this.setItem(26, black);
        this.setItem(31, GUIUtils.back(lang));
        if (page != 0) {
            this.setItem(30, GUIUtils.previous_page(lang, page));
        }
        new BukkitRunnable(){

            public void run() {
                MenuItem search = new MenuItem(Material.STAINED_GLASS_PANE, BlockColor.BROWN, new Text("mcm.gui.worlds.search", lang).toString());
                WorldsMenu.this.setItem(27, search);
                MenuItem add = new MenuItem(Material.STAINED_GLASS_PANE, BlockColor.LIME, new Text("mcm.gui.worlds.add", lang).toString());
                WorldsMenu.this.setItem(28, add);
                int counter = -page * 14;
                for (World w : Bukkit.getWorlds()) {
                    Material mat;
                    if (counter < 0) {
                        ++counter;
                        continue;
                    }
                    if (counter == 14) {
                        WorldsMenu.this.setItem(32, GUIUtils.next_page(lang, page + 2));
                        break;
                    }
                    switch (w.getEnvironment()) {
                        case NETHER: {
                            mat = Material.NETHERRACK;
                            break;
                        }
                        case THE_END: {
                            mat = Material.ENDER_STONE;
                            break;
                        }
                        default: {
                            mat = Material.GRASS;
                        }
                    }
                    MenuItem m = new MenuItem(mat);
                    ItemMeta im = m.getItemMeta();
                    im.setDisplayName("\u00a79\u00a7l" + w.getName());
                    LinkedList<String> lore = new LinkedList<String>();
                    lore.add("\u00a78Players: \u00a76" + w.getPlayers().size());
                    lore.add("\u00a78Entities: \u00a76" + w.getEntities().size());
                    lore.add("\u00a78PVP: \u00a76" + w.getPVP());
                    lore.add("\u00a78Difficulty: \u00a76" + w.getDifficulty());
                    lore.add(" ");
                    lore.add(new Text("mcm.gui.worlds.manage", lang).toString());
                    im.setLore(lore);
                    m.setItemMeta(im);
                    WorldsMenu.this.setItem(GUIUtils.convertCounterSlot(counter), m);
                    ++counter;
                }
                File worldFolder = new File(FilenameUtils.getFullPath(Bukkit.getWorldContainer().getAbsolutePath()));
                for (File f : worldFolder.listFiles(pathname -> pathname.isDirectory() && pathname.list((dir, name) -> name.equalsIgnoreCase("level.dat")).length > 0)) {
                    if (counter < 0) {
                        ++counter;
                        continue;
                    }
                    if (counter == 14) {
                        WorldsMenu.this.setItem(32, GUIUtils.next_page(lang, page + 2));
                        break;
                    }
                    if (Bukkit.getWorld((String)f.getName()) != null) continue;
                    MenuItem folder = new MenuItem(Material.CHEST);
                    ItemMeta fMeta = folder.getItemMeta();
                    fMeta.setDisplayName("\u00a79\u00a7l" + f.getName());
                    List<String> lore = new Text("mcm.gui.worlds.unloaded", lang).wordWrap(40, ChatColor.GRAY);
                    lore.add(" ");
                    lore.add(new Text("mcm.gui.worlds.load", lang).toString());
                    fMeta.setLore(lore);
                    folder.setItemMeta(fMeta);
                    WorldsMenu.this.setItem(GUIUtils.convertCounterSlot(counter), folder);
                    ++counter;
                }
            }
        }.runTaskAsynchronously((Plugin)MCManager.getInstance());
    }

    @Override
    public void onClick(InventoryClickEvent e) {
        Player p = (Player)e.getWhoClicked();
        int converted = GUIUtils.convertInventorySlot(e.getSlot());
        if (converted != -1) {
            if (e.getCurrentItem().getType() != Material.AIR && e.getCurrentItem().getType() != null) {
                switch (e.getCurrentItem().getType()) {
                    case CHEST: {
                        new WorldCreateMenu(new WorldCreator(ChatColor.stripColor((String)e.getCurrentItem().getItemMeta().getDisplayName())), this.lang).open(p);
                        break;
                    }
                    default: {
                        new WorldMenu((World)Bukkit.getWorlds().get(converted), this.lang).open(p);
                        break;
                    }
                }
            }
        } else {
            switch (e.getSlot()) {
                case 27: {
                    break;
                }
                case 28: {
                    e.getView().close();
                    TextComponent create = new TextComponent(new Text("mcm.gui.createworld.prepare", this.lang).toString());
                    create.setClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/createworld <name> [args]"));
                    p.spigot().sendMessage(new BaseComponent[]{new TextComponent(MCManager.getPrefix()), create});
                    break;
                }
                case 31: {
                    new MainMenu(p, this.lang).open(p);
                    break;
                }
                case 32: {
                    if (e.getCurrentItem().getDurability() != BlockColor.WHITE.toShort()) break;
                    new WorldsMenu(this.lang, this.page + 1).open(p);
                    break;
                }
                case 30: {
                    if (e.getCurrentItem().getDurability() != BlockColor.WHITE.toShort()) break;
                    new WorldsMenu(this.lang, this.page - 1).open(p);
                }
            }
        }
    }

    @Override
    public final void setItem(int slot, RawMenuItem stack) {
        super.setItem(slot, stack);
    }

    private static class WorldMenu
    extends Menu {
        private World w;

        public WorldMenu(final World w, String lang) {
            super(new Text("mcm.gui.world.title", lang, w.getName()).toString(), 36, lang);
            Material mat;
            this.w = w;
            MenuItem black = GUIUtils.black();
            for (int i = 0; i < 9; ++i) {
                this.setItem(i, black);
                this.setItem(27 + i, black);
            }
            this.setItem(9, black);
            this.setItem(18, black);
            this.setItem(17, black);
            this.setItem(26, black);
            this.setItem(31, GUIUtils.back(lang));
            switch (w.getEnvironment()) {
                case NETHER: {
                    mat = Material.NETHERRACK;
                    break;
                }
                case THE_END: {
                    mat = Material.ENDER_STONE;
                    break;
                }
                default: {
                    mat = Material.GRASS;
                }
            }
            MenuItem m = new MenuItem(mat);
            ItemMeta im = m.getItemMeta();
            im.setDisplayName("\u00a79\u00a7l" + w.getName());
            LinkedList<String> lore = new LinkedList<String>();
            lore.add("\u00a78UUID: \u00a76" + w.getUID());
            lore.add("\u00a78Seed: \u00a76" + w.getSeed());
            lore.add("\u00a78Players: \u00a76" + w.getPlayers().size());
            lore.add("\u00a78Entities: \u00a76" + w.getEntities().size());
            lore.add("\u00a78Loaded Chunks: \u00a76" + w.getLoadedChunks().length);
            im.setLore(lore);
            m.setItemMeta(im);
            this.setItem(4, m);
            MenuItem teleport = new MenuItem(Material.ENDER_PEARL, new Text("mcm.gui.world.teleport", lang).toString());
            this.setItem(GUIUtils.convertCounterSlot(3), teleport);
            this.updateDifficulty(w.getDifficulty());
            this.updateTime(w.getTime());
            this.updateBoolean(GUIUtils.convertCounterSlot(7), new Text("mcm.gui.world.pvp", lang).toString(), w.getPVP());
            this.setItem(GUIUtils.convertCounterSlot(9), new MenuItem(Material.BOOK, new Text("mcm.gui.world.gamerules", lang).toString()));
            this.setItem(GUIUtils.convertCounterSlot(11), new MenuItem(Material.BARRIER, new Text("mcm.gui.world.unload", lang).toString(), new Text("mcm.gui.world.unload_warning", lang).toString()));
            this.setItem(GUIUtils.convertCounterSlot(13), new MenuItem(Material.LAVA_BUCKET, new Text("mcm.gui.world.delete", lang)));
            new BukkitRunnable(){

                public void run() {
                    if (this.getInventory().getViewers().isEmpty()) {
                        this.cancel();
                    } else {
                        this.updateTime(w.getTime());
                    }
                }
            }.runTaskTimer((Plugin)MCManager.getInstance(), 10L, 10L);
        }

        public void updateBoolean(int slot, String name, boolean newB) {
            String prefix;
            Material mat;
            if (newB) {
                mat = Material.EMERALD_BLOCK;
                prefix = "\u00a7a";
            } else {
                mat = Material.REDSTONE_BLOCK;
                prefix = "\u00a7c";
            }
            this.setItem(slot, new MenuItem(mat, prefix + name, "\u00a77Value: \u00a76" + newB));
        }

        public void updateDifficulty(Difficulty newD) {
            String prefix;
            short id;
            switch (newD) {
                case PEACEFUL: {
                    id = 3;
                    prefix = "\u00a79";
                    break;
                }
                case EASY: {
                    id = 5;
                    prefix = "\u00a7a";
                    break;
                }
                case NORMAL: {
                    id = 4;
                    prefix = "\u00a7e";
                    break;
                }
                case HARD: {
                    id = 6;
                    prefix = "\u00a7c";
                    break;
                }
                default: {
                    prefix = "\u00a70";
                    id = 15;
                }
            }
            MenuItem item = new MenuItem(Material.STAINED_CLAY, 1, id, prefix + StringUtils.capitalize((String)newD.toString().toLowerCase()));
            this.setItem(GUIUtils.convertCounterSlot(1), item);
        }

        public void updateTime(long time) {
            int hours = (int)Math.floor(time / 1000L);
            if ((hours += 6) > 23) {
                hours %= 24;
            }
            int minutes = (int)((double)(time % 1000L) / 1000.0 * 60.0);
            MenuItem item = new MenuItem(Material.WATCH, "\u00a76" + (hours < 10 ? "0" + hours : Integer.valueOf(hours)) + ":" + (minutes < 10 ? "0" + minutes : Integer.valueOf(minutes)), "\u00a78" + time);
            this.setItem(GUIUtils.convertCounterSlot(5), item);
        }

        @Override
        public void onClick(InventoryClickEvent e) {
            final Player p = (Player)e.getWhoClicked();
            int converted = GUIUtils.convertInventorySlot(e.getSlot());
            if (converted != -1) {
                switch (converted) {
                    case 1: {
                        switch (this.w.getDifficulty()) {
                            case PEACEFUL: {
                                this.w.setDifficulty(Difficulty.EASY);
                                break;
                            }
                            case EASY: {
                                this.w.setDifficulty(Difficulty.NORMAL);
                                break;
                            }
                            case NORMAL: {
                                this.w.setDifficulty(Difficulty.HARD);
                                break;
                            }
                            default: {
                                this.w.setDifficulty(Difficulty.PEACEFUL);
                            }
                        }
                        this.updateDifficulty(this.w.getDifficulty());
                        break;
                    }
                    case 3: {
                        e.getView().close();
                        p.teleport(this.w.getSpawnLocation());
                        break;
                    }
                    case 5: {
                        if (this.w.getTime() <= 23000L) {
                            this.w.setTime(this.w.getTime() + 1000L - this.w.getTime() % 1000L);
                        } else {
                            this.w.setTime(0L);
                        }
                        this.updateTime(this.w.getTime());
                        break;
                    }
                    case 7: {
                        this.w.setPVP(!this.w.getPVP());
                        this.updateBoolean(e.getSlot(), new Text("mcm.gui.world.pvp", this.lang).toString(), this.w.getPVP());
                        break;
                    }
                    case 9: {
                        new GameruleMenu(this.w, this.lang).open(p);
                        break;
                    }
                    case 11: {
                        if (ModuleManager.isValid(p, "world.unload")) {
                            if (!this.w.getPlayers().isEmpty()) {
                                p.sendMessage(MCManager.getPrefix() + new Text("mcm.gui.world.unload_error", this.lang));
                                break;
                            }
                            e.getView().close();
                            p.sendMessage(MCManager.getPrefix() + new Text("mcm.gui.world.start_unload", this.lang));
                            try {
                                Utils.unloadWorld(this.w);
                                p.sendMessage(MCManager.getPrefix() + new Text("mcm.gui.world.unloaded", this.lang));
                                new WorldsMenu(this.lang, 0).open(p);
                            }
                            catch (Exception ex) {
                                MCManager.getLog().log(Level.SEVERE, "Failed to unload world", ex);
                                p.sendMessage(Text.reportError(ex, this.lang));
                            }
                            break;
                        }
                        GUIUtils.showNoAccess(e, this.lang);
                        break;
                    }
                    case 13: {
                        if (ModuleManager.isValid(p, "world.delete")) {
                            e.getView().close();
                            if (!this.w.getPlayers().isEmpty()) {
                                p.sendMessage(MCManager.getPrefix() + new Text("mcm.gui.world.unload_error", this.lang));
                                break;
                            }
                            new SafetyPrompt(new Text("mcm.gui.world.delete_check", this.lang).toString(), this.lang){

                                @Override
                                public void onApprove(boolean approve) {
                                    if (approve) {
                                        p.sendMessage(MCManager.getPrefix() + new Text("mcm.gui.world.start_delete", this.lang));
                                        try {
                                            Utils.unloadWorld(w);
                                            FileUtils.deleteDirectory(w.getWorldFolder());
                                            p.sendMessage(MCManager.getPrefix() + new Text("mcm.gui.world.deleted", this.lang));
                                            new WorldsMenu(this.lang, 0).open(p);
                                        }
                                        catch (Exception ex) {
                                            MCManager.getLog().log(Level.SEVERE, "Failed to unload world", ex);
                                            p.sendMessage(Text.reportError(ex, this.lang));
                                        }
                                    } else {
                                        this.open(p);
                                    }
                                }
                            }.open(p);
                            break;
                        }
                        GUIUtils.showNoAccess(e, this.lang);
                    }
                }
            } else {
                switch (e.getSlot()) {
                    case 31: {
                        new WorldsMenu(this.lang, 0).open(p);
                    }
                }
            }
        }

        private static class GameruleMenu
        extends Menu {
            World w;
            int page;

            public GameruleMenu(World w, String lang) {
                this(w, lang, 0);
            }

            private GameruleMenu(World w, String lang, int page) {
                super(new Text("mcm.gui.gamerule.title", lang, w.getName()).toString(), 36, lang);
                this.w = w;
                this.page = page;
                MenuItem black = GUIUtils.black();
                for (int i = 0; i < 9; ++i) {
                    this.setItem(i, black);
                    this.setItem(27 + i, black);
                }
                this.setItem(9, black);
                this.setItem(18, black);
                this.setItem(17, black);
                this.setItem(26, black);
                this.setItem(31, GUIUtils.back(lang));
                int counter = -page * 14;
                if (page > 0) {
                    this.setItem(30, GUIUtils.previous_page(lang, page));
                }
                for (String s : w.getGameRules()) {
                    if (counter >= 0) {
                        String type;
                        if (counter == 14) {
                            this.setItem(32, GUIUtils.next_page(lang, page + 2));
                            break;
                        }
                        String value = w.getGameRuleValue(s);
                        try {
                            int i = Integer.parseInt(value);
                            type = new Text("mcm.data.int", lang).toString();
                        }
                        catch (Exception ex) {
                            type = value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false") ? new Text("mcm.data.boolean", lang).toString() : new Text("mcm.data.string", lang).toString();
                        }
                        String[] lore = new String[]{new Text("mcm.data.type", lang, type).toString(), new Text("mcm.data.value", lang, value).toString(), " ", new Text("mcm.data.change", lang).toString()};
                        MenuItem rule = new MenuItem(Material.BOOK, "\u00a79\u00a7l" + s, lore);
                        this.setItem(GUIUtils.convertCounterSlot(counter), rule);
                    }
                    ++counter;
                }
            }

            @Override
            public void onClick(final InventoryClickEvent e) {
                final Player p = (Player)e.getWhoClicked();
                int converted = GUIUtils.convertInventorySlot(e.getSlot());
                if (converted != -1) {
                    int slot = this.page * 14 + converted;
                    if (slot >= this.w.getGameRules().length) {
                        return;
                    }
                    final String gr = this.w.getGameRules()[slot];
                    if (!MCManager.requestInput(p, new SignInputHandler(){

                        @Override
                        public void handleTextInput(String[] lines) {
                            if (lines[0].isEmpty()) {
                                new NotificationPrompt(e.getInventory().getTitle(), NotificationPrompt.Type.ERROR, "You must fill in the first line of the sign. Nothing was changed.", lang){

                                    @Override
                                    public void onBack(Player p, String lang) {
                                        this.open(p);
                                    }

                                    @Override
                                    public void onContinue(Player p, String lang) {
                                        this.onBack(p, lang);
                                    }
                                }.open(p);
                            } else {
                                w.setGameRuleValue(gr, lines[0]);
                                new GameruleMenu(w, lang, page).open(p);
                            }
                        }

                        @Override
                        public String[] getDefault() {
                            return null;
                        }
                    })) {
                        p.sendMessage(MCManager.getPrefix() + "\u00a7cProtocolLib is not installed. Please install it for text input.");
                    }
                } else if (e.getSlot() == 31) {
                    new WorldMenu(this.w, this.lang).open(p);
                } else if (e.getSlot() == 30 && e.getCurrentItem().getDurability() == BlockColor.WHITE.toShort()) {
                    new GameruleMenu(this.w, this.lang, this.page - 1).open(p);
                } else if (e.getSlot() == 32 && e.getCurrentItem().getDurability() == BlockColor.WHITE.toShort()) {
                    new GameruleMenu(this.w, this.lang, this.page + 1).open(p);
                }
            }
        }
    }
}

