/*
 * Decompiled with CFR 0.152.
 */
package com.betafase.mcmanager.gui.world;

import com.betafase.mcmanager.MCManager;
import com.betafase.mcmanager.api.Menu;
import com.betafase.mcmanager.api.MenuItem;
import com.betafase.mcmanager.utils.Text;
import java.io.File;
import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.WorldCreator;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.meta.ItemMeta;

public class WorldCreateMenu
extends Menu {
    WorldCreator generator;
    public static boolean smartload = false;

    public WorldCreateMenu(WorldCreator toPass, String lang) {
        super(new Text("mcm.gui.createworld.title", lang).toString(), 9, lang);
        File newWorldFile;
        this.generator = toPass;
        if (this.generator == null) {
            this.generator = new WorldCreator("world" + Bukkit.getWorlds().size());
        }
        if (!(newWorldFile = new File(Bukkit.getWorldContainer(), this.generator.name())).exists()) {
            this.calculateGenerator();
        } else {
            this.setItem(4, new MenuItem(Material.BEDROCK, new Text("mcm.gui.createworld.exists_t", lang).toString(), new Text("mcm.gui.createworld.exists_d", lang).wordWrapAsArray(40, ChatColor.GRAY)));
        }
        this.setItem(0, this.getWorldItem(this.generator));
        this.setItem(8, new MenuItem(Material.STAINED_CLAY, 1, 5, new Text("mcm.gui.createworld.create", lang).toString()));
    }

    @Override
    public void onClick(InventoryClickEvent e) {
        Player p = (Player)e.getWhoClicked();
        switch (e.getSlot()) {
            case 8: {
                e.getView().close();
                p.sendMessage(MCManager.getPrefix() + new Text("mcm.gui.createworld.success", this.lang));
                if (!smartload) {
                    smartload = true;
                    this.generator.createWorld();
                    smartload = false;
                    p.sendMessage(MCManager.getPrefix() + new Text("mcm.gui.createworld.complete", this.lang));
                    break;
                }
                ((Player)e.getWhoClicked()).sendMessage(MCManager.getPrefix() + "\u00a7cOops! It seems like someone else is currently loading a SmartLoad\u2122 World. Please try again later.");
            }
        }
    }

    private void calculateGenerator() {
        switch (this.generator.type()) {
            default: 
        }
        this.setItem(4, new MenuItem(Material.BEDROCK, new Text("mcm.gui.createworld.unsupported_t", this.lang).toString(), new Text("mcm.gui.createworld.unsupported_d", this.lang, this.generator.type().name()).wordWrapAsArray(40, ChatColor.GRAY)));
    }

    private MenuItem getWorldItem(WorldCreator c) {
        MenuItem item = new MenuItem(Material.GRASS);
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName("\u00a79\u00a7l" + c.name());
        ArrayList<String> lore = new ArrayList<String>(6);
        switch (c.environment()) {
            case NETHER: {
                item.setType(Material.NETHERRACK);
                break;
            }
            case THE_END: {
                item.setType(Material.ENDER_STONE);
            }
        }
        lore.add(new Text("mcm.gui.createworld.i_env", this.lang, c.environment().toString()).toString());
        lore.add(new Text("mcm.gui.createworld.i_seed", this.lang, c.seed()).toString());
        if (this.generator.generator() == null) {
            lore.add(new Text("mcm.gui.createworld.i_type", this.lang, c.type().getName()).toString());
            lore.add(new Text("mcm.gui.createworld.i_gs", this.lang, c.generatorSettings()).toString());
        } else {
            lore.add(new Text("mcm.gui.createworld.i_gc", this.lang).toString());
        }
        meta.setLore(lore);
        item.setItemMeta(meta);
        return item;
    }

    @Override
    public void onClose(InventoryCloseEvent e) {
    }
}

