/*
 * Decompiled with CFR 0.152.
 */
package com.betafase.mcmanager.gui.plugin;

import com.betafase.mcmanager.MCManager;
import com.betafase.mcmanager.api.GUIUtils;
import com.betafase.mcmanager.api.Menu;
import com.betafase.mcmanager.api.MenuItem;
import com.betafase.mcmanager.api.PluginHook;
import com.betafase.mcmanager.api.UpdateChecker;
import com.betafase.mcmanager.gui.ConfigMenu;
import com.betafase.mcmanager.gui.FileMenu;
import com.betafase.mcmanager.gui.plugin.MainPluginMenu;
import com.betafase.mcmanager.security.ModuleManager;
import com.betafase.mcmanager.utils.Text;
import java.io.File;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.ChatPaginator;

public class PluginMenu
extends Menu {
    private Plugin pl;
    private UpdateChecker.UpdateInfo info = null;

    public PluginMenu(Plugin plugin, String lang) {
        super(new Text("mcm.gui.plugin.title2", lang, plugin.getName()).toString(), 36, lang);
        this.pl = plugin;
        MenuItem black = GUIUtils.black();
        for (int i = 0; i < 9; ++i) {
            this.setItem(i, black);
            this.setItem(27 + i, black);
        }
        this.setItem(9, black);
        this.setItem(18, black);
        this.setItem(17, black);
        this.setItem(26, black);
        this.setItem(31, GUIUtils.back(lang));
        String executed_file = "Unknown";
        PluginHook hook = MCManager.getPluginHook(this.pl);
        try {
            executed_file = new File(this.pl.getClass().getProtectionDomain().getCodeSource().getLocation().toURI()).getName();
        }
        catch (Exception ex) {
            Logger.getLogger(MCManager.class.getName()).log(Level.SEVERE, null, ex);
        }
        String authors = plugin.getDescription().getAuthors().toString();
        authors = authors.substring(1, authors.length() - 1);
        if (authors.isEmpty()) {
            authors = "Unknown";
        }
        MenuItem overview = new MenuItem(Material.MAGMA_CREAM, "\u00a76\u00a7l" + plugin.getName(), "\u00a77Author: \u00a76" + authors, "\u00a77Version: \u00a76" + plugin.getDescription().getVersion(), "\u00a77File: \u00a76" + executed_file);
        this.setItem(4, overview);
        boolean not_mcm = !plugin.getName().equalsIgnoreCase("MCManager") || ModuleManager.isValid("mcmanager");
        block9: for (int i = 0; i < 14; ++i) {
            if (hook.isCustomItem(i)) {
                this.setItem(GUIUtils.convertCounterSlot(i), hook.getCustomItem(i));
                continue;
            }
            switch (i) {
                case 2: {
                    if (!not_mcm) continue block9;
                    MenuItem config = new MenuItem(Material.BOOK_AND_QUILL, new Text("mcm.gui.plugin.config", lang).toString());
                    this.setItem(GUIUtils.convertCounterSlot(i), config);
                    continue block9;
                }
                case 7: {
                    if (!not_mcm) continue block9;
                    MenuItem folder = new MenuItem(Material.CHEST, new Text("mcm.gui.plugin.datafolder", lang).toString());
                    this.setItem(GUIUtils.convertCounterSlot(i), folder);
                    continue block9;
                }
                case 4: {
                    if (this.pl.isEnabled()) {
                        MenuItem disable = new MenuItem(Material.BARRIER, new Text("mcm.gui.plugin.disable", lang).toString());
                        this.setItem(GUIUtils.convertCounterSlot(i), disable);
                        continue block9;
                    }
                    MenuItem enable = new MenuItem(Material.BLAZE_POWDER, new Text("mcm.gui.plugin.enabled", lang).toString());
                    this.setItem(GUIUtils.convertCounterSlot(i), enable);
                    continue block9;
                }
                case 13: {
                    MenuItem delete = new MenuItem(Material.LAVA_BUCKET, new Text("mcm.gui.plugin.delete", lang));
                    this.setItem(GUIUtils.convertCounterSlot(i), delete);
                }
            }
        }
        if (hook.hasUpdateChecker()) {
            Bukkit.getScheduler().runTaskAsynchronously(this.pl, () -> {
                this.info = hook.getUpdateChecker().checkUpdate();
                if (this.info != null) {
                    this.info = this.info;
                    MenuItem update = new MenuItem(Material.REDSTONE_COMPARATOR);
                    ItemMeta updateMeta = update.getItemMeta();
                    updateMeta.setDisplayName("\u00a79\u00a7l" + (this.info.getTitle() == null ? "Update" : this.info.getTitle()) + " v" + this.info.getVersion());
                    LinkedList<String> lore = new LinkedList<String>();
                    if (this.info.getDescription() != null) {
                        for (String s : ChatPaginator.wordWrap((String)this.info.getDescription(), (int)40)) {
                            lore.add("\u00a77" + ChatColor.stripColor((String)s));
                        }
                    }
                    lore.add(" ");
                    lore.add(new Text("mcm.gui.spigot.download", lang, "").toString());
                    updateMeta.setLore(lore);
                    update.setItemMeta(updateMeta);
                    this.setItem(GUIUtils.convertCounterSlot(10), update);
                }
            });
        } else if (!hook.isCustomItem(10)) {
            MenuItem nope = new MenuItem(Material.BAKED_POTATO);
            ItemMeta imeta = nope.getItemMeta();
            imeta.setDisplayName("\u00a7c\u00a7l" + new Text("mcm.gui.plugin.no_updater", lang));
            imeta.setLore(new Text("mcm.gui.plugin.no_updater_text", lang).wordWrap(40, ChatColor.GRAY));
            nope.setItemMeta(imeta);
            this.setItem(GUIUtils.convertCounterSlot(10), nope);
        }
    }

    @Override
    public void onClick(InventoryClickEvent e) {
        int slot = e.getSlot();
        Player p = (Player)e.getWhoClicked();
        if (slot == 31) {
            new MainPluginMenu(this.lang, 0).open(p);
            return;
        }
        PluginHook hook = MCManager.getPluginHook(this.pl);
        int convert = GUIUtils.convertInventorySlot(slot);
        if (convert == -1) {
            return;
        }
        if (hook.isCustomItem(convert)) {
            try {
                hook.getCustomItem(convert).onClick(e);
            }
            catch (Exception ex) {
                MCManager.getLog().log(Level.SEVERE, hook.getPlugin().getName() + " caused an exception at onClick in slot " + slot, ex);
            }
            return;
        }
        switch (convert) {
            case 2: {
                if (!ModuleManager.isValid(p, "config") || this.pl.getName().equalsIgnoreCase("MCManager") && !ModuleManager.isValid(p, "mcmanager")) break;
                new ConfigMenu(this.pl, (ConfigurationSection)this.pl.getConfig(), 0, this.lang).open(p);
                break;
            }
            case 10: {
                if (e.getCurrentItem().getType() == Material.BAKED_POTATO) {
                    e.getView().close();
                    p.sendMessage("\u00a7a\u00a7nhttps://bitbucket.org/iZefix/mcmanager/issues/new");
                    break;
                }
                if (this.info == null) break;
                e.getView().close();
                Bukkit.getScheduler().runTaskAsynchronously(this.pl, () -> {
                    if (MCManager.getUpdates().contains(this.pl.getName())) {
                        MCManager.getUpdates().remove(this.pl.getName());
                    }
                    this.info.performUpdate(p);
                });
                break;
            }
            case 7: {
                if (ModuleManager.isValid(p, "file")) {
                    if (!this.pl.getName().equalsIgnoreCase("MCManager") || ModuleManager.isValid(p, "mcmanager")) {
                        new FileMenu(this.pl.getDataFolder(), this.lang, p.getUniqueId(), 0).open(p);
                        break;
                    }
                    GUIUtils.showNoAccess(e, this.lang);
                    break;
                }
                GUIUtils.showNoAccess(e, this.lang);
                break;
            }
            case 4: {
                if (this.pl.isEnabled()) {
                    try {
                        Bukkit.getPluginManager().disablePlugin(this.pl);
                        MenuItem enable = new MenuItem(Material.BLAZE_POWDER, new Text("mcm.gui.plugin.enabled", this.lang).toString());
                        this.setItem(GUIUtils.convertCounterSlot(convert), enable);
                    }
                    catch (Exception ex) {
                        e.getView().close();
                        p.sendMessage("\u00a7cFailed to disable plugin: " + ex.getMessage());
                        ex.printStackTrace();
                    }
                    break;
                }
                try {
                    Bukkit.getPluginManager().enablePlugin(this.pl);
                    MenuItem disable = new MenuItem(Material.BARRIER, new Text("mcm.gui.plugin.disable", this.lang).toString());
                    this.setItem(GUIUtils.convertCounterSlot(convert), disable);
                }
                catch (Exception ex) {
                    e.getView().close();
                    p.sendMessage("\u00a7cFailed to enable plugin: " + ex.getMessage());
                    ex.printStackTrace();
                }
                break;
            }
            case 13: {
                e.getView().close();
                try {
                    if (this.pl.isEnabled()) {
                        Bukkit.getPluginManager().disablePlugin(this.pl);
                    }
                    new File(this.pl.getClass().getProtectionDomain().getCodeSource().getLocation().toURI()).delete();
                    Bukkit.reload();
                    p.performCommand("manager plugin");
                }
                catch (Exception ex) {
                    MCManager.getLog().log(Level.SEVERE, "Failed to delete Plugin " + this.pl.getName(), ex);
                }
                break;
            }
        }
    }
}

