/*
 * Decompiled with CFR 0.152.
 */
package com.betafase.mcmanager.gui.player;

import com.betafase.mcmanager.MCManager;
import com.betafase.mcmanager.api.GUIUtils;
import com.betafase.mcmanager.api.Menu;
import com.betafase.mcmanager.api.MenuItem;
import com.betafase.mcmanager.api.SafetyPrompt;
import com.betafase.mcmanager.api.SignInputHandler;
import com.betafase.mcmanager.gui.player.MainPlayerMenu;
import com.betafase.mcmanager.gui.player.PlayerInventoryMenu;
import com.betafase.mcmanager.listener.DamageHandler;
import com.betafase.mcmanager.utils.Text;
import com.betafase.mcmanager.utils.Utils;
import java.util.LinkedList;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;

public class PlayerMenu
extends Menu {
    OfflinePlayer op;

    public PlayerMenu(OfflinePlayer p, String lang) {
        super(new Text("mcm.gui.player.title", lang, p.getName()).toString(), 36, lang);
        this.op = p;
        MenuItem black = GUIUtils.black();
        for (int i = 0; i < 9; ++i) {
            this.setItem(i, black);
            this.setItem(27 + i, black);
        }
        this.setItem(9, black);
        this.setItem(18, black);
        this.setItem(17, black);
        this.setItem(26, black);
        this.setItem(31, GUIUtils.back(lang));
        new BukkitRunnable(){

            public void run() {
                if (PlayerMenu.this.getInventory().getViewers().isEmpty()) {
                    this.cancel();
                } else {
                    PlayerMenu.this.refresh();
                }
            }
        }.runTaskTimerAsynchronously((Plugin)MCManager.getInstance(), 5L, 20L);
    }

    public void refresh() {
        MenuItem m = new MenuItem(new ItemStack(Material.SKULL_ITEM, 1, 3));
        SkullMeta meta = (SkullMeta)m.getItemMeta();
        meta.setOwner(this.op.getName());
        LinkedList<String> lore = new LinkedList<String>();
        MenuItem ban = this.op.isBanned() ? new MenuItem(Material.RED_ROSE, "\u00a7a\u00a7l" + new Text("mcm.gui.player.unban", this.lang).toString()) : new MenuItem(Material.BARRIER, "\u00a7c\u00a7l" + new Text("mcm.gui.player.ban", this.lang).toString());
        if (this.op.isOnline()) {
            Player o = this.op.getPlayer();
            meta.setDisplayName("\u00a76\u00a7l" + o.getDisplayName());
            lore.add(new Text("mcm.gui.player.health2", this.getLanguage(), o.getHealth(), o.getMaxHealth()).toString());
            lore.add(new Text("mcm.gui.player.food", this.getLanguage(), o.getFoodLevel()).toString());
            MenuItem spectate = new MenuItem(Material.EYE_OF_ENDER, "\u00a77\u00a7l" + new Text("mcm.gui.player.spectate", this.lang).toString());
            MenuItem gamemode = new MenuItem(Material.BEACON, "\u00a76\u00a7l" + new Text("mcm.gui.player.change_gamemode", this.lang), new Text("mcm.gui.player.gamemode", this.lang, o.getGameMode().toString()).toString());
            MenuItem heal = new MenuItem(Material.POTION, "\u00a7c\u00a7l" + new Text("mcm.gui.player.heal", this.lang));
            PotionMeta healMeta = (PotionMeta)heal.getItemMeta();
            healMeta.addCustomEffect(new PotionEffect(PotionEffectType.REGENERATION, 10, 2), true);
            healMeta.setMainEffect(PotionEffectType.REGENERATION);
            heal.setItemMeta((ItemMeta)healMeta);
            MenuItem food = new MenuItem(Material.COOKED_BEEF, "\u00a7e\u00a7l" + new Text("mcm.gui.player.add_food", this.lang));
            MenuItem teleportHere = new MenuItem(Material.ENDER_PEARL, "\u00a75\u00a7l" + new Text("mcm.gui.player.teleport_here", this.lang));
            MenuItem teleportTo = new MenuItem(Material.ENDER_PEARL, "\u00a75\u00a7l" + new Text("mcm.gui.player.teleport_to", this.lang));
            MenuItem fly = o.getAllowFlight() ? new MenuItem(Material.FEATHER, "\u00a7c\u00a7l" + new Text("mcm.gui.player.fly_off", this.lang)) : new MenuItem(Material.FEATHER, "\u00a7a\u00a7l" + new Text("mcm.gui.player.fly_on", this.lang));
            MenuItem invulnerable = DamageHandler.list.contains(this.op.getName()) ? new MenuItem(Material.DIAMOND_SWORD, "\u00a7c\u00a7l" + new Text("mcm.gui.player.damage", this.lang)) : new MenuItem(Material.BEDROCK, "\u00a7a\u00a7l" + new Text("mcm.gui.player.no_damage", this.lang));
            this.setMenuItem(0, new MenuItem(Material.CHEST, new Text("mcm.gui.player.manage_inv", this.lang).toString()));
            this.setMenuItem(2, teleportTo);
            this.setMenuItem(3, spectate);
            this.setMenuItem(4, teleportHere);
            this.setMenuItem(10, gamemode);
            this.setMenuItem(9, heal);
            this.setMenuItem(11, food);
            this.setMenuItem(12, invulnerable);
            this.setMenuItem(8, fly);
        } else {
            meta.setDisplayName("\u00a76\u00a7l" + this.op.getName());
            lore.add(new Text("mcm.gui.player.last_seen", this.lang, Utils.makeDateReadable(this.op.getLastPlayed())).toString());
        }
        String status = this.op.isBanned() ? "\u00a7cBANNED" : (this.op.isOp() ? "OPERATOR" : "PLAYER");
        lore.add(new Text("mcm.gui.player.status", this.lang, status).toString());
        meta.setLore(lore);
        m.setItemMeta((ItemMeta)meta);
        this.setItem(4, m);
        this.setMenuItem(6, ban);
    }

    @Override
    public void onClick(InventoryClickEvent e) {
        int slot = e.getSlot();
        final Player p = (Player)e.getWhoClicked();
        int converted = GUIUtils.convertInventorySlot(slot);
        if (converted != -1) {
            block0 : switch (converted) {
                case 0: {
                    if (!this.op.isOnline()) break;
                    new PlayerInventoryMenu(this.op.getPlayer(), this.lang).open(p);
                    break;
                }
                case 2: {
                    if (e.getCurrentItem().getType() != Material.ENDER_PEARL) break;
                    e.getView().close();
                    p.teleport(this.op.getPlayer().getLocation());
                    break;
                }
                case 3: {
                    if (e.getCurrentItem().getType() != Material.EYE_OF_ENDER) break;
                    e.getView().close();
                    p.setGameMode(GameMode.SPECTATOR);
                    p.setSpectatorTarget((Entity)this.op.getPlayer());
                    break;
                }
                case 4: {
                    if (e.getCurrentItem().getType() != Material.ENDER_PEARL) break;
                    e.getView().close();
                    this.op.getPlayer().teleport(p.getLocation());
                    break;
                }
                case 9: {
                    if (e.getCurrentItem().getType() != Material.POTION) break;
                    this.op.getPlayer().setHealth(this.op.getPlayer().getMaxHealth());
                    break;
                }
                case 10: {
                    if (e.getCurrentItem().getType() != Material.BEACON) break;
                    Player o = this.op.getPlayer();
                    GameMode current = o.getGameMode();
                    switch (current) {
                        case SURVIVAL: {
                            GameMode newMode = GameMode.CREATIVE;
                            this.op.getPlayer().setGameMode(newMode);
                            e.setCurrentItem((ItemStack)new MenuItem(Material.BEACON, "\u00a76\u00a7l" + new Text("mcm.gui.player.change_gamemode", this.lang), new Text("mcm.gui.player.gamemode", this.lang, newMode.toString()).toString()));
                            break block0;
                        }
                        case CREATIVE: {
                            GameMode newMode = GameMode.ADVENTURE;
                            this.op.getPlayer().setGameMode(newMode);
                            e.setCurrentItem((ItemStack)new MenuItem(Material.BEACON, "\u00a76\u00a7l" + new Text("mcm.gui.player.change_gamemode", this.lang), new Text("mcm.gui.player.gamemode", this.lang, newMode.toString()).toString()));
                            break block0;
                        }
                        case ADVENTURE: {
                            GameMode newMode = GameMode.SPECTATOR;
                            this.op.getPlayer().setGameMode(newMode);
                            e.setCurrentItem((ItemStack)new MenuItem(Material.BEACON, "\u00a76\u00a7l" + new Text("mcm.gui.player.change_gamemode", this.lang), new Text("mcm.gui.player.gamemode", this.lang, newMode.toString()).toString()));
                            break block0;
                        }
                        case SPECTATOR: {
                            GameMode newMode = GameMode.SURVIVAL;
                            this.op.getPlayer().setGameMode(newMode);
                            e.setCurrentItem((ItemStack)new MenuItem(Material.BEACON, "\u00a76\u00a7l" + new Text("mcm.gui.player.change_gamemode", this.lang), new Text("mcm.gui.player.gamemode", this.lang, newMode.toString()).toString()));
                        }
                    }
                    break;
                }
                case 11: {
                    if (e.getCurrentItem().getType() != Material.COOKED_BEEF) break;
                    this.op.getPlayer().setFoodLevel(20);
                    break;
                }
                case 12: {
                    if (e.getCurrentItem().getType() == Material.BEDROCK) {
                        DamageHandler.list.add(this.op.getName());
                        e.setCurrentItem((ItemStack)new MenuItem(Material.DIAMOND_SWORD, "\u00a7c\u00a7l" + new Text("mcm.gui.player.damage", this.lang)));
                        break;
                    }
                    DamageHandler.list.remove(this.op.getName());
                    e.setCurrentItem((ItemStack)new MenuItem(Material.BEDROCK, "\u00a7a\u00a7l" + new Text("mcm.gui.player.no_damage", this.lang)));
                    break;
                }
                case 8: {
                    if (e.getCurrentItem().getType() != Material.FEATHER) break;
                    Player pl = p.getPlayer();
                    if (pl.getAllowFlight()) {
                        pl.setAllowFlight(false);
                        e.setCurrentItem((ItemStack)new MenuItem(Material.FEATHER, "\u00a7a\u00a7l" + new Text("mcm.gui.player.fly_on", this.lang)));
                        break;
                    }
                    pl.setAllowFlight(true);
                    e.setCurrentItem((ItemStack)new MenuItem(Material.FEATHER, "\u00a7c\u00a7l" + new Text("mcm.gui.player.fly_off", this.lang)));
                    break;
                }
                case 6: {
                    if (e.getCurrentItem().getType() == Material.BARRIER) {
                        e.getView().close();
                        if (MCManager.requestInput(p, new SignInputHandler(){

                            @Override
                            public void handleTextInput(final String[] lines) {
                                new SafetyPrompt("Ban " + PlayerMenu.this.op.getName() + "?", PlayerMenu.this.lang){

                                    @Override
                                    public void onApprove(boolean approve) {
                                        if (approve) {
                                            p.performCommand(MCManager.getConfiguration().getString("ban_command").replaceAll("%player%", PlayerMenu.this.op.getName()).replaceAll("%arg0%", lines[0]).replaceAll("%arg1%", lines[1]).replaceAll("%arg2%", lines[2]).replaceAll("%arg3%", lines[3]));
                                        } else {
                                            PlayerMenu.this.open(p);
                                        }
                                    }
                                }.open(p);
                            }

                            @Override
                            public String[] getDefault() {
                                return new String[]{"You are", "banned from", "the server", ""};
                            }
                        })) break;
                        TextComponent proceedBan = new TextComponent(new Text("mcm.gui.player.proceed_ban", this.lang).toString());
                        proceedBan.setClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/ban " + this.op.getName() + " "));
                        TextComponent backBan = new TextComponent(new Text("mcm.gui.player.back_ban", this.lang).toString());
                        backBan.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/manager player " + this.op.getName()));
                        p.spigot().sendMessage(new BaseComponent[]{proceedBan, backBan});
                        break;
                    }
                    p.performCommand("pardon " + this.op.getName());
                    this.refresh();
                }
            }
        } else {
            switch (slot) {
                case 31: {
                    new MainPlayerMenu(this.getLanguage(), 0, !this.op.isOnline()).open(p);
                }
            }
        }
    }
}

